/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.TopicModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class ViewConfigurationModel {
    private Map<String, TopicModel> viewConfig = new HashMap<String, TopicModel>();

    public ViewConfigurationModel() {
    }

    public ViewConfigurationModel(List<TopicModel> configTopics) {
        for (TopicModel topic : configTopics) {
            this.addConfigTopic(topic);
        }
    }

    public ViewConfigurationModel(JSONObject configurable) {
        try {
            JSONArray topics = configurable.optJSONArray("view_config_topics");
            if (topics != null) {
                for (int i = 0; i < topics.length(); ++i) {
                    this.addConfigTopic(new TopicModel(topics.getJSONObject(i)));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing ViewConfigurationModel failed (JSONObject=" + configurable + ")", e);
        }
    }

    public Iterable<TopicModel> getConfigTopics() {
        return this.viewConfig.values();
    }

    public void addConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) != null) {
            throw new RuntimeException("There is already a view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.viewConfig.put(configTypeUri, configTopic);
    }

    public void updateConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        TopicModel confTopic = this.getConfigTopic(configTypeUri);
        if (confTopic == null) {
            throw new RuntimeException("There is no view configuration topic of type \"" + configTypeUri + "\"");
        }
        confTopic.set(configTopic);
    }

    public Object getSetting(String configTypeUri, String settingUri) {
        TopicModel configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            return null;
        }
        ChildTopicsModel childTopics = configTopic.getChildTopicsModel();
        return childTopics.has(settingUri) ? childTopics.getObject(settingUri) : null;
    }

    public void toJSON(JSONObject configurable) {
        try {
            ArrayList<JSONObject> viewConfigTopics = new ArrayList<JSONObject>();
            for (TopicModel configTopic : this.getConfigTopics()) {
                viewConfigTopics.add(configTopic.toJSON());
            }
            configurable.put("view_config_topics", viewConfigTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public String toString() {
        return "view configuration " + this.viewConfig;
    }

    private TopicModel getConfigTopic(String configTypeUri) {
        return this.viewConfig.get(configTypeUri);
    }
}

