/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import java.util.List;

public class TopicReferenceModel
extends RelatedTopicModel {
    public TopicReferenceModel(long topicId) {
        super(topicId);
    }

    public TopicReferenceModel(long topicId, AssociationModel relatingAssoc) {
        super(topicId, relatingAssoc);
    }

    public TopicReferenceModel(String topicUri) {
        super(topicUri);
    }

    public TopicReferenceModel(String topicUri, AssociationModel relatingAssoc) {
        super(topicUri, relatingAssoc);
    }

    public TopicReferenceModel(long topicId, ChildTopicsModel relatingAssocChildTopics) {
        super(topicId, new AssociationModel(relatingAssocChildTopics));
    }

    public TopicReferenceModel(String topicUri, ChildTopicsModel relatingAssocChildTopics) {
        super(topicUri, new AssociationModel(relatingAssocChildTopics));
    }

    public boolean isReferenceById() {
        return this.getId() != -1L;
    }

    public boolean isReferenceByUri() {
        return this.getUri() != null && !this.getUri().equals("");
    }

    public boolean isReferingTo(Topic topic) {
        if (this.isReferenceById()) {
            return this.getId() == topic.getId();
        }
        if (this.isReferenceByUri()) {
            return this.getUri().equals(topic.getUri());
        }
        throw new RuntimeException("Invalid topic reference (" + this + ")");
    }

    public RelatedTopic findReferencedTopic(List<RelatedTopic> topics) {
        for (RelatedTopic topic : topics) {
            if (!this.isReferingTo(topic)) continue;
            return topic;
        }
        return null;
    }

    @Override
    public String toString() {
        return "reference " + super.toString();
    }
}

