/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.RelatedTopicModel;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public enum IndexMode {
    OFF,
    KEY,
    FULLTEXT,
    FULLTEXT_KEY;

    private static final String INDEX_MODES_NAMESPACE = "dm4.core.";

    public static List<IndexMode> fromTopics(List<RelatedTopicModel> topics) {
        ArrayList<IndexMode> indexModes = new ArrayList<IndexMode>();
        for (RelatedTopicModel topic : topics) {
            indexModes.add(IndexMode.fromUri(topic.getUri()));
        }
        return indexModes;
    }

    public String toUri() {
        return INDEX_MODES_NAMESPACE + this.name().toLowerCase();
    }

    static List<IndexMode> parse(JSONObject topicTypeModel) {
        try {
            ArrayList<IndexMode> indexModes = new ArrayList<IndexMode>();
            JSONArray indexModeUris = topicTypeModel.optJSONArray("index_mode_uris");
            if (indexModeUris != null) {
                for (int i = 0; i < indexModeUris.length(); ++i) {
                    indexModes.add(IndexMode.fromUri(indexModeUris.getString(i)));
                }
            }
            return indexModes;
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing index modes failed (topicTypeModel=" + topicTypeModel + ")", e);
        }
    }

    static void toJSON(List<IndexMode> indexModes, JSONObject o) throws Exception {
        ArrayList<String> indexModeUris = new ArrayList<String>();
        for (IndexMode indexMode : indexModes) {
            indexModeUris.add(indexMode.toUri());
        }
        o.put("index_mode_uris", indexModeUris);
    }

    private static IndexMode fromUri(String uri) {
        if (!uri.startsWith(INDEX_MODES_NAMESPACE)) {
            throw new RuntimeException("\"" + uri + "\" is not a valid index mode URI");
        }
        String name = uri.substring(INDEX_MODES_NAMESPACE.length()).toUpperCase();
        return IndexMode.valueOf(name);
    }
}

