/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AssociationDefinitionModel
extends AssociationModel {
    private String customAssocTypeUri;
    private String parentTypeUri;
    private String childTypeUri;
    private String parentCardinalityUri;
    private String childCardinalityUri;
    private ViewConfigurationModel viewConfigModel;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public AssociationDefinitionModel(String assocTypeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri) {
        this(assocTypeUri, null, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri);
    }

    public AssociationDefinitionModel(String assocTypeUri, String customAssocTypeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri) {
        this(-1L, null, assocTypeUri, customAssocTypeUri, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri, null);
    }

    public AssociationDefinitionModel(long id, String uri, String assocTypeUri, String customAssocTypeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModel viewConfigModel) {
        super(id, uri, assocTypeUri, AssociationDefinitionModel.parentRoleModel(parentTypeUri), AssociationDefinitionModel.childRoleModel(childTypeUri));
        this.customAssocTypeUri = customAssocTypeUri;
        this.parentTypeUri = parentTypeUri;
        this.childTypeUri = childTypeUri;
        this.parentCardinalityUri = parentCardinalityUri;
        this.childCardinalityUri = childCardinalityUri;
        this.viewConfigModel = viewConfigModel != null ? viewConfigModel : new ViewConfigurationModel();
    }

    AssociationDefinitionModel(JSONObject assocDef) throws JSONException {
        super(assocDef.optLong("id", -1L), null, assocDef.getString("assoc_type_uri"), AssociationDefinitionModel.parentRoleModel(assocDef), AssociationDefinitionModel.childRoleModel(assocDef));
        this.customAssocTypeUri = assocDef.isNull("custom_assoc_type_uri") ? null : assocDef.getString("custom_assoc_type_uri");
        this.parentTypeUri = this.parentTypeUri();
        this.childTypeUri = this.childTypeUri();
        if (!assocDef.has("parent_cardinality_uri") && !this.typeUri.equals("dm4.core.composition_def")) {
            throw new RuntimeException("\"parent_cardinality_uri\" is missing");
        }
        this.parentCardinalityUri = assocDef.optString("parent_cardinality_uri", "dm4.core.one");
        this.childCardinalityUri = assocDef.getString("child_cardinality_uri");
        this.viewConfigModel = new ViewConfigurationModel(assocDef);
    }

    public String getCustomAssocTypeUri() {
        return this.customAssocTypeUri;
    }

    public String getInstanceLevelAssocTypeUri() {
        return this.customAssocTypeUri != null ? this.customAssocTypeUri : this.defaultInstanceLevelAssocTypeUri();
    }

    public String getParentTypeUri() {
        return this.parentTypeUri;
    }

    public String getChildTypeUri() {
        return this.childTypeUri;
    }

    public String getParentCardinalityUri() {
        return this.parentCardinalityUri;
    }

    public String getChildCardinalityUri() {
        return this.childCardinalityUri;
    }

    public ViewConfigurationModel getViewConfigModel() {
        return this.viewConfigModel;
    }

    public void setCustomAssocTypeUri(String customAssocTypeUri) {
        this.customAssocTypeUri = customAssocTypeUri;
    }

    public void setParentCardinalityUri(String parentCardinalityUri) {
        this.parentCardinalityUri = parentCardinalityUri;
    }

    public void setChildCardinalityUri(String childCardinalityUri) {
        this.childCardinalityUri = childCardinalityUri;
    }

    public void setViewConfigModel(ViewConfigurationModel viewConfigModel) {
        this.viewConfigModel = viewConfigModel;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = super.toJSON();
            o.put("parent_cardinality_uri", (Object)this.parentCardinalityUri);
            o.put("child_cardinality_uri", (Object)this.childCardinalityUri);
            o.put("custom_assoc_type_uri", this.customAssocTypeUri != null ? this.customAssocTypeUri : JSONObject.NULL);
            this.viewConfigModel.toJSON(o);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public String toString() {
        return "\n    association definition (" + super.toString() + ",\n        parent cardinality=\"" + this.parentCardinalityUri + "\",\n        child cardinality=\"" + this.childCardinalityUri + "\",\n        custom association type=\"" + this.customAssocTypeUri + "\",\n        " + this.viewConfigModel + ")\n";
    }

    static void toJSON(Collection<AssociationDefinitionModel> assocDefs, JSONObject o) throws Exception {
        ArrayList<JSONObject> assocDefList = new ArrayList<JSONObject>();
        for (AssociationDefinitionModel assocDef : assocDefs) {
            assocDefList.add(assocDef.toJSON());
        }
        o.put("assoc_defs", assocDefList);
    }

    private static TopicRoleModel parentRoleModel(JSONObject assocDef) throws JSONException {
        return AssociationDefinitionModel.parentRoleModel(assocDef.getString("parent_type_uri"));
    }

    private static TopicRoleModel childRoleModel(JSONObject assocDef) throws JSONException {
        return AssociationDefinitionModel.childRoleModel(assocDef.getString("child_type_uri"));
    }

    private static TopicRoleModel parentRoleModel(String parentTypeUri) {
        return new TopicRoleModel(parentTypeUri, "dm4.core.parent_type");
    }

    private static TopicRoleModel childRoleModel(String childTypeUri) {
        return new TopicRoleModel(childTypeUri, "dm4.core.child_type");
    }

    private String parentTypeUri() {
        return ((TopicRoleModel)this.getRoleModel("dm4.core.parent_type")).getTopicUri();
    }

    private String childTypeUri() {
        return ((TopicRoleModel)this.getRoleModel("dm4.core.child_type")).getTopicUri();
    }

    private String defaultInstanceLevelAssocTypeUri() {
        if (this.typeUri.equals("dm4.core.aggregation_def")) {
            return "dm4.core.aggregation";
        }
        if (this.typeUri.equals("dm4.core.composition_def")) {
            return "dm4.core.composition";
        }
        throw new RuntimeException("Unexpected association type URI: \"" + this.typeUri + "\"");
    }
}

