/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationType;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AttachedAssociationType;
import de.deepamehta.core.impl.AttachedTopicType;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.TopicTypeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

class TypeCache {
    private Map<String, TopicType> topicTypes = new HashMap<String, TopicType>();
    private Map<String, AssociationType> assocTypes = new HashMap<String, AssociationType>();
    private EmbeddedService dms;
    private EndlessRecursionDetection endlessRecursionDetection = new EndlessRecursionDetection();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeCache(EmbeddedService dms) {
        this.dms = dms;
    }

    TopicType getTopicType(String topicTypeUri) {
        TopicType topicType = this.topicTypes.get(topicTypeUri);
        if (topicType == null) {
            topicType = this.loadTopicType(topicTypeUri);
            this.putTopicType(topicType);
        }
        return topicType;
    }

    AssociationType getAssociationType(String assocTypeUri) {
        AssociationType assocType = this.assocTypes.get(assocTypeUri);
        if (assocType == null) {
            assocType = this.loadAssociationType(assocTypeUri);
            this.putAssociationType(assocType);
        }
        return assocType;
    }

    void putTopicType(TopicType topicType) {
        this.topicTypes.put(topicType.getUri(), topicType);
    }

    void putAssociationType(AssociationType assocType) {
        this.assocTypes.put(assocType.getUri(), assocType);
    }

    void removeTopicType(String topicTypeUri) {
        this.logger.info("### Removing topic type \"" + topicTypeUri + "\" from type cache");
        if (this.topicTypes.remove(topicTypeUri) == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in type cache");
        }
        this.dms.typeStorage.removeFromTypeCache(topicTypeUri);
    }

    void removeAssociationType(String assocTypeUri) {
        this.logger.info("### Removing association type \"" + assocTypeUri + "\" from type cache");
        if (this.assocTypes.remove(assocTypeUri) == null) {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not found in type cache");
        }
        this.dms.typeStorage.removeFromTypeCache(assocTypeUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicType loadTopicType(String topicTypeUri) {
        try {
            this.logger.info("Loading topic type \"" + topicTypeUri + "\"");
            this.endlessRecursionDetection.check(topicTypeUri);
            TopicTypeModel model = this.dms.typeStorage.getTopicType(topicTypeUri);
            AttachedTopicType attachedTopicType = new AttachedTopicType(model, this.dms);
            return attachedTopicType;
        }
        finally {
            this.endlessRecursionDetection.reset(topicTypeUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssociationType loadAssociationType(String assocTypeUri) {
        try {
            this.logger.info("Loading association type \"" + assocTypeUri + "\"");
            this.endlessRecursionDetection.check(assocTypeUri);
            AssociationTypeModel model = this.dms.typeStorage.getAssociationType(assocTypeUri);
            AttachedAssociationType attachedAssociationType = new AttachedAssociationType(model, this.dms);
            return attachedAssociationType;
        }
        finally {
            this.endlessRecursionDetection.reset(assocTypeUri);
        }
    }

    private class EndlessRecursionDetection {
        private Map<String, Boolean> loadInProgress = new HashMap<String, Boolean>();

        private EndlessRecursionDetection() {
        }

        private void check(String typeUri) {
            if (this.loadInProgress.get(typeUri) != null) {
                throw new RuntimeException("Endless recursion detected while loading type \"" + typeUri + "\"");
            }
            this.loadInProgress.put(typeUri, true);
        }

        private void reset(String typeUri) {
            this.loadInProgress.remove(typeUri);
        }
    }
}

