/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.service.Directives;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;

class JerseyResponseFilter
implements ContainerResponseFilter {
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    JerseyResponseFilter(EmbeddedService dms) {
        this.dms = dms;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        try {
            this.dms.fireEvent(CoreEvent.SERVICE_RESPONSE_FILTER, response);
            Object entity = response.getEntity();
            boolean includeChilds = this.getIncludeChilds(request);
            boolean includeAssocChilds = this.getIncludeAssocChilds(request);
            if (entity != null) {
                if (entity instanceof DeepaMehtaObject) {
                    this.loadChildTopics((DeepaMehtaObject)entity, includeChilds, includeAssocChilds);
                } else if (this.isIterable(response, DeepaMehtaObject.class)) {
                    this.loadChildTopics((Iterable)entity, includeChilds, includeAssocChilds);
                }
                if (entity instanceof TopicType) {
                    this.firePreSend((TopicType)entity);
                } else if (entity instanceof AssociationType) {
                    this.firePreSend((AssociationType)entity);
                } else if (entity instanceof Topic) {
                    this.firePreSend((Topic)entity);
                } else if (entity instanceof Association) {
                    this.firePreSend((Association)entity);
                } else if (entity instanceof Directives) {
                    this.firePreSend((Directives)entity);
                } else if (this.isIterable(response, TopicType.class)) {
                    this.firePreSendTopicTypes((Iterable)entity);
                } else if (this.isIterable(response, AssociationType.class)) {
                    this.firePreSendAssociationTypes((Iterable)entity);
                } else if (this.isIterable(response, Topic.class)) {
                    this.firePreSendTopics((Iterable)entity);
                }
            }
            this.logger.fine("### Removing tread-local directives");
            Directives.remove();
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Jersey response filtering failed", e);
        }
    }

    private void loadChildTopics(DeepaMehtaObject object, boolean includeChilds, boolean includeAssocChilds) {
        if (includeChilds) {
            object.loadChildTopics();
            if (includeAssocChilds) {
                this.loadRelatingAssociationChildTopics(object);
            }
        }
    }

    private void loadChildTopics(Iterable<DeepaMehtaObject> objects, boolean includeChilds, boolean includeAssocChilds) {
        if (includeChilds) {
            for (DeepaMehtaObject object : objects) {
                object.loadChildTopics();
            }
            if (includeAssocChilds) {
                for (DeepaMehtaObject object : objects) {
                    this.loadRelatingAssociationChildTopics(object);
                }
            }
        }
    }

    private void loadRelatingAssociationChildTopics(DeepaMehtaObject object) {
        ChildTopics childTopics = object.getChildTopics();
        for (String childTypeUri : childTopics) {
            Object value = childTopics.get(childTypeUri);
            if (value instanceof RelatedTopic) {
                RelatedTopic childTopic = (RelatedTopic)value;
                childTopic.getRelatingAssociation().loadChildTopics();
                this.loadRelatingAssociationChildTopics(childTopic);
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopic childTopic : (List)value) {
                    childTopic.getRelatingAssociation().loadChildTopics();
                    this.loadRelatingAssociationChildTopics(childTopic);
                }
                continue;
            }
            throw new RuntimeException("Unexpected \"" + childTypeUri + "\" value in ChildTopics: " + value);
        }
    }

    private void firePreSend(Topic topic) {
        this.dms.fireEvent(CoreEvent.PRE_SEND_TOPIC, topic);
    }

    private void firePreSend(Association assoc) {
        this.dms.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION, assoc);
    }

    private void firePreSend(TopicType topicType) {
        this.dms.fireEvent(CoreEvent.PRE_SEND_TOPIC_TYPE, topicType);
    }

    private void firePreSend(AssociationType assocType) {
        this.dms.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION_TYPE, assocType);
    }

    private void firePreSend(Directives directives) {
        for (Directives.Entry entry : directives) {
            switch (entry.dir) {
                case UPDATE_TOPIC: {
                    this.firePreSend((Topic)entry.arg);
                    break;
                }
                case UPDATE_ASSOCIATION: {
                    this.firePreSend((Association)entry.arg);
                    break;
                }
                case UPDATE_TOPIC_TYPE: {
                    this.firePreSend((TopicType)entry.arg);
                    break;
                }
                case UPDATE_ASSOCIATION_TYPE: {
                    this.firePreSend((AssociationType)entry.arg);
                }
            }
        }
    }

    private void firePreSendTopics(Iterable<Topic> topics) {
        for (Topic topic : topics) {
            this.firePreSend(topic);
        }
    }

    private void firePreSendTopicTypes(Iterable<TopicType> topicTypes) {
        for (TopicType topicType : topicTypes) {
            this.firePreSend(topicType);
        }
    }

    private void firePreSendAssociationTypes(Iterable<AssociationType> assocTypes) {
        for (AssociationType assocType : assocTypes) {
            this.firePreSend(assocType);
        }
    }

    private boolean isIterable(ContainerResponse response, Class elementType) {
        Type genericType = response.getEntityType();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
            Class<?> type = response.getEntity().getClass();
            if (typeArgs.length == 1 && Iterable.class.isAssignableFrom(type) && elementType.isAssignableFrom((Class)typeArgs[0])) {
                return true;
            }
        }
        return false;
    }

    private boolean getIncludeChilds(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "include_childs");
    }

    private boolean getIncludeAssocChilds(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "include_assoc_childs");
    }

    private boolean getBooleanQueryParameter(ContainerRequest request, String param) {
        return Boolean.parseBoolean((String)request.getQueryParameters().getFirst((Object)param));
    }
}

