/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.PluginImpl;
import de.deepamehta.core.osgi.PluginContext;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.EventListener;
import de.deepamehta.core.service.accesscontrol.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;

class EventManager {
    private Map<String, List<EventListener>> listenerRegistry = new HashMap<String, List<EventListener>>();
    private DeepaMehtaService dms;

    EventManager(DeepaMehtaService dms) {
        this.dms = dms;
        new CoreEvent();
    }

    void addListener(DeepaMehtaEvent event, EventListener listener) {
        List<EventListener> listeners = this.getListeners(event);
        if (listeners == null) {
            listeners = new ArrayList<EventListener>();
            this.putListeners(event, listeners);
        }
        listeners.add(listener);
    }

    void removeListener(DeepaMehtaEvent event, EventListener listener) {
        List<EventListener> listeners = this.getListeners(event);
        if (!listeners.remove(listener)) {
            throw new RuntimeException("Removing " + listener + " from " + event + " event listeners failed: not found in " + listeners);
        }
    }

    void fireEvent(DeepaMehtaEvent event, Object ... params) {
        List<EventListener> listeners = this.getListeners(event);
        if (listeners != null) {
            for (EventListener listener : listeners) {
                this.deliverEvent(listener, event, params);
            }
        }
    }

    void deliverEvent(PluginImpl plugin, DeepaMehtaEvent event, Object ... params) {
        PluginContext pluginContext = plugin.getContext();
        if (!this.isListener(pluginContext, event)) {
            return;
        }
        this.deliverEvent((EventListener)((Object)pluginContext), event, params);
    }

    void deliverEvent(String pluginUri, DeepaMehtaEvent event, Object ... params) {
        this.deliverEvent((PluginImpl)this.dms.getPlugin(pluginUri), event, params);
    }

    private void deliverEvent(EventListener listener, DeepaMehtaEvent event, Object ... params) {
        try {
            event.deliver(listener, params);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("An error occurred in the " + event.getListenerInterface().getSimpleName() + " of " + listener, e);
        }
    }

    private boolean isListener(PluginContext pluginContext, DeepaMehtaEvent event) {
        return event.getListenerInterface().isAssignableFrom(pluginContext.getClass());
    }

    private List<EventListener> getListeners(DeepaMehtaEvent event) {
        return this.listenerRegistry.get(event.getClass().getName());
    }

    private void putListeners(DeepaMehtaEvent event, List<EventListener> listeners) {
        this.listenerRegistry.put(event.getClass().getName(), listeners);
    }
}

