/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Topic;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.HashMap;
import java.util.Map;

class AttachedViewConfiguration
implements ViewConfiguration {
    private Map<String, Topic> configTopics = new HashMap<String, Topic>();
    private final ViewConfigurationModel model;
    private final RoleModel configurable;
    private final EmbeddedService dms;

    AttachedViewConfiguration(RoleModel configurable, ViewConfigurationModel model, EmbeddedService dms) {
        this.configurable = configurable;
        this.model = model;
        this.dms = dms;
        this.initConfigTopics();
    }

    @Override
    public Iterable<Topic> getConfigTopics() {
        return this.configTopics.values();
    }

    @Override
    public void addSetting(String configTypeUri, String settingUri, Object value) {
        Topic configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            configTopic = this.dms.typeStorage.storeViewConfigTopic(this.configurable, new TopicModel(configTypeUri));
            this.model.addConfigTopic(configTopic.getModel());
            this.addConfigTopic(configTopic);
        }
        configTopic.getChildTopics().set(settingUri, value);
    }

    @Override
    public void updateConfigTopic(TopicModel configTopic) {
        this.model.updateConfigTopic(configTopic);
    }

    @Override
    public ViewConfigurationModel getModel() {
        return this.model;
    }

    private void initConfigTopics() {
        for (TopicModel configTopic : this.model.getConfigTopics()) {
            this.addConfigTopic(new AttachedTopic(configTopic, this.dms));
        }
    }

    private Topic getConfigTopic(String configTypeUri) {
        return this.configTopics.get(configTypeUri);
    }

    private void addConfigTopic(Topic configTopic) {
        this.configTopics.put(configTopic.getTypeUri(), configTopic);
    }
}

