/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AttachedType;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import java.util.List;
import java.util.logging.Logger;

class AttachedTopicType
extends AttachedType
implements TopicType {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedTopicType(TopicTypeModel model, EmbeddedService dms) {
        super(model, dms);
    }

    @Override
    public TopicTypeModel getModel() {
        return (TopicTypeModel)super.getModel();
    }

    @Override
    public void update(TopicTypeModel model) {
        this.logger.info("Updating topic type \"" + this.getUri() + "\" (new " + model + ")");
        Directives.get().add(Directive.UPDATE_TOPIC_TYPE, this);
        super.update(model);
    }

    @Override
    final String className() {
        return "topic type";
    }

    @Override
    final void putInTypeCache() {
        this.dms.typeCache.putTopicType(this);
    }

    @Override
    final void removeFromTypeCache() {
        this.dms.typeCache.removeTopicType(this.getUri());
    }

    @Override
    final Directive getDeleteTypeDirective() {
        return Directive.DELETE_TOPIC_TYPE;
    }

    @Override
    final List<? extends DeepaMehtaObject> getAllInstances() {
        return this.dms.getTopics(this.getUri(), 0).getItems();
    }
}

