/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.service.accesscontrol.AccessControl;
import de.deepamehta.core.service.accesscontrol.Credentials;
import de.deepamehta.core.service.accesscontrol.Operation;
import de.deepamehta.core.service.accesscontrol.SharingMode;
import java.util.logging.Logger;

class AccessControlImpl
implements AccessControl {
    private static final String TYPE_MEMBERSHIP = "dm4.accesscontrol.membership";
    private static final String TYPE_USERNAME = "dm4.accesscontrol.username";
    private static final String PROP_OWNER = "dm4.accesscontrol.owner";
    private static final String PROP_WORKSPACE_ID = "dm4.workspaces.workspace_id";
    private static final String SYSTEM_WORKSPACE_URI = "dm4.workspaces.system";
    private long systemWorkspaceId = -1L;
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AccessControlImpl(EmbeddedService dms) {
        this.dms = dms;
    }

    @Override
    public boolean checkCredentials(Credentials cred) {
        TopicModel usernameTopic = null;
        try {
            usernameTopic = this.getUsernameTopic(cred.username);
            if (usernameTopic == null) {
                return false;
            }
            return this.matches(usernameTopic, cred.password);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking credentials for user \"" + cred.username + "\" failed (usernameTopic=" + usernameTopic + ")", e);
        }
    }

    @Override
    public boolean hasPermission(String username, Operation operation, long objectId) {
        String typeUri = null;
        try {
            long workspaceId;
            typeUri = this.getTypeUri(objectId);
            if (typeUri.equals("dm4.workspaces.workspace")) {
                workspaceId = objectId;
            } else {
                workspaceId = this.getAssignedWorkspaceId(objectId);
                if (workspaceId == -1L) {
                    switch (operation) {
                        case READ: {
                            this.logger.fine("Object " + objectId + " (typeUri=\"" + typeUri + "\") is not assigned to any workspace -- READ permission is granted");
                            return true;
                        }
                        case WRITE: {
                            this.logger.warning("Object " + objectId + " (typeUri=\"" + typeUri + "\") is not assigned to any workspace -- WRITE permission is refused");
                            return false;
                        }
                    }
                    throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
                }
            }
            return this._hasPermission(username, operation, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking permission for object " + objectId + " (typeUri=\"" + typeUri + "\") failed (" + this.userInfo(username) + ", operation=" + (Object)((Object)operation) + ")", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            AssociationModel membership = this.dms.storageDecorator.fetchAssociation(TYPE_MEMBERSHIP, this.getUsernameTopicOrThrow(username).getId(), workspaceId, "dm4.core.default", "dm4.core.default");
            return membership != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking membership of user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public void assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        this.dms.associationFactory(new AssociationModel("dm4.core.aggregation", new TopicRoleModel(object.getId(), "dm4.core.parent"), new TopicRoleModel(workspaceId, "dm4.core.child")));
        object.setProperty(PROP_WORKSPACE_ID, workspaceId, false);
    }

    private boolean matches(TopicModel usernameTopic, String password) {
        return this.getPassword(this.getUserAccount(usernameTopic)).equals(password);
    }

    private TopicModel getUserAccount(TopicModel usernameTopic) {
        RelatedTopicModel userAccount = this.dms.storageDecorator.fetchTopicRelatedTopic(usernameTopic.getId(), "dm4.core.composition", "dm4.core.child", "dm4.core.parent", "dm4.accesscontrol.user_account");
        if (userAccount == null) {
            throw new RuntimeException("Data inconsistency: there is no User Account topic for username \"" + usernameTopic.getSimpleValue() + "\" (usernameTopic=" + usernameTopic + ")");
        }
        return userAccount;
    }

    private String getPassword(TopicModel userAccount) {
        RelatedTopicModel password = this.dms.storageDecorator.fetchTopicRelatedTopic(userAccount.getId(), "dm4.core.composition", "dm4.core.parent", "dm4.core.child", "dm4.accesscontrol.password");
        if (password == null) {
            throw new RuntimeException("Data inconsistency: there is no Password topic for User Account \"" + userAccount.getSimpleValue() + "\" (userAccount=" + userAccount + ")");
        }
        return password.getSimpleValue().toString();
    }

    private boolean _hasPermission(String username, Operation operation, long workspaceId) {
        switch (operation) {
            case READ: {
                return this.hasReadPermission(username, workspaceId);
            }
            case WRITE: {
                return this.hasWritePermission(username, workspaceId);
            }
        }
        throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
    }

    private boolean hasReadPermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return workspaceId != this.getSystemWorkspaceId() || username != null;
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    private boolean hasWritePermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    private long getAssignedWorkspaceId(long objectId) {
        return this.dms.hasProperty(objectId, PROP_WORKSPACE_ID) ? (Long)this.dms.getProperty(objectId, PROP_WORKSPACE_ID) : -1L;
    }

    private boolean isOwner(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            return this.getOwner(workspaceId).equals(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking ownership of workspace " + workspaceId + " and user \"" + username + "\" failed", e);
        }
    }

    private SharingMode getSharingMode(long workspaceId) {
        RelatedTopicModel sharingMode = this.dms.storageDecorator.fetchTopicRelatedTopic(workspaceId, "dm4.core.aggregation", "dm4.core.parent", "dm4.core.child", "dm4.workspaces.sharing_mode");
        if (sharingMode == null) {
            throw new RuntimeException("No sharing mode is assigned to workspace " + workspaceId);
        }
        return SharingMode.fromString(sharingMode.getUri());
    }

    private String getOwner(long workspaceId) {
        if (!this.dms.storageDecorator.hasProperty(workspaceId, PROP_OWNER)) {
            throw new RuntimeException("No owner is assigned to workspace " + workspaceId);
        }
        return (String)this.dms.storageDecorator.fetchProperty(workspaceId, PROP_OWNER);
    }

    private String getTypeUri(long objectId) {
        return (String)this.dms.storageDecorator.fetchProperty(objectId, "type_uri");
    }

    private TopicModel getUsernameTopic(String username) {
        return this.dms.storageDecorator.fetchTopic(TYPE_USERNAME, new SimpleValue(username));
    }

    private TopicModel getUsernameTopicOrThrow(String username) {
        TopicModel usernameTopic = this.getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    long getSystemWorkspaceId() {
        if (this.systemWorkspaceId != -1L) {
            return this.systemWorkspaceId;
        }
        TopicModel workspace = this.dms.storageDecorator.fetchTopic("uri", new SimpleValue(SYSTEM_WORKSPACE_URI));
        if (workspace == null) {
            throw new RuntimeException("The System workspace does not exist");
        }
        this.systemWorkspaceId = workspace.getId();
        return this.systemWorkspaceId;
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }
}

