/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.util;

import de.deepamehta.core.Identifiable;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.TopicModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class DeepaMehtaUtils {
    private static Logger logger = Logger.getLogger("de.deepamehta.core.util.DeepaMehtaUtils");
    private static final String DM4_HOST_URL = System.getProperty("dm4.host.url");

    public static boolean isDeepaMehtaURL(URL url) {
        try {
            return url.toString().startsWith(DM4_HOST_URL);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking for DeepaMehta URL failed (url=\"" + url + "\")", e);
        }
    }

    public static List<Long> idList(Iterable<? extends Identifiable> items) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Identifiable identifiable : items) {
            ids.add(identifiable.getId());
        }
        return ids;
    }

    public static List<TopicModel> toTopicModels(Iterable<? extends Topic> topics) {
        ArrayList<TopicModel> topicModels = new ArrayList<TopicModel>();
        for (Topic topic : topics) {
            topicModels.add(topic.getModel());
        }
        return topicModels;
    }

    public static String topicNames(Iterable<? extends Topic> topics) {
        StringBuilder names = new StringBuilder();
        Iterator<? extends Topic> i = topics.iterator();
        while (i.hasNext()) {
            Topic topic = i.next();
            names.append('\"').append(topic.getSimpleValue()).append('\"');
            if (!i.hasNext()) continue;
            names.append(", ");
        }
        return names.toString();
    }

    public static Map toMap(JSONObject o) {
        return DeepaMehtaUtils.toMap(o, new HashMap());
    }

    public static Map toMap(JSONObject o, Map map) {
        try {
            Iterator i = o.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                map.put(key, o.get(key));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONObject to Map failed", e);
        }
    }

    public static List toList(JSONArray o) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < o.length(); ++i) {
                list.add(o.get(i));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Converting JSONArray to List failed", e);
        }
    }

    public static JSONArray stringsToJson(Collection<String> strings) {
        JSONArray array = new JSONArray();
        for (String string : strings) {
            array.put((Object)string);
        }
        return array;
    }

    public static JSONArray objectsToJSON(Iterable<? extends JSONEnabled> items) {
        JSONArray array = new JSONArray();
        for (JSONEnabled jSONEnabled : items) {
            array.put((Object)jSONEnabled.toJSON());
        }
        return array;
    }

    static {
        logger.info("Host setting:\ndm4.host.url=\"" + DM4_HOST_URL + "\"");
    }
}

