/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.core.util.SequencedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class TypeModel
extends TopicModel {
    private String dataTypeUri;
    private List<IndexMode> indexModes;
    private SequencedHashMap<String, AssociationDefinitionModel> assocDefs;
    private List<String> labelConfig;
    private ViewConfigurationModel viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TypeModel(String uri, String topicTypeUri, SimpleValue value, String dataTypeUri) {
        super(uri, topicTypeUri, value);
        this.dataTypeUri = dataTypeUri;
        this.indexModes = new ArrayList<IndexMode>();
        this.assocDefs = new SequencedHashMap();
        this.labelConfig = new ArrayList<String>();
        this.viewConfig = new ViewConfigurationModel();
    }

    public TypeModel(TopicModel topic, String dataTypeUri, List<IndexMode> indexModes, List<AssociationDefinitionModel> assocDefs, List<String> labelConfig, ViewConfigurationModel viewConfig) {
        super(topic);
        this.dataTypeUri = dataTypeUri;
        this.indexModes = indexModes;
        this.assocDefs = new SequencedHashMap();
        for (AssociationDefinitionModel assocDef : assocDefs) {
            this.addAssocDef(assocDef);
        }
        this.labelConfig = labelConfig;
        this.viewConfig = viewConfig;
    }

    public TypeModel(JSONObject typeModel) {
        super(typeModel);
        try {
            this.dataTypeUri = typeModel.getString("data_type_uri");
            this.indexModes = IndexMode.parse(typeModel);
            this.assocDefs = new SequencedHashMap();
            this.labelConfig = this.parseLabelConfig(typeModel);
            this.viewConfig = new ViewConfigurationModel(typeModel);
            this.parseAssocDefs(typeModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing TypeModel failed (JSONObject=" + typeModel + ")", e);
        }
    }

    public String getDataTypeUri() {
        return this.dataTypeUri;
    }

    public void setDataTypeUri(String dataTypeUri) {
        this.dataTypeUri = dataTypeUri;
    }

    public List<IndexMode> getIndexModes() {
        return this.indexModes;
    }

    public void addIndexMode(IndexMode indexMode) {
        this.indexModes.add(indexMode);
    }

    public Collection<AssociationDefinitionModel> getAssocDefs() {
        return this.assocDefs.values();
    }

    public AssociationDefinitionModel getAssocDef(String childTypeUri) {
        AssociationDefinitionModel assocDef = (AssociationDefinitionModel)this.assocDefs.get(childTypeUri);
        if (assocDef == null) {
            throw new RuntimeException("Schema violation: association definition \"" + childTypeUri + "\" not found in " + this);
        }
        return assocDef;
    }

    public TypeModel addAssocDef(AssociationDefinitionModel assocDef) {
        return this.addAssocDefBefore(assocDef, null);
    }

    public TypeModel addAssocDefBefore(AssociationDefinitionModel assocDef, String beforeChildTypeUri) {
        String childTypeUri = assocDef.getChildTypeUri();
        AssociationDefinitionModel existing = (AssociationDefinitionModel)this.assocDefs.get(childTypeUri);
        if (existing != null) {
            throw new RuntimeException("Schema ambiguity: topic type \"" + this.uri + "\" has more than one association definitions with uri \"" + childTypeUri + "\"");
        }
        this.assocDefs.putBefore(assocDef.getChildTypeUri(), assocDef, beforeChildTypeUri);
        return this;
    }

    public void updateAssocDef(AssociationDefinitionModel assocDef) {
        this.assocDefs.put(assocDef.getChildTypeUri(), assocDef);
    }

    public AssociationDefinitionModel removeAssocDef(String childTypeUri) {
        this.getAssocDef(childTypeUri);
        return (AssociationDefinitionModel)this.assocDefs.remove(childTypeUri);
    }

    public void removeAllAssocDefs() {
        this.assocDefs.clear();
    }

    public List<String> getLabelConfig() {
        return this.labelConfig;
    }

    public void setLabelConfig(List<String> labelConfig) {
        this.labelConfig = labelConfig;
    }

    public ViewConfigurationModel getViewConfigModel() {
        return this.viewConfig;
    }

    public Object getViewConfig(String typeUri, String settingUri) {
        return this.viewConfig.getSetting(typeUri, settingUri);
    }

    public void setViewConfig(ViewConfigurationModel viewConfig) {
        this.viewConfig = viewConfig;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = super.toJSON();
            o.put("data_type_uri", (Object)this.getDataTypeUri());
            IndexMode.toJSON(this.indexModes, o);
            AssociationDefinitionModel.toJSON(this.assocDefs.values(), o);
            o.put("label_config", (Object)DeepaMehtaUtils.stringsToJson(this.getLabelConfig()));
            this.getViewConfigModel().toJSON(o);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public String toString() {
        return "id=" + this.id + ", uri=\"" + this.uri + "\", value=\"" + this.value + "\", typeUri=\"" + this.typeUri + "\", dataTypeUri=\"" + this.getDataTypeUri() + "\", indexModes=" + this.getIndexModes() + ", assocDefs=" + this.getAssocDefs() + ", labelConfig=" + this.getLabelConfig() + ", " + this.getViewConfigModel();
    }

    private List<String> parseLabelConfig(JSONObject typeModel) throws JSONException {
        if (typeModel.has("label_config")) {
            return DeepaMehtaUtils.toList(typeModel.getJSONArray("label_config"));
        }
        return new ArrayList<String>();
    }

    private void parseAssocDefs(JSONObject typeModel) throws JSONException {
        JSONArray assocDefs = typeModel.optJSONArray("assoc_defs");
        if (assocDefs != null) {
            for (int i = 0; i < assocDefs.length(); ++i) {
                JSONObject assocDef = assocDefs.getJSONObject(i);
                assocDef.put("parent_type_uri", (Object)this.uri);
                this.addAssocDef(this.parseAssocDef(assocDef));
            }
        }
    }

    private AssociationDefinitionModel parseAssocDef(JSONObject assocDef) {
        try {
            return new AssociationDefinitionModel(assocDef);
        }
        catch (JSONException e) {
            throw new RuntimeException("Parsing AssociationDefinitionModel failed (JSONObject=" + assocDef + ")", e);
        }
    }
}

