/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.RoleModel;
import org.codehaus.jettison.json.JSONObject;

public class TopicRoleModel
extends RoleModel {
    private String topicUri;
    private boolean topicIdentifiedByUri;

    public TopicRoleModel(long topicId, String roleTypeUri) {
        super(topicId, roleTypeUri);
        this.topicUri = null;
        this.topicIdentifiedByUri = false;
    }

    public TopicRoleModel(String topicUri, String roleTypeUri) {
        super(-1L, roleTypeUri);
        this.topicUri = topicUri;
        this.topicIdentifiedByUri = true;
    }

    public TopicRoleModel(JSONObject topicRoleModel) {
        try {
            this.playerId = topicRoleModel.optLong("topic_id", -1L);
            this.topicUri = topicRoleModel.optString("topic_uri", null);
            this.roleTypeUri = topicRoleModel.getString("role_type_uri");
            boolean bl = this.topicIdentifiedByUri = this.topicUri != null;
            if (this.playerId == -1L && this.topicUri == null) {
                throw new IllegalArgumentException("Neiter \"topic_id\" nor \"topic_uri\" is set");
            }
            if (this.playerId != -1L && this.topicUri != null) {
                throw new IllegalArgumentException("\"topic_id\" and \"topic_uri\" must not be set at the same time");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing TopicRoleModel failed (JSONObject=" + topicRoleModel + ")", e);
        }
    }

    @Override
    public long getPlayerId() {
        if (this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by ID but by URI (" + this + ")");
        }
        return super.getPlayerId();
    }

    public String getTopicUri() {
        if (!this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by URI but by ID (" + this + ")");
        }
        return this.topicUri;
    }

    public boolean topicIdentifiedByUri() {
        return this.topicIdentifiedByUri;
    }

    @Override
    public boolean refsSameObject(RoleModel model) {
        if (model instanceof TopicRoleModel) {
            TopicRoleModel topicRole = (TopicRoleModel)model;
            if (topicRole.topicIdentifiedByUri == this.topicIdentifiedByUri) {
                if (this.topicIdentifiedByUri) {
                    return topicRole.topicUri.equals(this.topicUri);
                }
                return topicRole.playerId == this.playerId;
            }
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            if (this.topicIdentifiedByUri) {
                o.put("topic_uri", (Object)this.topicUri);
            } else {
                o.put("topic_id", this.playerId);
            }
            o.put("role_type_uri", (Object)this.roleTypeUri);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public String toString() {
        String player = this.topicIdentifiedByUri ? "topicUri=\"" + this.topicUri + "\"" : "playerId=" + this.playerId;
        return "\n        topic role (roleTypeUri=\"" + this.roleTypeUri + "\", " + player + ")";
    }
}

