/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.Identifiable;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import org.codehaus.jettison.json.JSONObject;

public abstract class DeepaMehtaObjectModel
implements Identifiable,
JSONEnabled,
Cloneable {
    protected long id;
    protected String uri;
    protected String typeUri;
    protected SimpleValue value;
    protected ChildTopicsModel childTopics;

    public DeepaMehtaObjectModel(ChildTopicsModel childTopics) {
        this(null, childTopics);
    }

    public DeepaMehtaObjectModel(String typeUri) {
        this(-1L, typeUri);
    }

    public DeepaMehtaObjectModel(String typeUri, SimpleValue value) {
        this(null, typeUri, value);
    }

    public DeepaMehtaObjectModel(String typeUri, ChildTopicsModel childTopics) {
        this(null, typeUri, childTopics);
    }

    public DeepaMehtaObjectModel(String uri, String typeUri) {
        this(-1L, uri, typeUri, null, null);
    }

    public DeepaMehtaObjectModel(String uri, String typeUri, SimpleValue value) {
        this(-1L, uri, typeUri, value, null);
    }

    public DeepaMehtaObjectModel(String uri, String typeUri, ChildTopicsModel childTopics) {
        this(-1L, uri, typeUri, null, childTopics);
    }

    public DeepaMehtaObjectModel(long id) {
        this(id, null, null);
    }

    public DeepaMehtaObjectModel(long id, ChildTopicsModel childTopics) {
        this(id, null, childTopics);
    }

    public DeepaMehtaObjectModel(long id, String typeUri) {
        this(id, typeUri, null);
    }

    public DeepaMehtaObjectModel(long id, String typeUri, ChildTopicsModel childTopics) {
        this(id, null, typeUri, null, childTopics);
    }

    public DeepaMehtaObjectModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        this.id = id;
        this.uri = uri;
        this.typeUri = typeUri;
        this.value = value;
        this.childTopics = childTopics != null ? childTopics : new ChildTopicsModel();
    }

    public DeepaMehtaObjectModel(DeepaMehtaObjectModel object) {
        this(object.id, object.uri, object.typeUri, object.value, object.childTopics);
    }

    public DeepaMehtaObjectModel(JSONObject object) {
        try {
            this.id = object.optLong("id", -1L);
            this.uri = object.optString("uri", null);
            this.typeUri = object.optString("type_uri", null);
            this.value = object.has("value") ? new SimpleValue(object.get("value")) : null;
            this.childTopics = object.has("childs") ? new ChildTopicsModel(object.getJSONObject("childs")) : new ChildTopicsModel();
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing DeepaMehtaObjectModel failed (JSONObject=" + object + ")", e);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getTypeUri() {
        return this.typeUri;
    }

    public void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    public SimpleValue getSimpleValue() {
        return this.value;
    }

    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    public void setSimpleValue(SimpleValue value) {
        this.value = value;
    }

    public ChildTopicsModel getChildTopicsModel() {
        return this.childTopics;
    }

    public void setChildTopicsModel(ChildTopicsModel childTopics) {
        this.childTopics = childTopics;
    }

    public void set(DeepaMehtaObjectModel object) {
        this.setId(object.getId());
        this.setUri(object.getUri());
        this.setTypeUri(object.getTypeUri());
        this.setSimpleValue(object.getSimpleValue());
        this.setChildTopicsModel(object.getChildTopicsModel());
    }

    public abstract RoleModel createRoleModel(String var1);

    @Override
    public JSONObject toJSON() {
        try {
            this.setDefaults();
            JSONObject o = new JSONObject();
            o.put("id", this.id);
            o.put("uri", (Object)this.uri);
            o.put("type_uri", (Object)this.typeUri);
            o.put("value", this.value.value());
            o.put("childs", (Object)this.childTopics.toJSON());
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public DeepaMehtaObjectModel clone() {
        try {
            DeepaMehtaObjectModel object = (DeepaMehtaObjectModel)super.clone();
            object.childTopics = this.childTopics.clone();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a DeepaMehtaObjectModel failed", e);
        }
    }

    public boolean equals(Object o) {
        return ((DeepaMehtaObjectModel)o).id == this.id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        return "id=" + this.id + ", uri=\"" + this.uri + "\", typeUri=\"" + this.typeUri + "\", value=\"" + this.value + "\", childTopics=" + this.childTopics;
    }

    private void setDefaults() {
        if (this.getUri() == null) {
            this.setUri("");
        }
        if (this.getSimpleValue() == null) {
            this.setSimpleValue("");
        }
    }
}

