/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ChildTopicsModel
implements Iterable<String> {
    private static final String REF_ID_PREFIX = "ref_id:";
    private static final String REF_URI_PREFIX = "ref_uri:";
    private static final String DEL_PREFIX = "del_id:";
    private Map<String, Object> childTopics = new HashMap<String, Object>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ChildTopicsModel() {
    }

    public ChildTopicsModel(JSONObject values) {
        try {
            Iterator i = values.keys();
            while (i.hasNext()) {
                String childTypeUri = (String)i.next();
                Object value = values.get(childTypeUri);
                if (value instanceof JSONArray) {
                    JSONArray valueArray = (JSONArray)value;
                    for (int j = 0; j < valueArray.length(); ++j) {
                        this.add(childTypeUri, this.createTopicModel(childTypeUri, valueArray.get(j)));
                    }
                    continue;
                }
                this.put(childTypeUri, this.createTopicModel(childTypeUri, value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing ChildTopicsModel failed (JSONObject=" + values + ")", e);
        }
    }

    public RelatedTopicModel getTopic(String childTypeUri) {
        RelatedTopicModel topic = (RelatedTopicModel)this.get(childTypeUri);
        if (topic == null) {
            throw new RuntimeException("Invalid access to ChildTopicsModel entry \"" + childTypeUri + "\": no such entry in\n" + this);
        }
        return topic;
    }

    public RelatedTopicModel getTopic(String childTypeUri, RelatedTopicModel defaultValue) {
        RelatedTopicModel topic = (RelatedTopicModel)this.get(childTypeUri);
        return topic != null ? topic : defaultValue;
    }

    public List<RelatedTopicModel> getTopics(String childTypeUri) {
        try {
            List topics = (List)this.get(childTypeUri);
            if (topics == null) {
                throw new RuntimeException("Invalid access to ChildTopicsModel entry \"" + childTypeUri + "\": no such entry in\n" + this);
            }
            return topics;
        }
        catch (ClassCastException e) {
            this.throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    public List<RelatedTopicModel> getTopics(String childTypeUri, List<RelatedTopicModel> defaultValue) {
        try {
            List<RelatedTopicModel> topics = (List<RelatedTopicModel>)this.get(childTypeUri);
            return topics != null ? topics : defaultValue;
        }
        catch (ClassCastException e) {
            this.throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    public Object get(String childTypeUri) {
        return this.childTopics.get(childTypeUri);
    }

    public boolean has(String childTypeUri) {
        return this.childTopics.containsKey(childTypeUri);
    }

    public int size() {
        return this.childTopics.size();
    }

    public String getString(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().toString();
    }

    public String getString(String childTypeUri, String defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().toString() : defaultValue;
    }

    public int getInt(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().intValue();
    }

    public int getInt(String childTypeUri, int defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().intValue() : defaultValue;
    }

    public long getLong(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().longValue();
    }

    public long getLong(String childTypeUri, long defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().longValue() : defaultValue;
    }

    public double getDouble(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().doubleValue();
    }

    public double getDouble(String childTypeUri, double defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().doubleValue() : defaultValue;
    }

    public boolean getBoolean(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().booleanValue();
    }

    public boolean getBoolean(String childTypeUri, boolean defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().booleanValue() : defaultValue;
    }

    public Object getObject(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().value();
    }

    public Object getObject(String childTypeUri, Object defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getSimpleValue().value() : defaultValue;
    }

    public ChildTopicsModel getChildTopicsModel(String childTypeUri) {
        return this.getTopic(childTypeUri).getChildTopicsModel();
    }

    public ChildTopicsModel getChildTopicsModel(String childTypeUri, ChildTopicsModel defaultValue) {
        RelatedTopicModel topic = this.getTopic(childTypeUri, null);
        return topic != null ? topic.getChildTopicsModel() : defaultValue;
    }

    public ChildTopicsModel put(String childTypeUri, RelatedTopicModel value) {
        try {
            if (value == null) {
                throw new IllegalArgumentException("Tried to put null in a ChildTopicsModel");
            }
            this.childTopics.put(childTypeUri, value);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (childTypeUri=\"" + childTypeUri + "\", value=" + value + ")", e);
        }
    }

    public ChildTopicsModel put(String childTypeUri, TopicModel value) {
        return this.put(childTypeUri, new RelatedTopicModel(value));
    }

    public ChildTopicsModel put(String childTypeUri, Object value) {
        try {
            return this.put(childTypeUri, new TopicModel(childTypeUri, new SimpleValue(value)));
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (childTypeUri=\"" + childTypeUri + "\", value=" + value + ")", e);
        }
    }

    public ChildTopicsModel put(String childTypeUri, ChildTopicsModel value) {
        return this.put(childTypeUri, new TopicModel(childTypeUri, value));
    }

    public ChildTopicsModel putRef(String childTypeUri, long refTopicId) {
        this.put(childTypeUri, new TopicReferenceModel(refTopicId));
        return this;
    }

    public ChildTopicsModel putRef(String childTypeUri, String refTopicUri) {
        this.put(childTypeUri, new TopicReferenceModel(refTopicUri));
        return this;
    }

    public ChildTopicsModel remove(String childTypeUri) {
        this.childTopics.remove(childTypeUri);
        return this;
    }

    public ChildTopicsModel add(String childTypeUri, RelatedTopicModel value) {
        List<RelatedTopicModel> topics = this.getTopics(childTypeUri, null);
        if (topics == null) {
            topics = new ArrayList<RelatedTopicModel>();
            this.childTopics.put(childTypeUri, topics);
        }
        topics.add(value);
        return this;
    }

    public ChildTopicsModel add(String childTypeUri, TopicModel value) {
        return this.add(childTypeUri, new RelatedTopicModel(value));
    }

    public ChildTopicsModel put(String childTypeUri, List<RelatedTopicModel> values) {
        this.childTopics.put(childTypeUri, values);
        return this;
    }

    public ChildTopicsModel remove(String childTypeUri, TopicModel value) {
        List<RelatedTopicModel> topics = this.getTopics(childTypeUri, null);
        if (topics != null) {
            topics.remove(value);
        }
        return this;
    }

    public ChildTopicsModel addRef(String childTypeUri, long refTopicId) {
        this.add(childTypeUri, new TopicReferenceModel(refTopicId));
        return this;
    }

    public ChildTopicsModel addRef(String childTypeUri, String refTopicUri) {
        this.add(childTypeUri, new TopicReferenceModel(refTopicUri));
        return this;
    }

    public ChildTopicsModel addDeletionRef(String childTypeUri, long refTopicId) {
        this.add(childTypeUri, new TopicDeletionModel(refTopicId));
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        return this.childTopics.keySet().iterator();
    }

    public JSONObject toJSON() {
        try {
            JSONObject json = new JSONObject();
            for (String childTypeUri : this) {
                Object value = this.get(childTypeUri);
                if (value instanceof RelatedTopicModel) {
                    json.put(childTypeUri, (Object)((RelatedTopicModel)value).toJSON());
                    continue;
                }
                if (value instanceof List) {
                    json.put(childTypeUri, (Object)DeepaMehtaUtils.objectsToJSON((List)value));
                    continue;
                }
                throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
            }
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization of a ChildTopicsModel failed (" + this + ")", e);
        }
    }

    public ChildTopicsModel clone() {
        ChildTopicsModel clone = new ChildTopicsModel();
        for (String childTypeUri : this) {
            Object value = this.get(childTypeUri);
            if (value instanceof RelatedTopicModel) {
                RelatedTopicModel model = (RelatedTopicModel)value;
                clone.put(childTypeUri, model.clone());
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopicModel model : (List)value) {
                    clone.add(childTypeUri, model.clone());
                }
                continue;
            }
            throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
        }
        return clone;
    }

    public String toString() {
        return this.childTopics.toString();
    }

    private RelatedTopicModel createTopicModel(String childTypeUri, Object value) throws JSONException {
        if (value instanceof JSONObject) {
            JSONObject val = (JSONObject)value;
            if (val.has("value") || val.has("childs")) {
                RelatedTopicModel topicRef;
                AssociationModel relatingAssoc = null;
                if (val.has("assoc")) {
                    relatingAssoc = new AssociationModel(val.getJSONObject("assoc"));
                }
                if (val.has("value") && (topicRef = this.createReferenceModel(val.get("value"), relatingAssoc)) != null) {
                    return topicRef;
                }
                this.initTypeUri(val, childTypeUri);
                TopicModel topic = new TopicModel(val);
                if (relatingAssoc != null) {
                    return new RelatedTopicModel(topic, relatingAssoc);
                }
                return new RelatedTopicModel(topic);
            }
            return new RelatedTopicModel(new TopicModel(childTypeUri, new ChildTopicsModel(val)));
        }
        RelatedTopicModel topicRef = this.createReferenceModel(value, null);
        if (topicRef != null) {
            return topicRef;
        }
        return new RelatedTopicModel(new TopicModel(childTypeUri, new SimpleValue(value)));
    }

    private RelatedTopicModel createReferenceModel(Object value, AssociationModel relatingAssoc) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.startsWith(REF_ID_PREFIX)) {
                long topicId = this.refTopicId(val);
                if (relatingAssoc != null) {
                    return new TopicReferenceModel(topicId, relatingAssoc);
                }
                return new TopicReferenceModel(topicId);
            }
            if (val.startsWith(REF_URI_PREFIX)) {
                String topicUri = this.refTopicUri(val);
                if (relatingAssoc != null) {
                    return new TopicReferenceModel(topicUri, relatingAssoc);
                }
                return new TopicReferenceModel(topicUri);
            }
            if (val.startsWith(DEL_PREFIX)) {
                return new TopicDeletionModel(this.delTopicId(val));
            }
        }
        return null;
    }

    private void initTypeUri(JSONObject value, String childTypeUri) throws JSONException {
        if (!value.has("type_uri")) {
            value.put("type_uri", (Object)childTypeUri);
        } else {
            String typeUri = value.getString("type_uri");
            if (!typeUri.equals(childTypeUri)) {
                throw new IllegalArgumentException("A \"" + childTypeUri + "\" topic model has type_uri=\"" + typeUri + "\"");
            }
        }
    }

    private long refTopicId(String val) {
        return Long.parseLong(val.substring(REF_ID_PREFIX.length()));
    }

    private String refTopicUri(String val) {
        return val.substring(REF_URI_PREFIX.length());
    }

    private long delTopicId(String val) {
        return Long.parseLong(val.substring(DEL_PREFIX.length()));
    }

    public void throwInvalidAccess(String childTypeUri, ClassCastException e) {
        if (e.getMessage().endsWith("cannot be cast to java.util.List")) {
            throw new RuntimeException("Invalid access to ChildTopicsModel entry \"" + childTypeUri + "\": the caller assumes it to be multiple-value but it is single-value in\n" + this, e);
        }
        throw new RuntimeException("Invalid access to ChildTopicsModel entry \"" + childTypeUri + "\" in\n" + this, e);
    }
}

