/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicRoleModel;
import org.codehaus.jettison.json.JSONObject;

public class AssociationModel
extends DeepaMehtaObjectModel {
    private RoleModel roleModel1;
    private RoleModel roleModel2;

    public AssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        this(typeUri, roleModel1, roleModel2, null);
    }

    public AssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2, ChildTopicsModel childTopics) {
        this(-1L, null, typeUri, roleModel1, roleModel2, null, childTopics);
    }

    public AssociationModel() {
        super(-1L);
    }

    public AssociationModel(long id) {
        super(id);
    }

    public AssociationModel(ChildTopicsModel childTopics) {
        super(childTopics);
    }

    public AssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        this(id, uri, typeUri, roleModel1, roleModel2, null, null);
    }

    public AssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2, SimpleValue value, ChildTopicsModel childTopics) {
        super(id, uri, typeUri, value, childTopics);
        this.roleModel1 = roleModel1;
        this.roleModel2 = roleModel2;
    }

    public AssociationModel(AssociationModel assoc) {
        super(assoc);
        this.roleModel1 = assoc.getRoleModel1();
        this.roleModel2 = assoc.getRoleModel2();
    }

    public AssociationModel(JSONObject assoc) {
        super(assoc);
        try {
            if (assoc.has("role_1")) {
                this.roleModel1 = this.parseRole(assoc.getJSONObject("role_1"));
            }
            if (assoc.has("role_2")) {
                this.roleModel2 = this.parseRole(assoc.getJSONObject("role_2"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationModel failed (JSONObject=" + assoc + ")", e);
        }
    }

    public RoleModel getRoleModel1() {
        return this.roleModel1;
    }

    public RoleModel getRoleModel2() {
        return this.roleModel2;
    }

    public void setRoleModel1(RoleModel roleModel1) {
        this.roleModel1 = roleModel1;
    }

    public void setRoleModel2(RoleModel roleModel2) {
        this.roleModel2 = roleModel2;
    }

    public RoleModel getRoleModel(String roleTypeUri) {
        boolean rm1 = this.roleModel1.getRoleTypeUri().equals(roleTypeUri);
        boolean rm2 = this.roleModel2.getRoleTypeUri().equals(roleTypeUri);
        if (rm1 && rm2) {
            throw new RuntimeException("Ambiguous getRoleModel() call: both players occupy role \"" + roleTypeUri + "\" in association (" + this + ")");
        }
        if (rm1) {
            return this.roleModel1;
        }
        if (rm2) {
            return this.roleModel2;
        }
        return null;
    }

    public long getOtherPlayerId(long id) {
        long id1 = this.roleModel1.getPlayerId();
        long id2 = this.roleModel2.getPlayerId();
        if (id1 == id) {
            return id2;
        }
        if (id2 == id) {
            return id1;
        }
        throw new IllegalArgumentException("ID " + id + " doesn't refer to a player in " + this);
    }

    public boolean hasSameRoleTypeUris() {
        return this.roleModel1.getRoleTypeUri().equals(this.roleModel2.getRoleTypeUri());
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        return new AssociationRoleModel(this.getId(), roleTypeUri);
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = super.toJSON();
            o.put("role_1", (Object)this.roleModel1.toJSON());
            o.put("role_2", (Object)this.roleModel2.toJSON());
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public AssociationModel clone() {
        try {
            AssociationModel model = (AssociationModel)super.clone();
            model.roleModel1 = this.roleModel1.clone();
            model.roleModel2 = this.roleModel2.clone();
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning an AssociationModel failed", e);
        }
    }

    @Override
    public String toString() {
        return "association (" + super.toString() + ", " + this.roleModel1 + ", " + this.roleModel2 + ")";
    }

    private RoleModel parseRole(JSONObject roleModel) {
        if (roleModel.has("topic_id") || roleModel.has("topic_uri")) {
            return new TopicRoleModel(roleModel);
        }
        if (roleModel.has("assoc_id")) {
            return new AssociationRoleModel(roleModel);
        }
        throw new RuntimeException("Parsing TopicRoleModel/AssociationRoleModel failed (JSONObject=" + roleModel + ")");
    }
}

