/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Topic;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.model.TypeModel;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.util.JavaUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

class ValueStorage {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueStorage(EmbeddedService dms) {
        this.dms = dms;
    }

    private void fetchChildTopics(DeepaMehtaObjectModel parent) {
        for (AssociationDefinitionModel assocDef : this.getType(parent).getAssocDefs()) {
            this.fetchChildTopics(parent, assocDef);
        }
    }

    void fetchChildTopics(DeepaMehtaObjectModel parent, AssociationDefinitionModel assocDef) {
        block6: {
            try {
                ChildTopicsModel childTopics = parent.getChildTopicsModel();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                String childTypeUri = assocDef.getChildTypeUri();
                if (cardinalityUri.equals("dm4.core.one")) {
                    RelatedTopicModel childTopic = this.fetchChildTopic(parent.getId(), assocDef);
                    if (childTopic != null) {
                        childTopics.put(childTypeUri, childTopic);
                        this.fetchChildTopics(childTopic);
                    }
                    break block6;
                }
                if (cardinalityUri.equals("dm4.core.many")) {
                    for (RelatedTopicModel childTopic : this.fetchChildTopics(parent.getId(), assocDef)) {
                        childTopics.add(childTypeUri, childTopic);
                        this.fetchChildTopics(childTopic);
                    }
                    break block6;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            catch (Exception e) {
                throw new RuntimeException("Fetching the \"" + assocDef.getChildTypeUri() + "\" child topics of object " + parent.getId() + " failed", e);
            }
        }
    }

    void storeValue(DeepaMehtaObjectModel model) {
        if (this.getType(model).getDataTypeUri().equals("dm4.core.composite")) {
            this.storeChildTopics(model);
            this.refreshLabel(model);
        } else {
            this.storeSimpleValue(model);
        }
    }

    void indexSimpleValue(DeepaMehtaObjectModel model, IndexMode indexMode) {
        if (model instanceof TopicModel) {
            this.dms.storageDecorator.indexTopicValue(model.getId(), indexMode, model.getTypeUri(), this.getIndexValue(model));
        } else if (model instanceof AssociationModel) {
            this.dms.storageDecorator.indexAssociationValue(model.getId(), indexMode, model.getTypeUri(), this.getIndexValue(model));
        }
    }

    void refreshLabel(DeepaMehtaObjectModel parent) {
        try {
            String label = this.buildLabel(parent);
            this.setSimpleValue(parent, new SimpleValue(label));
        }
        catch (Exception e) {
            throw new RuntimeException("Refreshing label of object " + parent.getId() + " failed (" + parent + ")", e);
        }
    }

    void setSimpleValue(DeepaMehtaObjectModel model, SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Tried to set a null SimpleValue (" + this + ")");
        }
        model.setSimpleValue(value);
        this.storeSimpleValue(model);
    }

    private void storeSimpleValue(DeepaMehtaObjectModel model) {
        TypeModel type = this.getType(model);
        if (model instanceof TopicModel) {
            this.dms.storageDecorator.storeTopicValue(model.getId(), model.getSimpleValue(), type.getIndexModes(), type.getUri(), this.getIndexValue(model));
        } else if (model instanceof AssociationModel) {
            this.dms.storageDecorator.storeAssociationValue(model.getId(), model.getSimpleValue(), type.getIndexModes(), type.getUri(), this.getIndexValue(model));
        }
    }

    private void storeChildTopics(DeepaMehtaObjectModel parent) {
        ChildTopicsModel model = null;
        try {
            model = parent.getChildTopicsModel();
            for (AssociationDefinitionModel assocDef : this.getType(parent).getAssocDefs()) {
                String childTypeUri = assocDef.getChildTypeUri();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                if (cardinalityUri.equals("dm4.core.one")) {
                    RelatedTopicModel childTopic = model.getTopic(childTypeUri, null);
                    if (childTopic == null) continue;
                    this.storeChildTopic(childTopic, parent, assocDef);
                    continue;
                }
                if (cardinalityUri.equals("dm4.core.many")) {
                    List<RelatedTopicModel> childTopics = model.getTopics(childTypeUri, null);
                    if (childTopics == null) continue;
                    for (RelatedTopicModel childTopic : childTopics) {
                        this.storeChildTopic(childTopic, parent, assocDef);
                    }
                    continue;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing the child topics of object " + parent.getId() + " failed (" + model + ")", e);
        }
    }

    private void storeChildTopic(RelatedTopicModel childTopic, DeepaMehtaObjectModel parent, AssociationDefinitionModel assocDef) {
        if (childTopic instanceof TopicReferenceModel) {
            this.resolveReference((TopicReferenceModel)childTopic);
        } else {
            this.dms.createTopic(childTopic);
        }
        this.associateChildTopic(parent, childTopic, assocDef);
    }

    void resolveReference(TopicReferenceModel topicRef) {
        topicRef.set(this.fetchReferencedTopic(topicRef).getModel());
    }

    private Topic fetchReferencedTopic(TopicReferenceModel topicRef) {
        if (topicRef.isReferenceById()) {
            return this.dms.getTopic(topicRef.getId());
        }
        if (topicRef.isReferenceByUri()) {
            return this.dms.getTopic("uri", new SimpleValue(topicRef.getUri()));
        }
        throw new RuntimeException("Invalid topic reference (" + topicRef + ")");
    }

    void associateChildTopic(DeepaMehtaObjectModel parent, RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        AssociationModel assoc = childTopic.getRelatingAssociation();
        assoc.setTypeUri(assocDef.getInstanceLevelAssocTypeUri());
        assoc.setRoleModel1(parent.createRoleModel("dm4.core.parent"));
        assoc.setRoleModel2(childTopic.createRoleModel("dm4.core.child"));
        this.dms.createAssociation(assoc);
    }

    private String buildLabel(DeepaMehtaObjectModel model) {
        TypeModel type = this.getType(model);
        if (type.getDataTypeUri().equals("dm4.core.composite")) {
            StringBuilder label = new StringBuilder();
            for (String childTypeUri : this.getLabelChildTypeUris(model)) {
                this.appendLabel(this.buildChildLabel(model, childTypeUri), label, LABEL_CHILD_SEPARATOR);
            }
            return label.toString();
        }
        return model.getSimpleValue().toString();
    }

    List<String> getLabelChildTypeUris(DeepaMehtaObjectModel parent) {
        TypeModel type = this.getType(parent);
        List<String> labelConfig = type.getLabelConfig();
        if (labelConfig.size() > 0) {
            return labelConfig;
        }
        ArrayList<String> childTypeUris = new ArrayList<String>();
        Iterator<AssociationDefinitionModel> i = type.getAssocDefs().iterator();
        if (i.hasNext()) {
            childTypeUris.add(i.next().getChildTypeUri());
        }
        return childTypeUris;
    }

    private String buildChildLabel(DeepaMehtaObjectModel parent, String childTypeUri) {
        Object value = parent.getChildTopicsModel().get(childTypeUri);
        if (value == null) {
            return "";
        }
        if (value instanceof TopicModel) {
            TopicModel childTopic = (TopicModel)value;
            return this.buildLabel(childTopic);
        }
        if (value instanceof List) {
            StringBuilder label = new StringBuilder();
            for (TopicModel childTopic : (List)value) {
                this.appendLabel(this.buildLabel(childTopic), label, LABEL_TOPIC_SEPARATOR);
            }
            return label.toString();
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    private void appendLabel(String label, StringBuilder builder, String separator) {
        if (builder.length() > 0 && label.length() > 0) {
            builder.append(separator);
        }
        builder.append(label);
    }

    private RelatedTopicModel fetchChildTopic(long parentId, AssociationDefinitionModel assocDef) {
        return this.dms.storageDecorator.fetchRelatedTopic(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }

    private ResultList<RelatedTopicModel> fetchChildTopics(long parentId, AssociationDefinitionModel assocDef) {
        return this.dms.storageDecorator.fetchRelatedTopics(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }

    private SimpleValue getIndexValue(DeepaMehtaObjectModel model) {
        SimpleValue value = model.getSimpleValue();
        if (this.getType(model).getDataTypeUri().equals("dm4.core.html")) {
            return new SimpleValue(JavaUtils.stripHTML(value.toString()));
        }
        return value;
    }

    private TypeModel getType(DeepaMehtaObjectModel model) {
        if (model instanceof TopicModel) {
            return this.dms.typeStorage.getTopicType(model.getTypeUri());
        }
        if (model instanceof AssociationModel) {
            return this.dms.typeStorage.getAssociationType(model.getTypeUri());
        }
        throw new RuntimeException("Unexpected model: " + model);
    }
}

