/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.storage.spi.DeepaMehtaStorage;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class StorageDecorator {
    private DeepaMehtaStorage storage;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public StorageDecorator(DeepaMehtaStorage storage) {
        this.storage = storage;
    }

    TopicModel fetchTopic(long topicId) {
        return this.storage.fetchTopic(topicId);
    }

    TopicModel fetchTopic(String key, SimpleValue value) {
        return this.storage.fetchTopic(key, value.value());
    }

    List<TopicModel> fetchTopics(String key, SimpleValue value) {
        return this.storage.fetchTopics(key, value.value());
    }

    List<TopicModel> queryTopics(String searchTerm, String fieldUri) {
        return this.storage.queryTopics(fieldUri, searchTerm);
    }

    Iterator<TopicModel> fetchAllTopics() {
        return this.storage.fetchAllTopics();
    }

    void storeTopic(TopicModel model) {
        this.storage.storeTopic(model);
    }

    void storeTopicUri(long topicId, String uri) {
        this.storage.storeTopicUri(topicId, uri);
    }

    void storeTopicTypeUri(long topicId, String topicTypeUri) {
        this.storage.storeTopicTypeUri(topicId, topicTypeUri);
    }

    void storeTopicValue(long topicId, SimpleValue value) {
        this.storeTopicValue(topicId, value, Arrays.asList(IndexMode.OFF), null, null);
    }

    void storeTopicValue(long topicId, SimpleValue value, List<IndexMode> indexModes, String indexKey, SimpleValue indexValue) {
        this.storage.storeTopicValue(topicId, value, indexModes, indexKey, indexValue);
    }

    void indexTopicValue(long topicId, IndexMode indexMode, String indexKey, SimpleValue indexValue) {
        this.storage.indexTopicValue(topicId, indexMode, indexKey, indexValue);
    }

    void deleteTopic(long topicId) {
        this.storage.deleteTopic(topicId);
    }

    AssociationModel fetchAssociation(long assocId) {
        return this.storage.fetchAssociation(assocId);
    }

    AssociationModel fetchAssociation(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        List<AssociationModel> assocs = this.fetchAssociations(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId1=" + topicId1 + ", topicId2=" + topicId2 + ", " + "roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")");
    }

    List<AssociationModel> fetchAssociations(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        return this.storage.fetchAssociations(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
    }

    AssociationModel fetchAssociationBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        List<AssociationModel> assocs = this.fetchAssociationsBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId=" + topicId + ", assocId=" + assocId + ", " + "topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\")");
    }

    List<AssociationModel> fetchAssociationsBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        return this.storage.fetchAssociationsBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
    }

    Iterator<AssociationModel> fetchAllAssociations() {
        return this.storage.fetchAllAssociations();
    }

    long[] fetchPlayerIds(long assocId) {
        return this.storage.fetchPlayerIds(assocId);
    }

    void storeAssociationUri(long assocId, String uri) {
        this.storage.storeAssociationUri(assocId, uri);
    }

    void storeAssociationTypeUri(long assocId, String assocTypeUri) {
        this.storage.storeAssociationTypeUri(assocId, assocTypeUri);
    }

    void storeRoleTypeUri(long assocId, long playerId, String roleTypeUri) {
        this.storage.storeRoleTypeUri(assocId, playerId, roleTypeUri);
    }

    void storeAssociationValue(long assocId, SimpleValue value) {
        this.storeAssociationValue(assocId, value, Arrays.asList(IndexMode.OFF), null, null);
    }

    void storeAssociationValue(long assocId, SimpleValue value, List<IndexMode> indexModes, String indexKey, SimpleValue indexValue) {
        this.storage.storeAssociationValue(assocId, value, indexModes, indexKey, indexValue);
    }

    void indexAssociationValue(long assocId, IndexMode indexMode, String indexKey, SimpleValue indexValue) {
        this.storage.indexAssociationValue(assocId, indexMode, indexKey, indexValue);
    }

    void storeAssociation(AssociationModel model) {
        this.storage.storeAssociation(model);
    }

    void deleteAssociation(long assocId) {
        this.storage.deleteAssociation(assocId);
    }

    DeepaMehtaObjectModel fetchObject(long id) {
        return this.storage.fetchObject(id);
    }

    List<AssociationModel> fetchTopicAssociations(long topicId) {
        return this.storage.fetchTopicAssociations(topicId);
    }

    List<AssociationModel> fetchAssociationAssociations(long assocId) {
        return this.storage.fetchAssociationAssociations(assocId);
    }

    RelatedTopicModel fetchTopicRelatedTopic(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        ResultList<RelatedTopicModel> topics = this.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, 0);
        switch (topics.getSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.getSize() + " related topics (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", " + "othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    ResultList<RelatedTopicModel> fetchTopicRelatedTopics(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        List<RelatedTopicModel> relTopics = this.storage.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return new ResultList<RelatedTopicModel>(relTopics.size(), relTopics);
    }

    ResultList<RelatedTopicModel> fetchTopicRelatedTopics(long topicId, List<String> assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        ResultList<RelatedTopicModel> result = new ResultList<RelatedTopicModel>();
        for (String assocTypeUri : assocTypeUris) {
            ResultList<RelatedTopicModel> res = this.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
            result.addAll(res);
        }
        return result;
    }

    RelatedAssociationModel fetchTopicRelatedAssociation(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        ResultList<RelatedAssociationModel> assocs = this.fetchTopicRelatedAssociations(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.getSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.getSize() + " related associations (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", " + "othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")");
    }

    ResultList<RelatedAssociationModel> fetchTopicRelatedAssociations(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssociationModel> relAssocs = this.storage.fetchTopicRelatedAssociations(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return new ResultList<RelatedAssociationModel>(relAssocs.size(), relAssocs);
    }

    RelatedTopicModel fetchAssociationRelatedTopic(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        ResultList<RelatedTopicModel> topics = this.fetchAssociationRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, 0);
        switch (topics.getSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.getSize() + " related topics (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", " + "othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    ResultList<RelatedTopicModel> fetchAssociationRelatedTopics(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        List<RelatedTopicModel> relTopics = this.storage.fetchAssociationRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return new ResultList<RelatedTopicModel>(relTopics.size(), relTopics);
    }

    ResultList<RelatedTopicModel> fetchAssociationRelatedTopics(long assocId, List<String> assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        ResultList<RelatedTopicModel> result = new ResultList<RelatedTopicModel>();
        for (String assocTypeUri : assocTypeUris) {
            ResultList<RelatedTopicModel> res = this.fetchAssociationRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
            result.addAll(res);
        }
        return result;
    }

    RelatedAssociationModel fetchAssociationRelatedAssociation(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        ResultList<RelatedAssociationModel> assocs = this.fetchAssociationRelatedAssociations(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.getSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.getSize() + " related associations (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", " + "othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\"),\nresult=" + assocs);
    }

    ResultList<RelatedAssociationModel> fetchAssociationRelatedAssociations(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssociationModel> relAssocs = this.storage.fetchAssociationRelatedAssociations(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return new ResultList<RelatedAssociationModel>(relAssocs.size(), relAssocs);
    }

    RelatedTopicModel fetchRelatedTopic(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        ResultList<RelatedTopicModel> topics = this.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.getSize()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.getSize() + " related topics (objectId=" + objectId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", " + "othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    ResultList<RelatedTopicModel> fetchRelatedTopics(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModel> relTopics = this.storage.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return new ResultList<RelatedTopicModel>(relTopics.size(), relTopics);
    }

    Object fetchProperty(long id, String propUri) {
        return this.storage.fetchProperty(id, propUri);
    }

    boolean hasProperty(long id, String propUri) {
        return this.storage.hasProperty(id, propUri);
    }

    List<TopicModel> fetchTopicsByProperty(String propUri, Object propValue) {
        return this.storage.fetchTopicsByProperty(propUri, propValue);
    }

    List<TopicModel> fetchTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchTopicsByPropertyRange(propUri, from, to);
    }

    List<AssociationModel> fetchAssociationsByProperty(String propUri, Object propValue) {
        return this.storage.fetchAssociationsByProperty(propUri, propValue);
    }

    List<AssociationModel> fetchAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.storage.fetchAssociationsByPropertyRange(propUri, from, to);
    }

    void storeTopicProperty(long topicId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeTopicProperty(topicId, propUri, propValue, addToIndex);
    }

    void storeAssociationProperty(long assocId, String propUri, Object propValue, boolean addToIndex) {
        this.storage.storeAssociationProperty(assocId, propUri, propValue, addToIndex);
    }

    void removeTopicProperty(long topicId, String propUri) {
        this.storage.deleteTopicProperty(topicId, propUri);
    }

    void removeAssociationProperty(long assocId, String propUri) {
        this.storage.deleteAssociationProperty(assocId, propUri);
    }

    DeepaMehtaTransaction beginTx() {
        return this.storage.beginTx();
    }

    boolean init() {
        boolean isCleanInstall = this.storage.setupRootNode();
        if (isCleanInstall) {
            this.logger.info("Starting with a fresh DB -- Setting migration number to 0");
            this.storeMigrationNr(0);
        }
        return isCleanInstall;
    }

    void shutdown() {
        this.storage.shutdown();
    }

    int fetchMigrationNr() {
        return (Integer)this.storage.fetchProperty(0L, "core_migration_nr");
    }

    void storeMigrationNr(int migrationNr) {
        this.storage.storeTopicProperty(0L, "core_migration_nr", migrationNr, false);
    }

    Object getDatabaseVendorObject() {
        return this.storage.getDatabaseVendorObject();
    }

    Object getDatabaseVendorObject(long objectId) {
        return this.storage.getDatabaseVendorObject(objectId);
    }
}

