/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.osgi.PluginContext;
import de.deepamehta.core.service.PluginService;
import java.lang.reflect.Field;

class InjectableService {
    private PluginContext pluginContext;
    private Class<? extends PluginService> serviceInterface;
    private Field injectableField;
    private PluginService service;

    InjectableService(PluginContext pluginContext, Class<? extends PluginService> serviceInterface, Field injectableField) {
        this.pluginContext = pluginContext;
        this.serviceInterface = serviceInterface;
        this.injectableField = injectableField;
    }

    public String toString() {
        return this.serviceInterface.getName();
    }

    Class<? extends PluginService> getServiceInterface() {
        return this.serviceInterface;
    }

    PluginService getService() {
        if (!this.isServiceAvailable()) {
            throw new RuntimeException("Service " + this + " is not available (consumed by " + this.pluginContext + ")");
        }
        return this.service;
    }

    boolean isServiceAvailable() {
        return this.service != null;
    }

    void injectService(PluginService service) {
        this.service = service;
        this.injectValue(service);
    }

    private void injectValue(Object value) {
        try {
            this.injectableField.set(this.pluginContext, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Injecting " + (value == null ? "null for " : "") + this + " failed", e);
        }
    }
}

