/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.impl.AttachedDeepaMehtaObject;
import de.deepamehta.core.impl.AttachedRelatedTopic;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class AttachedChildTopics
implements ChildTopics {
    private ChildTopicsModel model;
    private AttachedDeepaMehtaObject parent;
    private Map<String, Object> childTopics = new HashMap<String, Object>();
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedChildTopics(ChildTopicsModel model, AttachedDeepaMehtaObject parent, EmbeddedService dms) {
        this.model = model;
        this.parent = parent;
        this.dms = dms;
        this.initAttachedObjectCache();
    }

    @Override
    public RelatedTopic getTopic(String childTypeUri) {
        this.loadChildTopics(childTypeUri);
        return this._getTopic(childTypeUri);
    }

    @Override
    public List<RelatedTopic> getTopics(String childTypeUri) {
        this.loadChildTopics(childTypeUri);
        return this._getTopics(childTypeUri);
    }

    @Override
    public Object get(String childTypeUri) {
        return this.childTopics.get(childTypeUri);
    }

    @Override
    public boolean has(String childTypeUri) {
        return this.childTopics.containsKey(childTypeUri);
    }

    @Override
    public int size() {
        return this.childTopics.size();
    }

    @Override
    public ChildTopicsModel getModel() {
        return this.model;
    }

    @Override
    public String getString(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().toString();
    }

    @Override
    public int getInt(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().intValue();
    }

    @Override
    public long getLong(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().longValue();
    }

    @Override
    public double getDouble(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().doubleValue();
    }

    @Override
    public boolean getBoolean(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().booleanValue();
    }

    @Override
    public Object getObject(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().value();
    }

    @Override
    public ChildTopics getChildTopics(String childTypeUri) {
        return this.getTopic(childTypeUri).getChildTopics();
    }

    @Override
    public ChildTopics set(String childTypeUri, TopicModel value) {
        return this._updateOne(childTypeUri, new RelatedTopicModel(value));
    }

    @Override
    public ChildTopics set(String childTypeUri, Object value) {
        return this._updateOne(childTypeUri, new RelatedTopicModel(childTypeUri, new SimpleValue(value)));
    }

    @Override
    public ChildTopics set(String childTypeUri, ChildTopicsModel value) {
        return this._updateOne(childTypeUri, new RelatedTopicModel(childTypeUri, value));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, long refTopicId) {
        return this._updateOne(childTypeUri, new TopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(childTypeUri, new TopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, String refTopicUri) {
        return this._updateOne(childTypeUri, new TopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateOne(childTypeUri, new TopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics setDeletionRef(String childTypeUri, long refTopicId) {
        return this._updateOne(childTypeUri, new TopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics setDeletionRef(String childTypeUri, String refTopicUri) {
        return this._updateOne(childTypeUri, new TopicDeletionModel(refTopicUri));
    }

    @Override
    public ChildTopics add(String childTypeUri, TopicModel value) {
        return this._updateMany(childTypeUri, new RelatedTopicModel(value));
    }

    @Override
    public ChildTopics add(String childTypeUri, Object value) {
        return this._updateMany(childTypeUri, new RelatedTopicModel(childTypeUri, new SimpleValue(value)));
    }

    @Override
    public ChildTopics add(String childTypeUri, ChildTopicsModel value) {
        return this._updateMany(childTypeUri, new RelatedTopicModel(childTypeUri, value));
    }

    @Override
    public ChildTopics addRef(String childTypeUri, long refTopicId) {
        return this._updateMany(childTypeUri, new TopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics addRef(String childTypeUri, long refTopicId, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(childTypeUri, new TopicReferenceModel(refTopicId, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addRef(String childTypeUri, String refTopicUri) {
        return this._updateMany(childTypeUri, new TopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics addRef(String childTypeUri, String refTopicUri, ChildTopicsModel relatingAssocChildTopics) {
        return this._updateMany(childTypeUri, new TopicReferenceModel(refTopicUri, relatingAssocChildTopics));
    }

    @Override
    public ChildTopics addDeletionRef(String childTypeUri, long refTopicId) {
        return this._updateMany(childTypeUri, new TopicDeletionModel(refTopicId));
    }

    @Override
    public ChildTopics addDeletionRef(String childTypeUri, String refTopicUri) {
        return this._updateMany(childTypeUri, new TopicDeletionModel(refTopicUri));
    }

    @Override
    public Iterator<String> iterator() {
        return this.childTopics.keySet().iterator();
    }

    void update(ChildTopicsModel newComp) {
        try {
            for (AssociationDefinition assocDef : this.parent.getType().getAssocDefs()) {
                String childTypeUri = assocDef.getChildTypeUri();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                RelatedTopicModel newChildTopic = null;
                List<RelatedTopicModel> newChildTopics = null;
                if (cardinalityUri.equals("dm4.core.one")) {
                    newChildTopic = newComp.getTopic(childTypeUri, null);
                    if (newChildTopic == null) {
                        continue;
                    }
                } else if (cardinalityUri.equals("dm4.core.many")) {
                    newChildTopics = newComp.getTopics(childTypeUri, null);
                    if (newChildTopics == null) {
                        continue;
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                this.updateChildTopics(newChildTopic, newChildTopics, assocDef);
            }
            this.refreshParentLabel();
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the child topics of " + this.parent.className() + " " + this.parent.getId() + " failed (newComp=" + newComp + ")", e);
        }
    }

    void updateChildTopics(RelatedTopicModel newChildTopic, List<RelatedTopicModel> newChildTopics, AssociationDefinition assocDef) {
        boolean one;
        this.loadChildTopics(assocDef);
        String assocTypeUri = assocDef.getTypeUri();
        boolean bl = one = newChildTopic != null;
        if (assocTypeUri.equals("dm4.core.composition_def")) {
            if (one) {
                this.updateCompositionOne(newChildTopic, assocDef);
            } else {
                this.updateCompositionMany(newChildTopics, assocDef);
            }
        } else if (assocTypeUri.equals("dm4.core.aggregation_def")) {
            if (one) {
                this.updateAggregationOne(newChildTopic, assocDef);
            } else {
                this.updateAggregationMany(newChildTopics, assocDef);
            }
        } else {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not supported");
        }
    }

    void loadChildTopics() {
        for (AssociationDefinition assocDef : this.parent.getType().getAssocDefs()) {
            this.loadChildTopics(assocDef);
        }
    }

    void loadChildTopics(String childTypeUri) {
        this.loadChildTopics(this.getAssocDef(childTypeUri));
    }

    private void loadChildTopics(AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        if (!this.has(childTypeUri)) {
            this.logger.fine("### Lazy-loading \"" + childTypeUri + "\" child topic(s) of " + this.parent.className() + " " + this.parent.getId());
            this.dms.valueStorage.fetchChildTopics(this.parent.getModel(), assocDef.getModel());
            this.initAttachedObjectCache(childTypeUri);
        }
    }

    private void refreshParentLabel() {
        DeepaMehtaObjectModel parent = this.parent.getModel();
        for (String childTypeUri : this.dms.valueStorage.getLabelChildTypeUris(parent)) {
            this.loadChildTopics(childTypeUri);
        }
        this.dms.valueStorage.refreshLabel(parent);
    }

    private ChildTopics _updateOne(String childTypeUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(new ChildTopicsModel().put(childTypeUri, newChildTopic));
        return this;
    }

    private ChildTopics _updateMany(String childTypeUri, RelatedTopicModel newChildTopic) {
        this.parent.updateChildTopics(new ChildTopicsModel().add(childTypeUri, newChildTopic));
        return this;
    }

    private void updateCompositionOne(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this._getTopic(assocDef.getChildTypeUri(), null);
        if (newChildTopic instanceof TopicDeletionModel) {
            this.deleteChildTopicOne(childTopic, assocDef, true);
        } else if (newChildTopic instanceof TopicReferenceModel) {
            this.createAssignmentOne(childTopic, (TopicReferenceModel)newChildTopic, assocDef, true);
        } else if (childTopic != null) {
            this.updateRelatedTopic(childTopic, newChildTopic);
        } else {
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateCompositionMany(List<RelatedTopicModel> newChildTopics, AssociationDefinition assocDef) {
        for (RelatedTopicModel newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                this.deleteChildTopicMany(childTopicId, assocDef, true);
                continue;
            }
            if (newChildTopic instanceof TopicReferenceModel) {
                this.createAssignmentMany((TopicReferenceModel)newChildTopic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateAggregationOne(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this._getTopic(assocDef.getChildTypeUri(), null);
        if (newChildTopic instanceof TopicDeletionModel) {
            this.deleteChildTopicOne(childTopic, assocDef, false);
        } else if (newChildTopic instanceof TopicReferenceModel) {
            this.createAssignmentOne(childTopic, (TopicReferenceModel)newChildTopic, assocDef, false);
        } else if (newChildTopic.getId() != -1L) {
            this.updateChildTopicOne(newChildTopic, assocDef);
        } else {
            if (childTopic != null) {
                childTopic.getRelatingAssociation().delete();
            }
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateAggregationMany(List<RelatedTopicModel> newChildTopics, AssociationDefinition assocDef) {
        for (RelatedTopicModel newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                this.deleteChildTopicMany(childTopicId, assocDef, false);
                continue;
            }
            if (newChildTopic instanceof TopicReferenceModel) {
                this.createAssignmentMany((TopicReferenceModel)newChildTopic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateChildTopicOne(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this._getTopic(assocDef.getChildTypeUri(), null);
        if (childTopic == null || childTopic.getId() != newChildTopic.getId()) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.parent.className() + " " + this.parent.getId() + " according to " + assocDef);
        }
        this.updateRelatedTopic(childTopic, newChildTopic);
    }

    private void updateChildTopicMany(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this.findChildTopicById(newChildTopic.getId(), assocDef);
        if (childTopic == null) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.parent.className() + " " + this.parent.getId() + " according to " + assocDef);
        }
        this.updateRelatedTopic(childTopic, newChildTopic);
    }

    private void updateRelatedTopic(RelatedTopic childTopic, RelatedTopicModel newChildTopic) {
        ((AttachedTopic)((Object)childTopic))._update(newChildTopic);
        this.updateRelatingAssociation(childTopic, newChildTopic);
    }

    private void updateRelatingAssociation(RelatedTopic childTopic, RelatedTopicModel newChildTopic) {
        childTopic.getRelatingAssociation().update(newChildTopic.getRelatingAssociation());
    }

    private void createChildTopicOne(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this.createAndAssociateChildTopic(newChildTopic, assocDef);
        this.putInChildTopics(childTopic, assocDef);
    }

    private void createChildTopicMany(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this.createAndAssociateChildTopic(newChildTopic, assocDef);
        this.addToChildTopics(childTopic, assocDef);
    }

    private RelatedTopic createAndAssociateChildTopic(RelatedTopicModel childTopic, AssociationDefinition assocDef) {
        this.dms.createTopic(childTopic);
        return this.associateChildTopic(childTopic, assocDef);
    }

    private void createAssignmentOne(RelatedTopic childTopic, TopicReferenceModel newChildTopic, AssociationDefinition assocDef, boolean deleteChildTopic) {
        if (childTopic != null) {
            if (newChildTopic.isReferingTo(childTopic)) {
                this.updateRelatingAssociation(childTopic, newChildTopic);
                return;
            }
            if (deleteChildTopic) {
                childTopic.delete();
            } else {
                childTopic.getRelatingAssociation().delete();
            }
        }
        RelatedTopic topic = this.resolveRefAndAssociateChildTopic(newChildTopic, assocDef);
        this.putInChildTopics(topic, assocDef);
    }

    private void createAssignmentMany(TopicReferenceModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = this.findChildTopicByRef(newChildTopic, assocDef);
        if (childTopic != null) {
            this.updateRelatingAssociation(childTopic, newChildTopic);
            return;
        }
        RelatedTopic topic = this.resolveRefAndAssociateChildTopic(newChildTopic, assocDef);
        this.addToChildTopics(topic, assocDef);
    }

    RelatedTopic resolveRefAndAssociateChildTopic(TopicReferenceModel childTopicRef, AssociationDefinition assocDef) {
        this.dms.valueStorage.resolveReference(childTopicRef);
        return this.associateChildTopic(childTopicRef, assocDef);
    }

    private RelatedTopic associateChildTopic(RelatedTopicModel childTopic, AssociationDefinition assocDef) {
        this.dms.valueStorage.associateChildTopic(this.parent.getModel(), childTopic, assocDef.getModel());
        return this.instantiateRelatedTopic(childTopic);
    }

    private void deleteChildTopicOne(RelatedTopic childTopic, AssociationDefinition assocDef, boolean deleteChildTopic) {
        if (childTopic == null) {
            return;
        }
        if (deleteChildTopic) {
            childTopic.delete();
        } else {
            childTopic.getRelatingAssociation().delete();
        }
        this.removeChildTopic(assocDef);
    }

    private void deleteChildTopicMany(long childTopicId, AssociationDefinition assocDef, boolean deleteChildTopic) {
        RelatedTopic childTopic = this.findChildTopicById(childTopicId, assocDef);
        if (childTopic == null) {
            return;
        }
        if (deleteChildTopic) {
            childTopic.delete();
        } else {
            childTopic.getRelatingAssociation().delete();
        }
        this.removeFromChildTopics(childTopic, assocDef);
    }

    private RelatedTopic _getTopic(String childTypeUri) {
        RelatedTopic topic = (RelatedTopic)this.childTopics.get(childTypeUri);
        if (topic == null) {
            throw new RuntimeException("Child topic of type \"" + childTypeUri + "\" not found in " + this.childTopics);
        }
        return topic;
    }

    private RelatedTopic _getTopic(String childTypeUri, RelatedTopic defaultTopic) {
        RelatedTopic topic = (RelatedTopic)this.childTopics.get(childTypeUri);
        return topic != null ? topic : defaultTopic;
    }

    private List<RelatedTopic> _getTopics(String childTypeUri) {
        try {
            List topics = (List)this.childTopics.get(childTypeUri);
            if (topics == null) {
                throw new RuntimeException("Child topics of type \"" + childTypeUri + "\" not found in " + this.childTopics);
            }
            return topics;
        }
        catch (ClassCastException e) {
            this.getModel().throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    private List<RelatedTopic> _getTopics(String childTypeUri, List<RelatedTopic> defaultValue) {
        try {
            List<RelatedTopic> topics = (List<RelatedTopic>)this.childTopics.get(childTypeUri);
            return topics != null ? topics : defaultValue;
        }
        catch (ClassCastException e) {
            this.getModel().throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    private RelatedTopic findChildTopicById(long childTopicId, AssociationDefinition assocDef) {
        List<RelatedTopic> childTopics = this._getTopics(assocDef.getChildTypeUri(), new ArrayList<RelatedTopic>());
        for (RelatedTopic childTopic : childTopics) {
            if (childTopic.getId() != childTopicId) continue;
            return childTopic;
        }
        return null;
    }

    private RelatedTopic findChildTopicByRef(TopicReferenceModel topicRef, AssociationDefinition assocDef) {
        return topicRef.findReferencedTopic(this._getTopics(assocDef.getChildTypeUri(), new ArrayList<RelatedTopic>()));
    }

    private AssociationDefinition getAssocDef(String childTypeUri) {
        return this.parent.getType().getAssocDef(childTypeUri);
    }

    private void putInChildTopics(RelatedTopic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.put(childTypeUri, childTopic);
        this.getModel().put(childTypeUri, childTopic.getModel());
    }

    private void removeChildTopic(AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.remove(childTypeUri);
        this.getModel().remove(childTypeUri);
    }

    private void addToChildTopics(RelatedTopic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.add(childTypeUri, childTopic);
        this.getModel().add(childTypeUri, childTopic.getModel());
    }

    private void removeFromChildTopics(Topic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.remove(childTypeUri, childTopic);
        this.getModel().remove(childTypeUri, childTopic.getModel());
    }

    private void put(String childTypeUri, Topic topic) {
        this.childTopics.put(childTypeUri, topic);
    }

    private void remove(String childTypeUri) {
        this.childTopics.remove(childTypeUri);
    }

    private void add(String childTypeUri, RelatedTopic topic) {
        List<RelatedTopic> topics = this._getTopics(childTypeUri, null);
        if (topics == null) {
            topics = new ArrayList<RelatedTopic>();
            this.childTopics.put(childTypeUri, topics);
        }
        topics.add(topic);
    }

    private void remove(String childTypeUri, Topic topic) {
        List<RelatedTopic> topics = this._getTopics(childTypeUri, null);
        if (topics != null) {
            topics.remove(topic);
        }
    }

    private void initAttachedObjectCache() {
        for (String childTypeUri : this.model) {
            this.initAttachedObjectCache(childTypeUri);
        }
    }

    private void initAttachedObjectCache(String childTypeUri) {
        Object value = this.model.get(childTypeUri);
        if (value == null) {
            return;
        }
        if (value instanceof RelatedTopicModel) {
            RelatedTopicModel childTopic = (RelatedTopicModel)value;
            this.childTopics.put(childTypeUri, this.instantiateRelatedTopic(childTopic));
        } else if (value instanceof List) {
            ArrayList<RelatedTopic> topics = new ArrayList<RelatedTopic>();
            this.childTopics.put(childTypeUri, topics);
            for (RelatedTopicModel childTopic : (List)value) {
                topics.add(this.instantiateRelatedTopic(childTopic));
            }
        } else {
            throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
        }
    }

    private RelatedTopic instantiateRelatedTopic(RelatedTopicModel model) {
        try {
            return new AttachedRelatedTopic(model, this.dms);
        }
        catch (Exception e) {
            throw new RuntimeException("RelatedTopic instantiation failed (" + model + ")", e);
        }
    }
}

