/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.osgi;

import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.impl.StorageDecorator;
import de.deepamehta.core.impl.WebPublishingService;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.storage.spi.DeepaMehtaStorage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class CoreActivator
implements BundleActivator {
    private BundleContext bundleContext;
    private DeepaMehtaStorage storageService;
    private HttpService httpService;
    private ServiceTracker storageServiceTracker;
    private ServiceTracker httpServiceTracker;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext bundleContext) {
        try {
            this.logger.info("========== Starting \"DeepaMehta 4 Core\" ==========");
            this.bundleContext = bundleContext;
            this.storageServiceTracker = this.createServiceTracker(DeepaMehtaStorage.class);
            this.httpServiceTracker = this.createServiceTracker(HttpService.class);
            this.storageServiceTracker.open();
            this.httpServiceTracker.open();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Starting \"DeepaMehta 4 Core\" failed", e);
        }
    }

    public void stop(BundleContext bundleContext) {
        try {
            this.logger.info("========== Stopping \"DeepaMehta 4 Core\" ==========");
            this.storageServiceTracker.close();
            this.httpServiceTracker.close();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Stopping \"DeepaMehta 4 Core\" failed", e);
        }
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(this.bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    CoreActivator.this.addService(service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "Adding service " + serviceInterface.getName() + " to \"DeepaMehta 4 Core\" failed", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    CoreActivator.this.removeService(service);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "Removing service " + serviceInterface.getName() + " from \"DeepaMehta 4 Core\" failed", e);
                }
            }
        };
    }

    private void addService(Object service) {
        if (service instanceof DeepaMehtaStorage) {
            this.logger.info("Adding storage service to DeepaMehta 4 Core");
            this.storageService = (DeepaMehtaStorage)service;
            this.checkRequirementsForActivation();
        } else if (service instanceof HttpService) {
            this.logger.info("Adding HTTP service to DeepaMehta 4 Core");
            this.httpService = (HttpService)service;
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service) {
        if (service == this.storageService) {
            this.logger.info("Removing storage service from DeepaMehta 4 Core");
            this.storageService = null;
        } else if (service == this.httpService) {
            this.logger.info("Removing HTTP service from DeepaMehta 4 Core");
            this.httpService = null;
        }
    }

    private void checkRequirementsForActivation() {
        if (this.storageService != null && this.httpService != null) {
            EmbeddedService dms = new EmbeddedService(new StorageDecorator(this.storageService), this.bundleContext);
            this.logger.info("Registering DeepaMehta 4 core service at OSGi framework");
            this.bundleContext.registerService(DeepaMehtaService.class.getName(), (Object)dms, null);
            WebPublishingService wpService = new WebPublishingService(dms, this.httpService);
            this.logger.info("Registering Web Publishing service at OSGi framework");
            this.bundleContext.registerService(WebPublishingService.class.getName(), (Object)wpService, null);
        }
    }
}

