/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.Topic;
import de.deepamehta.core.model.TopicModel;
import java.util.List;

public class TopicReferenceModel
extends TopicModel {
    public TopicReferenceModel(long topicId) {
        super(topicId);
    }

    public TopicReferenceModel(String uri) {
        super(uri, (String)null);
    }

    public boolean isReferenceById() {
        return this.getId() != -1L;
    }

    public boolean isReferenceByUri() {
        return !this.getUri().equals("");
    }

    public boolean isReferingTo(Topic topic) {
        if (this.isReferenceById()) {
            return this.getId() == topic.getId();
        }
        if (this.isReferenceByUri()) {
            return this.getUri().equals(topic.getUri());
        }
        throw new RuntimeException("Invalid topic reference (" + this + ")");
    }

    public boolean isReferingToAny(List<Topic> topics) {
        for (Topic topic : topics) {
            if (!this.isReferingTo(topic)) continue;
            return true;
        }
        return false;
    }
}

