/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.service.PluginInfo;
import de.deepamehta.core.util.JavaUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.osgi.framework.Bundle;

class PluginInfoImpl
implements PluginInfo {
    private static final String PLUGIN_FILE = "/web/script/plugin.js";
    private static final String PLUGIN_RENDERERS_PATH = "/web/script/renderers/";
    private static final String PLUGIN_HELPER_PATH = "/web/script/helper/";
    private static final String PLUGIN_STYLE_PATH = "/web/style/";
    private Bundle pluginBundle;
    private JSONObject pluginInfo = new JSONObject();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    PluginInfoImpl(String pluginUri, Bundle pluginBundle) {
        this.pluginBundle = pluginBundle;
        try {
            this.pluginInfo.put("plugin_uri", (Object)pluginUri);
            this.pluginInfo.put("has_plugin_file", this.hasPluginFile());
            this.pluginInfo.put("stylesheets", this.getStylesheets());
            this.pluginInfo.put("renderers", (Object)this.getRenderers());
            this.pluginInfo.put("helper", this.getHelper());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public JSONObject toJSON() {
        return this.pluginInfo;
    }

    private boolean hasPluginFile() {
        return this.pluginBundle.getEntry(PLUGIN_FILE) != null;
    }

    private List<String> getStylesheets() {
        return this.getFilenames(PLUGIN_STYLE_PATH);
    }

    private JSONObject getRenderers() throws JSONException {
        JSONObject renderers = new JSONObject();
        renderers.put("page_renderers", this.getRenderers("page_renderers"));
        renderers.put("simple_renderers", this.getRenderers("simple_renderers"));
        renderers.put("multi_renderers", this.getRenderers("multi_renderers"));
        return renderers;
    }

    private List<String> getHelper() {
        return this.getFilenames(PLUGIN_HELPER_PATH);
    }

    private List<String> getRenderers(String renderersDir) {
        return this.getFilenames(PLUGIN_RENDERERS_PATH + renderersDir);
    }

    private List<String> getFilenames(String path) {
        ArrayList<String> filenames = new ArrayList<String>();
        Enumeration e = this.pluginBundle.getEntryPaths(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                String entryPath = (String)e.nextElement();
                if (entryPath.endsWith("/")) continue;
                filenames.add(JavaUtils.getFilename(entryPath));
            }
        }
        return filenames;
    }
}

