/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationType;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.impl.InjectableService;
import de.deepamehta.core.impl.PluginInfoImpl;
import de.deepamehta.core.impl.RestResources;
import de.deepamehta.core.impl.StaticResources;
import de.deepamehta.core.impl.WebPublishingService;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginContext;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.EventListener;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Plugin;
import de.deepamehta.core.service.PluginInfo;
import de.deepamehta.core.service.PluginService;
import de.deepamehta.core.service.SecurityHandler;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class PluginImpl
implements Plugin,
EventHandler {
    private static final String PLUGIN_DEFAULT_PACKAGE = "de.deepamehta.core.osgi";
    private static final String PLUGIN_CONFIG_FILE = "/plugin.properties";
    private static final String PLUGIN_ACTIVATED = "de/deepamehta/core/plugin_activated";
    private PluginContext pluginContext;
    private BundleContext bundleContext;
    private Bundle pluginBundle;
    private String pluginUri;
    private Properties pluginProperties;
    private String pluginPackage;
    private PluginInfo pluginInfo;
    private List<String> pluginDependencies;
    private Topic pluginTopic;
    private EmbeddedService dms;
    private WebPublishingService webPublishingService;
    private EventAdmin eventService;
    private Map<Class<? extends PluginService>, InjectableService> consumedPluginServices = new HashMap<Class<? extends PluginService>, InjectableService>();
    private List<ServiceTracker> serviceTrackers = new ArrayList<ServiceTracker>();
    private String providedServiceInterface;
    private ServiceRegistration registration;
    private StaticResources staticResources;
    private StaticResources directoryResource;
    private RestResources restResources;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public PluginImpl(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
        this.bundleContext = pluginContext.getBundleContext();
        this.pluginBundle = this.bundleContext.getBundle();
        this.pluginUri = this.pluginBundle.getSymbolicName();
        this.pluginProperties = this.readConfigFile();
        this.pluginPackage = this.getConfigProperty("pluginPackage", pluginContext.getClass().getPackage().getName());
        this.pluginInfo = new PluginInfoImpl(this.pluginUri, this.pluginBundle);
        this.pluginDependencies = this.pluginDependencies();
        this.providedServiceInterface = this.providedServiceInterface();
    }

    public void start() {
        if (this.pluginDependencies.size() > 0) {
            this.registerPluginActivatedEventListener();
        }
        this.createCoreServiceTrackers();
        this.createPluginServiceTrackers();
        this.openServiceTrackers();
    }

    public void stop() {
        this.pluginContext.shutdown();
        this.closeServiceTrackers();
    }

    public void publishDirectory(String directoryPath, String uriNamespace, SecurityHandler securityHandler) {
        try {
            this.logger.info("### Publishing directory \"" + directoryPath + "\" at URI namespace \"" + uriNamespace + "\"");
            if (this.directoryResource != null) {
                throw new RuntimeException(this + " has already published a directory; " + "only one per plugin is supported");
            }
            this.directoryResource = this.webPublishingService.publishStaticResources(directoryPath, uriNamespace, securityHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Publishing directory \"" + directoryPath + "\" at URI namespace \"" + uriNamespace + "\" failed", e);
        }
    }

    public String getUri() {
        return this.pluginUri;
    }

    @Override
    public InputStream getStaticResource(String name) {
        try {
            URL url = this.pluginBundle.getResource(name);
            if (url == null) {
                throw new RuntimeException("Resource \"" + name + "\" not found");
            }
            return url.openStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Accessing a static resource of " + this + " failed", e);
        }
    }

    @Override
    public boolean hasStaticResource(String name) {
        return this.getBundleEntry(name) != null;
    }

    public String toString() {
        return this.pluginContext.toString();
    }

    PluginInfo getInfo() {
        return this.pluginInfo;
    }

    PluginContext getContext() {
        return this.pluginContext;
    }

    Topic getPluginTopic() {
        return this.pluginTopic;
    }

    String getProvidedServiceInterface() {
        return this.providedServiceInterface;
    }

    String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    String getConfigProperty(String key, String defaultValue) {
        return this.pluginProperties.getProperty(key, defaultValue);
    }

    String getMigrationClassName(int migrationNr) {
        if (this.pluginPackage.equals(PLUGIN_DEFAULT_PACKAGE)) {
            return null;
        }
        return this.pluginPackage + ".migrations.Migration" + migrationNr;
    }

    void setMigrationNr(int migrationNr) {
        this.pluginTopic.getChildTopics().set("dm4.core.plugin_migration_nr", migrationNr);
    }

    Class loadClass(String className) {
        try {
            return this.pluginBundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Properties readConfigFile() {
        try {
            Properties properties = new Properties();
            if (!this.hasStaticResource(PLUGIN_CONFIG_FILE)) {
                this.logger.info("Reading config file \"/plugin.properties\" for " + this + " ABORTED " + "-- file does not exist");
                return properties;
            }
            this.logger.info("Reading config file \"/plugin.properties\" for " + this);
            properties.load(this.getStaticResource(PLUGIN_CONFIG_FILE));
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Reading config file \"/plugin.properties\" for " + this + " failed", e);
        }
    }

    private void createCoreServiceTrackers() {
        this.serviceTrackers.add(this.createServiceTracker(DeepaMehtaService.class));
        this.serviceTrackers.add(this.createServiceTracker(WebPublishingService.class));
        this.serviceTrackers.add(this.createServiceTracker(EventAdmin.class));
    }

    private void createPluginServiceTrackers() {
        List<InjectableService> injectableServices = this.createInjectableServices();
        if (injectableServices.isEmpty()) {
            this.logger.info("Tracking plugin services for " + this + " ABORTED -- no services consumed");
            return;
        }
        this.logger.info("Tracking " + injectableServices.size() + " plugin services for " + this + " " + injectableServices);
        for (InjectableService injectableService : injectableServices) {
            Class<? extends PluginService> serviceInterface = injectableService.getServiceInterface();
            this.consumedPluginServices.put(serviceInterface, injectableService);
            this.serviceTrackers.add(this.createServiceTracker(serviceInterface));
        }
    }

    private List<InjectableService> createInjectableServices() {
        ArrayList<InjectableService> injectableServices = new ArrayList<InjectableService>();
        for (Field field : PluginImpl.getInjectableFields(this.pluginContext.getClass())) {
            Class<?> serviceInterface = field.getType();
            injectableServices.add(new InjectableService(this.pluginContext, serviceInterface, field));
        }
        return injectableServices;
    }

    private boolean pluginServicesAvailable() {
        for (InjectableService injectableService : this.consumedPluginServices.values()) {
            if (injectableService.isServiceAvailable()) continue;
            return false;
        }
        return true;
    }

    static List<Field> getInjectableFields(Class<?> clazz) {
        ArrayList<Field> injectableFields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            Class<?> fieldType = field.getType();
            if (!PluginService.class.isAssignableFrom(fieldType)) {
                throw new RuntimeException("@Inject annotated field \"" + field.getName() + "\" has unsupported type (" + fieldType.getName() + "). Use @Inject " + "only for injecting plugin services.");
            }
            field.setAccessible(true);
            injectableFields.add(field);
        }
        return injectableFields;
    }

    PluginService getPluginService(Class<? extends PluginService> serviceInterface) {
        InjectableService injectableService = this.consumedPluginServices.get(serviceInterface);
        if (injectableService == null) {
            throw new RuntimeException("Service " + serviceInterface.getName() + " is not consumed by " + this);
        }
        return injectableService.getService();
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(this.bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    PluginImpl.this.addService(service, serviceInterface);
                }
                catch (Throwable e) {
                    PluginImpl.this.logger.log(Level.SEVERE, "Adding service " + serviceInterface.getName() + " to " + PluginImpl.this.pluginContext + " failed", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    PluginImpl.this.removeService(service, serviceInterface);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    PluginImpl.this.logger.log(Level.SEVERE, "Removing service " + serviceInterface.getName() + " from " + PluginImpl.this.pluginContext + " failed", e);
                }
            }
        };
    }

    private void openServiceTrackers() {
        for (ServiceTracker serviceTracker : this.serviceTrackers) {
            serviceTracker.open();
        }
    }

    private void closeServiceTrackers() {
        for (ServiceTracker serviceTracker : this.serviceTrackers) {
            serviceTracker.close();
        }
    }

    private void addService(Object service, Class serviceInterface) {
        if (service instanceof DeepaMehtaService) {
            this.logger.info("Adding DeepaMehta 4 core service to " + this);
            this.setCoreService((EmbeddedService)service);
            this.checkRequirementsForActivation();
        } else if (service instanceof WebPublishingService) {
            this.logger.info("Adding Web Publishing service to " + this);
            this.webPublishingService = (WebPublishingService)service;
            this.publishStaticResources();
            this.publishRestResources();
            this.checkRequirementsForActivation();
        } else if (service instanceof EventAdmin) {
            this.logger.info("Adding Event Admin service to " + this);
            this.eventService = (EventAdmin)service;
            this.checkRequirementsForActivation();
        } else if (service instanceof PluginService) {
            this.logger.info("Adding service " + serviceInterface.getName() + " to " + this);
            this.consumedPluginServices.get(serviceInterface).injectService((PluginService)service);
            this.pluginContext.serviceArrived((PluginService)service);
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service, Class serviceInterface) {
        if (service == this.dms) {
            this.logger.info("Removing DeepaMehta 4 core service from " + this);
            this.dms.pluginManager.deactivatePlugin(this);
            this.setCoreService(null);
        } else if (service == this.webPublishingService) {
            this.logger.info("Removing Web Publishing service from " + this);
            this.unpublishRestResources();
            this.unpublishStaticResources();
            this.unpublishDirectoryResource();
            this.webPublishingService = null;
        } else if (service == this.eventService) {
            this.logger.info("Removing Event Admin service from " + this);
            this.eventService = null;
        } else if (service instanceof PluginService) {
            this.logger.info("Removing service " + serviceInterface.getName() + " from " + this);
            this.pluginContext.serviceGone((PluginService)service);
            this.consumedPluginServices.get(serviceInterface).injectService(null);
        }
    }

    private void setCoreService(EmbeddedService dms) {
        this.dms = dms;
        this.pluginContext.setCoreService(dms);
    }

    private void checkRequirementsForActivation() {
        if (this.dms != null && this.webPublishingService != null && this.eventService != null && this.pluginServicesAvailable() && this.dependenciesAvailable()) {
            this.dms.pluginManager.activatePlugin(this);
        }
    }

    void activate() {
        try {
            this.logger.info("----- Activating " + this + " -----");
            this.installPluginInDB();
            this.initializePlugin();
            this.registerListeners();
            this.registerPluginService();
            this.logger.info("----- Activation of " + this + " complete -----");
            this.postPluginActivatedEvent();
        }
        catch (Exception e) {
            throw new RuntimeException("Activation of " + this + " failed", e);
        }
    }

    void deactivate() {
        this.unregisterListeners();
    }

    private void installPluginInDB() {
        DeepaMehtaTransaction tx = this.dms.beginTx();
        try {
            boolean isCleanInstall = this.createPluginTopicIfNotExists();
            this.dms.migrationManager.runPluginMigrations(this, isCleanInstall);
            if (isCleanInstall) {
                this.introduceTopicTypesToPlugin();
                this.introduceAssociationTypesToPlugin();
            }
            tx.success();
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK! (" + this + ")");
            throw new RuntimeException("Installing " + this + " in the database failed", e);
        }
        finally {
            tx.finish();
        }
    }

    private boolean createPluginTopicIfNotExists() {
        this.pluginTopic = this.fetchPluginTopic();
        if (this.pluginTopic != null) {
            this.logger.info("Installing " + this + " in the database ABORTED -- already installed");
            return false;
        }
        this.logger.info("Installing " + this + " in the database");
        this.pluginTopic = this.createPluginTopic();
        return true;
    }

    private Topic createPluginTopic() {
        return this.dms.createTopic(new TopicModel(this.pluginUri, "dm4.core.plugin", new ChildTopicsModel().put("dm4.core.plugin_name", this.pluginName()).put("dm4.core.plugin_symbolic_name", this.pluginUri).put("dm4.core.plugin_migration_nr", 0)));
    }

    private Topic fetchPluginTopic() {
        return this.dms.getTopic("uri", new SimpleValue(this.pluginUri));
    }

    private void introduceTopicTypesToPlugin() {
        try {
            for (String topicTypeUri : this.dms.getTopicTypeUris()) {
                if (topicTypeUri.equals("dm4.core.meta_meta_type")) continue;
                TopicType topicType = this.dms.getTopicType(topicTypeUri);
                this.deliverEvent(CoreEvent.INTRODUCE_TOPIC_TYPE, topicType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Introducing topic types to " + this + " failed", e);
        }
    }

    private void introduceAssociationTypesToPlugin() {
        try {
            for (String assocTypeUri : this.dms.getAssociationTypeUris()) {
                AssociationType assocType = this.dms.getAssociationType(assocTypeUri);
                this.deliverEvent(CoreEvent.INTRODUCE_ASSOCIATION_TYPE, assocType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Introducing association types to " + this + " failed", e);
        }
    }

    private void initializePlugin() {
        this.pluginContext.init();
    }

    private void registerListeners() {
        List<DeepaMehtaEvent> events = this.getEvents();
        if (events.size() == 0) {
            this.logger.info("Registering event listeners of " + this + " ABORTED -- no event listeners implemented");
            return;
        }
        this.logger.info("Registering " + events.size() + " event listeners of " + this);
        for (DeepaMehtaEvent event : events) {
            this.dms.eventManager.addListener(event, (EventListener)((Object)this.pluginContext));
        }
    }

    private void unregisterListeners() {
        List<DeepaMehtaEvent> events = this.getEvents();
        if (events.size() == 0) {
            return;
        }
        this.logger.info("Unregistering event listeners of " + this);
        for (DeepaMehtaEvent event : events) {
            this.dms.eventManager.removeListener(event, (EventListener)((Object)this.pluginContext));
        }
    }

    private List<DeepaMehtaEvent> getEvents() {
        ArrayList<DeepaMehtaEvent> events = new ArrayList<DeepaMehtaEvent>();
        for (Class<?> interfaze : this.pluginContext.getClass().getInterfaces()) {
            if (!this.isListenerInterface(interfaze)) continue;
            DeepaMehtaEvent event = DeepaMehtaEvent.getEvent(interfaze);
            this.logger.fine("### EventListener Interface: " + interfaze + ", event=" + event);
            events.add(event);
        }
        return events;
    }

    private void deliverEvent(DeepaMehtaEvent event, Object ... params) {
        this.dms.eventManager.deliverEvent(this, event, params);
    }

    private boolean isListenerInterface(Class interfaze) {
        return EventListener.class.isAssignableFrom(interfaze);
    }

    private void registerPluginService() {
        try {
            if (this.providedServiceInterface == null) {
                this.logger.info("Registering OSGi service of " + this + " ABORTED -- no OSGi service provided");
                return;
            }
            this.logger.info("Registering service \"" + this.providedServiceInterface + "\" at OSGi framework");
            this.registration = this.bundleContext.registerService(this.providedServiceInterface, (Object)this.pluginContext, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering service of " + this + " at OSGi framework failed", e);
        }
    }

    private String providedServiceInterface() {
        List<String> serviceInterfaces = this.scanPackage("/service");
        switch (serviceInterfaces.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return serviceInterfaces.get(0);
            }
        }
        throw new RuntimeException("Only one service interface per plugin is supported");
    }

    private void publishStaticResources() {
        String uriNamespace = null;
        try {
            uriNamespace = this.getStaticResourcesNamespace();
            if (uriNamespace == null) {
                this.logger.info("Publishing static resources of " + this + " ABORTED -- no static resources provided");
                return;
            }
            this.logger.info("Publishing static resources of " + this + " at URI namespace \"" + uriNamespace + "\"");
            this.staticResources = this.webPublishingService.publishStaticResources(this.pluginBundle, uriNamespace);
        }
        catch (Exception e) {
            throw new RuntimeException("Publishing static resources of " + this + " failed " + "(uriNamespace=\"" + uriNamespace + "\")", e);
        }
    }

    private void unpublishStaticResources() {
        if (this.staticResources != null) {
            this.logger.info("Unpublishing static resources of " + this);
            this.webPublishingService.unpublishStaticResources(this.staticResources);
        }
    }

    private String getStaticResourcesNamespace() {
        return this.getBundleEntry("/web") != null ? "/" + this.pluginUri : null;
    }

    private URL getBundleEntry(String path) {
        return this.pluginBundle.getEntry(path);
    }

    private void unpublishDirectoryResource() {
        if (this.directoryResource != null) {
            this.logger.info("Unpublishing directory resource of " + this);
            this.webPublishingService.unpublishStaticResources(this.directoryResource);
        }
    }

    private void publishRestResources() {
        try {
            List<Object> rootResources = this.getRootResources();
            if (rootResources.size() != 0) {
                String uriNamespace = this.webPublishingService.getUriNamespace(this.pluginContext);
                this.logger.info("Publishing REST resources of " + this + " at URI namespace \"" + uriNamespace + "\"");
            } else {
                this.logger.info("Publishing REST resources of " + this + " ABORTED -- no REST resources provided");
            }
            List<Class<?>> providerClasses = this.getProviderClasses();
            if (providerClasses.size() != 0) {
                this.logger.info("Registering " + providerClasses.size() + " provider classes of " + this);
            } else {
                this.logger.info("Registering provider classes of " + this + " ABORTED -- no provider classes provided");
            }
            if (rootResources.size() != 0 || providerClasses.size() != 0) {
                this.restResources = this.webPublishingService.publishRestResources(rootResources, providerClasses);
            }
        }
        catch (Exception e) {
            this.unpublishStaticResources();
            throw new RuntimeException("Publishing REST resources (including provider classes) of " + this + " failed", e);
        }
    }

    private void unpublishRestResources() {
        if (this.restResources != null) {
            this.logger.info("Unpublishing REST resources (including provider classes) of " + this);
            this.webPublishingService.unpublishRestResources(this.restResources);
        }
    }

    private List<Object> getRootResources() {
        ArrayList<Object> rootResources = new ArrayList<Object>();
        if (this.webPublishingService.isRootResource(this.pluginContext)) {
            rootResources.add(this.pluginContext);
        }
        return rootResources;
    }

    private List<Class<?>> getProviderClasses() throws IOException {
        ArrayList providerClasses = new ArrayList();
        for (String className : this.scanPackage("/provider")) {
            Class providerClass = this.loadClass(className);
            if (providerClass == null) {
                throw new RuntimeException("Loading provider class \"" + className + "\" failed");
            }
            providerClasses.add(providerClass);
        }
        return providerClasses;
    }

    private List<String> pluginDependencies() {
        ArrayList<String> pluginDependencies = new ArrayList<String>();
        String importModels = this.getConfigProperty("importModels");
        if (importModels != null) {
            String[] pluginUris = importModels.split(", *");
            for (int i = 0; i < pluginUris.length; ++i) {
                pluginDependencies.add(pluginUris[i]);
            }
        }
        return pluginDependencies;
    }

    private boolean hasDependency(String pluginUri) {
        return this.pluginDependencies.contains(pluginUri);
    }

    private boolean dependenciesAvailable() {
        for (String pluginUri : this.pluginDependencies) {
            if (this.isPluginActivated(pluginUri)) continue;
            return false;
        }
        return true;
    }

    private boolean isPluginActivated(String pluginUri) {
        return this.dms.pluginManager.isPluginActivated(pluginUri);
    }

    private void registerPluginActivatedEventListener() {
        String[] topics = new String[]{PLUGIN_ACTIVATED};
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("event.topics", topics);
        this.bundleContext.registerService(EventHandler.class.getName(), (Object)this, properties);
    }

    private void postPluginActivatedEvent() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("bundle.symbolicName", this.pluginUri);
        this.eventService.postEvent(new Event(PLUGIN_ACTIVATED, properties));
    }

    public void handleEvent(Event event) {
        String pluginUri = null;
        try {
            if (!event.getTopic().equals(PLUGIN_ACTIVATED)) {
                throw new RuntimeException("Unexpected event: " + event);
            }
            pluginUri = (String)event.getProperty("bundle.symbolicName");
            if (!this.hasDependency(pluginUri)) {
                return;
            }
            this.logger.info("Handling PLUGIN_ACTIVATED event from \"" + pluginUri + "\" for " + this);
            this.checkRequirementsForActivation();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Handling PLUGIN_ACTIVATED event from \"" + pluginUri + "\" for " + this + " failed", e);
        }
    }

    private String pluginName() {
        return this.pluginContext.getPluginName();
    }

    private List<String> scanPackage(String relativePath) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<String> e = this.getPluginPaths(relativePath);
        if (e != null) {
            while (e.hasMoreElements()) {
                String entryPath = e.nextElement();
                String className = this.entryPathToClassName(entryPath);
                this.logger.fine("  # Found class: " + className);
                classNames.add(className);
            }
        }
        return classNames;
    }

    private Enumeration<String> getPluginPaths(String relativePath) {
        String path = "/" + this.pluginPackage.replace('.', '/') + relativePath;
        this.logger.fine("### Scanning path \"" + path + "\"");
        return this.pluginBundle.getEntryPaths(path);
    }

    private String entryPathToClassName(String entryPath) {
        entryPath = entryPath.substring(0, entryPath.length() - 6);
        return entryPath.replace('/', '.');
    }
}

