/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AccessControlImpl;
import de.deepamehta.core.impl.AssociationIterable;
import de.deepamehta.core.impl.AttachedAssociation;
import de.deepamehta.core.impl.AttachedAssociationType;
import de.deepamehta.core.impl.AttachedRelatedAssociation;
import de.deepamehta.core.impl.AttachedRelatedTopic;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.AttachedTopicType;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EventManager;
import de.deepamehta.core.impl.MigrationManager;
import de.deepamehta.core.impl.PluginManager;
import de.deepamehta.core.impl.StorageDecorator;
import de.deepamehta.core.impl.TopicIterable;
import de.deepamehta.core.impl.TypeCache;
import de.deepamehta.core.impl.TypeStorageImpl;
import de.deepamehta.core.impl.ValueStorage;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.Plugin;
import de.deepamehta.core.service.PluginInfo;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.TypeStorage;
import de.deepamehta.core.service.accesscontrol.AccessControl;
import de.deepamehta.core.service.accesscontrol.AccessControlException;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class EmbeddedService
implements DeepaMehtaService {
    private static final String URI_PREFIX_TOPIC_TYPE = "domain.project.topic_type_";
    private static final String URI_PREFIX_ASSOCIATION_TYPE = "domain.project.assoc_type_";
    private static final String URI_PREFIX_ROLE_TYPE = "domain.project.role_type_";
    StorageDecorator storageDecorator;
    BundleContext bundleContext;
    MigrationManager migrationManager;
    PluginManager pluginManager;
    EventManager eventManager;
    TypeCache typeCache;
    TypeStorageImpl typeStorage;
    ValueStorage valueStorage;
    AccessControl accessControl;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public EmbeddedService(StorageDecorator storageDecorator, BundleContext bundleContext) {
        this.storageDecorator = storageDecorator;
        this.bundleContext = bundleContext;
        this.migrationManager = new MigrationManager(this);
        this.pluginManager = new PluginManager(this);
        this.eventManager = new EventManager(this);
        this.typeCache = new TypeCache(this);
        this.typeStorage = new TypeStorageImpl(this);
        this.valueStorage = new ValueStorage(this);
        this.accessControl = new AccessControlImpl(this);
        this.bootstrapTypeCache();
        this.setupDB();
    }

    @Override
    public Topic getTopic(long topicId) {
        try {
            return this.instantiateTopic(this.storageDecorator.fetchTopic(topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic " + topicId + " failed", e);
        }
    }

    @Override
    public Topic getTopic(String key, SimpleValue value) {
        try {
            TopicModel topic = this.storageDecorator.fetchTopic(key, value);
            return topic != null ? this.instantiateTopic(topic) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    @Override
    public List<Topic> getTopics(String key, SimpleValue value) {
        try {
            return this.instantiateTopics(this.storageDecorator.fetchTopics(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    @Override
    public ResultList<RelatedTopic> getTopics(String topicTypeUri, int maxResultSize) {
        try {
            return this.getTopicType(topicTypeUri).getRelatedTopics("dm4.core.instantiation", "dm4.core.type", "dm4.core.instance", topicTypeUri, maxResultSize);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics by type failed (topicTypeUri=\"" + topicTypeUri + "\")", e);
        }
    }

    @Override
    public List<Topic> searchTopics(String searchTerm, String fieldUri) {
        try {
            return this.instantiateTopics(this.storageDecorator.queryTopics(searchTerm, fieldUri));
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed (searchTerm=\"" + searchTerm + "\", fieldUri=\"" + fieldUri + "\")", e);
        }
    }

    @Override
    public Iterable<Topic> getAllTopics() {
        return new TopicIterable(this);
    }

    @Override
    public Topic createTopic(TopicModel model) {
        return this.createTopic(model, null);
    }

    @Override
    public void updateTopic(TopicModel model) {
        try {
            this.getTopic(model.getId()).update(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic failed (" + model + ")", e);
        }
    }

    @Override
    public void deleteTopic(long topicId) {
        try {
            this.getTopic(topicId).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic " + topicId + " failed", e);
        }
    }

    @Override
    public Association getAssociation(long assocId) {
        try {
            return this.instantiateAssociation(this.storageDecorator.fetchAssociation(assocId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association " + assocId + " failed", e);
        }
    }

    @Override
    public Association getAssociation(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\"";
        try {
            AssociationModel assoc = this.storageDecorator.fetchAssociation(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
            return assoc != null ? this.instantiateAssociation(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    @Override
    public Association getAssociationBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\"";
        this.logger.info(info);
        try {
            AssociationModel assoc = this.storageDecorator.fetchAssociationBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
            return assoc != null ? this.instantiateAssociation(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    @Override
    public ResultList<RelatedAssociation> getAssociations(String assocTypeUri) {
        try {
            return this.getAssociationType(assocTypeUri).getRelatedAssociations("dm4.core.instantiation", "dm4.core.type", "dm4.core.instance", assocTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations by type failed (assocTypeUri=\"" + assocTypeUri + "\")", e);
        }
    }

    @Override
    public List<Association> getAssociations(long topic1Id, long topic2Id) {
        return this.getAssociations(topic1Id, topic2Id, null);
    }

    @Override
    public List<Association> getAssociations(long topic1Id, long topic2Id, String assocTypeUri) {
        this.logger.info("topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", assocTypeUri=\"" + assocTypeUri + "\"");
        try {
            return this.instantiateAssociations(this.storageDecorator.fetchAssociations(assocTypeUri, topic1Id, topic2Id, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations between topics " + topic1Id + " and " + topic2Id + " failed (assocTypeUri=\"" + assocTypeUri + "\")", e);
        }
    }

    @Override
    public Iterable<Association> getAllAssociations() {
        return new AssociationIterable(this);
    }

    @Override
    public long[] getPlayerIds(long assocId) {
        return this.storageDecorator.fetchPlayerIds(assocId);
    }

    @Override
    public Association createAssociation(AssociationModel model) {
        try {
            this.fireEvent(CoreEvent.PRE_CREATE_ASSOCIATION, model);
            Association assoc = this.associationFactory(model);
            this.fireEvent(CoreEvent.POST_CREATE_ASSOCIATION, assoc);
            return assoc;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association failed (" + model + ")", e);
        }
    }

    @Override
    public void updateAssociation(AssociationModel model) {
        try {
            this.getAssociation(model.getId()).update(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association failed (" + model + ")", e);
        }
    }

    @Override
    public void deleteAssociation(long assocId) {
        try {
            this.getAssociation(assocId).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association " + assocId + " failed", e);
        }
    }

    @Override
    public List<String> getTopicTypeUris() {
        try {
            Topic metaType = this.instantiateTopic(this.storageDecorator.fetchTopic("uri", new SimpleValue("dm4.core.topic_type")));
            ResultList<RelatedTopic> topicTypes = metaType.getRelatedTopics("dm4.core.instantiation", "dm4.core.type", "dm4.core.instance", "dm4.core.topic_type", 0);
            ArrayList<String> topicTypeUris = new ArrayList<String>();
            topicTypeUris.add("dm4.core.topic_type");
            topicTypeUris.add("dm4.core.assoc_type");
            topicTypeUris.add("dm4.core.meta_type");
            topicTypeUris.add("dm4.core.meta_meta_type");
            for (RelatedTopic topicType : topicTypes) {
                topicTypeUris.add(topicType.getUri());
            }
            return topicTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of topic type URIs failed", e);
        }
    }

    @Override
    public TopicType getTopicType(String uri) {
        try {
            return this.typeCache.getTopicType(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic type \"" + uri + "\" failed", e);
        }
    }

    @Override
    public List<TopicType> getAllTopicTypes() {
        try {
            ArrayList<TopicType> topicTypes = new ArrayList<TopicType>();
            for (String uri : this.getTopicTypeUris()) {
                TopicType topicType = this.getTopicType(uri);
                topicTypes.add(topicType);
            }
            return topicTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all topic types failed", e);
        }
    }

    @Override
    public TopicType createTopicType(TopicTypeModel model) {
        try {
            TopicType topicType = this.topicTypeFactory(model);
            this.fireEvent(CoreEvent.INTRODUCE_TOPIC_TYPE, topicType);
            return topicType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic type \"" + model.getUri() + "\" failed (" + model + ")", e);
        }
    }

    @Override
    public void updateTopicType(TopicTypeModel model) {
        try {
            String topicTypeUri = this.getTopic(model.getId()).getUri();
            this.getTopicType(topicTypeUri).update(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic type failed (" + model + ")", e);
        }
    }

    @Override
    public void deleteTopicType(String topicTypeUri) {
        try {
            this.getTopicType(topicTypeUri).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    @Override
    public List<String> getAssociationTypeUris() {
        try {
            Topic metaType = this.instantiateTopic(this.storageDecorator.fetchTopic("uri", new SimpleValue("dm4.core.assoc_type")));
            ResultList<RelatedTopic> assocTypes = metaType.getRelatedTopics("dm4.core.instantiation", "dm4.core.type", "dm4.core.instance", "dm4.core.assoc_type", 0);
            ArrayList<String> assocTypeUris = new ArrayList<String>();
            for (RelatedTopic assocType : assocTypes) {
                assocTypeUris.add(assocType.getUri());
            }
            return assocTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of association type URIs failed", e);
        }
    }

    @Override
    public AssociationType getAssociationType(String uri) {
        try {
            return this.typeCache.getAssociationType(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association type \"" + uri + "\" failed", e);
        }
    }

    @Override
    public List<AssociationType> getAllAssociationTypes() {
        try {
            ArrayList<AssociationType> assocTypes = new ArrayList<AssociationType>();
            for (String uri : this.getAssociationTypeUris()) {
                AssociationType assocType = this.getAssociationType(uri);
                assocTypes.add(assocType);
            }
            return assocTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all association types failed", e);
        }
    }

    @Override
    public AssociationType createAssociationType(AssociationTypeModel model) {
        try {
            AssociationType assocType = this.associationTypeFactory(model);
            this.fireEvent(CoreEvent.INTRODUCE_ASSOCIATION_TYPE, assocType);
            return assocType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association type \"" + model.getUri() + "\" failed (" + model + ")", e);
        }
    }

    @Override
    public void updateAssociationType(AssociationTypeModel model) {
        try {
            String assocTypeUri = this.getTopic(model.getId()).getUri();
            this.getAssociationType(assocTypeUri).update(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association type failed (" + model + ")", e);
        }
    }

    @Override
    public void deleteAssociationType(String assocTypeUri) {
        try {
            this.getAssociationType(assocTypeUri).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    @Override
    public Topic createRoleType(TopicModel model) {
        String typeUri = model.getTypeUri();
        if (typeUri == null) {
            model.setTypeUri("dm4.core.role_type");
        } else if (!typeUri.equals("dm4.core.role_type")) {
            throw new IllegalArgumentException("A role type is supposed to be of type \"dm4.core.role_type\" (found: \"" + typeUri + "\")");
        }
        return this.createTopic(model, URI_PREFIX_ROLE_TYPE);
    }

    @Override
    public DeepaMehtaObject getObject(long id) {
        DeepaMehtaObjectModel model = this.storageDecorator.fetchObject(id);
        if (model instanceof TopicModel) {
            return this.instantiateTopic((TopicModel)model);
        }
        if (model instanceof AssociationModel) {
            return this.instantiateAssociation((AssociationModel)model);
        }
        throw new RuntimeException("Unexpected model: " + model);
    }

    @Override
    public Plugin getPlugin(String pluginUri) {
        return this.pluginManager.getPlugin(pluginUri);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        return this.pluginManager.getPluginInfo();
    }

    @Override
    public void fireEvent(DeepaMehtaEvent event, Object ... params) {
        this.eventManager.fireEvent(event, params);
    }

    @Override
    public void deliverEvent(String pluginUri, DeepaMehtaEvent event, Object ... params) {
        this.eventManager.deliverEvent(pluginUri, event, params);
    }

    @Override
    public Object getProperty(long id, String propUri) {
        return this.storageDecorator.fetchProperty(id, propUri);
    }

    @Override
    public boolean hasProperty(long id, String propUri) {
        return this.storageDecorator.hasProperty(id, propUri);
    }

    @Override
    public List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.instantiateTopics(this.storageDecorator.fetchTopicsByProperty(propUri, propValue));
    }

    @Override
    public List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.instantiateTopics(this.storageDecorator.fetchTopicsByPropertyRange(propUri, from, to));
    }

    @Override
    public List<Association> getAssociationsByProperty(String propUri, Object propValue) {
        return this.instantiateAssociations(this.storageDecorator.fetchAssociationsByProperty(propUri, propValue));
    }

    @Override
    public List<Association> getAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.instantiateAssociations(this.storageDecorator.fetchAssociationsByPropertyRange(propUri, from, to));
    }

    @Override
    public DeepaMehtaTransaction beginTx() {
        return this.storageDecorator.beginTx();
    }

    @Override
    public TypeStorage getTypeStorage() {
        return this.typeStorage;
    }

    @Override
    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.storageDecorator.getDatabaseVendorObject();
    }

    void createTopicInstantiation(long topicId, String topicTypeUri) {
        try {
            AssociationModel assoc = new AssociationModel("dm4.core.instantiation", new TopicRoleModel(topicTypeUri, "dm4.core.type"), new TopicRoleModel(topicId, "dm4.core.instance"));
            this.storageDecorator.storeAssociation(assoc);
            this.storageDecorator.storeAssociationValue(assoc.getId(), assoc.getSimpleValue());
            this.createAssociationInstantiation(assoc.getId(), assoc.getTypeUri());
        }
        catch (Exception e) {
            throw new RuntimeException("Associating topic " + topicId + " with topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    void createAssociationInstantiation(long assocId, String assocTypeUri) {
        try {
            AssociationModel assoc = new AssociationModel("dm4.core.instantiation", new TopicRoleModel(assocTypeUri, "dm4.core.type"), new AssociationRoleModel(assocId, "dm4.core.instance"));
            this.storageDecorator.storeAssociation(assoc);
            this.storageDecorator.storeAssociationValue(assoc.getId(), assoc.getSimpleValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Associating association " + assocId + " with association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    Association createAssociation(String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.createAssociation(new AssociationModel(typeUri, roleModel1, roleModel2));
    }

    Topic instantiateTopic(TopicModel model) {
        this.checkAccess(model);
        return new AttachedTopic(model, this);
    }

    private List<Topic> instantiateTopics(List<TopicModel> models) {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (TopicModel model : models) {
            try {
                topics.add(this.instantiateTopic(model));
            }
            catch (AccessControlException e) {}
        }
        return topics;
    }

    RelatedTopic instantiateRelatedTopic(RelatedTopicModel model) {
        this.checkAccess(model);
        return new AttachedRelatedTopic(model, this);
    }

    ResultList<RelatedTopic> instantiateRelatedTopics(ResultList<RelatedTopicModel> models) {
        ArrayList<RelatedTopic> relTopics = new ArrayList<RelatedTopic>();
        for (RelatedTopicModel model : models) {
            try {
                relTopics.add(this.instantiateRelatedTopic(model));
            }
            catch (AccessControlException e) {}
        }
        return new ResultList<RelatedTopic>(models.getTotalCount(), relTopics);
    }

    Association instantiateAssociation(AssociationModel model) {
        this.checkAccess(model);
        return new AttachedAssociation(model, this);
    }

    List<Association> instantiateAssociations(List<AssociationModel> models) {
        ArrayList<Association> assocs = new ArrayList<Association>();
        for (AssociationModel model : models) {
            try {
                assocs.add(this.instantiateAssociation(model));
            }
            catch (AccessControlException e) {}
        }
        return assocs;
    }

    RelatedAssociation instantiateRelatedAssociation(RelatedAssociationModel model) {
        this.checkAccess(model);
        return new AttachedRelatedAssociation(model, this);
    }

    ResultList<RelatedAssociation> instantiateRelatedAssociations(Iterable<RelatedAssociationModel> models) {
        ResultList<RelatedAssociation> relAssocs = new ResultList<RelatedAssociation>();
        for (RelatedAssociationModel model : models) {
            try {
                relAssocs.add(this.instantiateRelatedAssociation(model));
            }
            catch (AccessControlException e) {}
        }
        return relAssocs;
    }

    private Topic createTopic(TopicModel model, String uriPrefix) {
        try {
            this.fireEvent(CoreEvent.PRE_CREATE_TOPIC, model);
            Topic topic = this.topicFactory(model, uriPrefix);
            this.fireEvent(CoreEvent.POST_CREATE_TOPIC, topic);
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic failed (" + model + ")", e);
        }
    }

    private void checkAccess(TopicModel model) {
        this.fireEvent(CoreEvent.PRE_GET_TOPIC, model.getId());
    }

    private void checkAccess(AssociationModel model) {
        this.fireEvent(CoreEvent.PRE_GET_ASSOCIATION, model.getId());
    }

    private Topic topicFactory(TopicModel model, String uriPrefix) {
        this.storageDecorator.storeTopic(model);
        this.valueStorage.storeValue(model);
        this.createTopicInstantiation(model.getId(), model.getTypeUri());
        AttachedTopic topic = new AttachedTopic(model, this);
        if (uriPrefix != null && topic.getUri().equals("")) {
            topic.setUri(uriPrefix + topic.getId());
        }
        return topic;
    }

    Association associationFactory(AssociationModel model) {
        this.storageDecorator.storeAssociation(model);
        this.valueStorage.storeValue(model);
        this.createAssociationInstantiation(model.getId(), model.getTypeUri());
        return new AttachedAssociation(model, this);
    }

    private TopicType topicTypeFactory(TopicTypeModel model) {
        this.topicFactory(model, URI_PREFIX_TOPIC_TYPE);
        this.typeStorage.storeType(model);
        AttachedTopicType topicType = new AttachedTopicType(model, this);
        this.typeCache.putTopicType(topicType);
        return topicType;
    }

    private AssociationType associationTypeFactory(AssociationTypeModel model) {
        this.topicFactory(model, URI_PREFIX_ASSOCIATION_TYPE);
        this.typeStorage.storeType(model);
        AttachedAssociationType assocType = new AttachedAssociationType(model, this);
        this.typeCache.putAssociationType(assocType);
        return assocType;
    }

    private void setupDB() {
        DeepaMehtaTransaction tx = this.beginTx();
        try {
            this.logger.info("----- Setting up the database -----");
            boolean isCleanInstall = this.storageDecorator.init();
            if (isCleanInstall) {
                this.setupBootstrapContent();
            }
            this.migrationManager.runCoreMigrations(isCleanInstall);
            tx.success();
            tx.finish();
            this.logger.info("----- Setting up the database complete -----");
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK!");
            tx.finish();
            this.storageDecorator.shutdown();
            throw new RuntimeException("Setting up the database failed", e);
        }
    }

    private void setupBootstrapContent() {
        try {
            TopicModel t = new TopicModel("dm4.core.topic_type", "dm4.core.meta_type", new SimpleValue("Topic Type"));
            TopicModel a = new TopicModel("dm4.core.assoc_type", "dm4.core.meta_type", new SimpleValue("Association Type"));
            this._createTopic(t);
            this._createTopic(a);
            TopicTypeModel dataType = new TopicTypeModel("dm4.core.data_type", "Data Type", "dm4.core.text");
            TopicTypeModel roleType = new TopicTypeModel("dm4.core.role_type", "Role Type", "dm4.core.text");
            this._createTopic(dataType);
            this._createTopic(roleType);
            TopicModel text = new TopicModel("dm4.core.text", "dm4.core.data_type", new SimpleValue("Text"));
            this._createTopic(text);
            TopicModel deflt = new TopicModel("dm4.core.default", "dm4.core.role_type", new SimpleValue("Default"));
            TopicModel type = new TopicModel("dm4.core.type", "dm4.core.role_type", new SimpleValue("Type"));
            TopicModel inst = new TopicModel("dm4.core.instance", "dm4.core.role_type", new SimpleValue("Instance"));
            this._createTopic(deflt);
            this._createTopic(type);
            this._createTopic(inst);
            AssociationTypeModel aggregation = new AssociationTypeModel("dm4.core.aggregation", "Aggregation", "dm4.core.text");
            this._createTopic(aggregation);
            AssociationTypeModel instn = new AssociationTypeModel("dm4.core.instantiation", "Instantiation", "dm4.core.text");
            this._createTopic(instn);
            this.createTopicInstantiation(t.getId(), t.getTypeUri());
            this.createTopicInstantiation(a.getId(), a.getTypeUri());
            this.createTopicInstantiation(dataType.getId(), dataType.getTypeUri());
            this.createTopicInstantiation(roleType.getId(), roleType.getTypeUri());
            this.createTopicInstantiation(text.getId(), text.getTypeUri());
            this.createTopicInstantiation(deflt.getId(), deflt.getTypeUri());
            this.createTopicInstantiation(type.getId(), type.getTypeUri());
            this.createTopicInstantiation(inst.getId(), inst.getTypeUri());
            this.createTopicInstantiation(aggregation.getId(), aggregation.getTypeUri());
            this.createTopicInstantiation(instn.getId(), instn.getTypeUri());
            this._associateDataType("dm4.core.meta_type", "dm4.core.text");
            this._associateDataType("dm4.core.topic_type", "dm4.core.text");
            this._associateDataType("dm4.core.assoc_type", "dm4.core.text");
            this._associateDataType("dm4.core.data_type", "dm4.core.text");
            this._associateDataType("dm4.core.role_type", "dm4.core.text");
            this._associateDataType("dm4.core.aggregation", "dm4.core.text");
            this._associateDataType("dm4.core.instantiation", "dm4.core.text");
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the bootstrap content failed", e);
        }
    }

    private void _createTopic(TopicModel model) {
        this.storageDecorator.storeTopic(model);
        this.storageDecorator.storeTopicValue(model.getId(), model.getSimpleValue());
    }

    private void _associateDataType(String typeUri, String dataTypeUri) {
        AssociationModel assoc = new AssociationModel("dm4.core.aggregation", new TopicRoleModel(typeUri, "dm4.core.type"), new TopicRoleModel(dataTypeUri, "dm4.core.default"));
        this.storageDecorator.storeAssociation(assoc);
        this.storageDecorator.storeAssociationValue(assoc.getId(), assoc.getSimpleValue());
    }

    private void bootstrapTypeCache() {
        this.typeCache.putTopicType(new AttachedTopicType(new TopicTypeModel("dm4.core.meta_meta_type", "dm4.core.meta_meta_meta_type", "Meta Meta Type", "dm4.core.text"), this));
    }
}

