/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AttachedDeepaMehtaObject;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.ResultList;
import java.util.List;
import java.util.logging.Logger;

class AttachedTopic
extends AttachedDeepaMehtaObject
implements Topic {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedTopic(TopicModel model, EmbeddedService dms) {
        super(model, dms);
    }

    @Override
    public void update(TopicModel model) {
        this.loadChildTopics();
        this._update(model);
        this.dms.fireEvent(CoreEvent.POST_UPDATE_TOPIC_REQUEST, this);
    }

    @Override
    public void delete() {
        try {
            this.dms.fireEvent(CoreEvent.PRE_DELETE_TOPIC, this);
            super.delete();
            this.logger.info("Deleting " + this);
            Directives.get().add(Directive.DELETE_TOPIC, this);
            this.dms.storageDecorator.deleteTopic(this.getId());
            this.dms.fireEvent(CoreEvent.POST_DELETE_TOPIC, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic failed (" + this + ")", e);
        }
    }

    @Override
    public Topic loadChildTopics() {
        return (Topic)super.loadChildTopics();
    }

    @Override
    public Topic loadChildTopics(String childTypeUri) {
        return (Topic)super.loadChildTopics(childTypeUri);
    }

    @Override
    public TopicModel getModel() {
        return (TopicModel)super.getModel();
    }

    @Override
    public ResultList<RelatedTopic> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        ResultList<RelatedTopicModel> topics = this.dms.storageDecorator.fetchTopicRelatedTopics(this.getId(), assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
        return this.dms.instantiateRelatedTopics(topics);
    }

    @Override
    public RelatedAssociation getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssociationModel assoc = this.dms.storageDecorator.fetchTopicRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? this.dms.instantiateRelatedAssociation(assoc) : null;
    }

    @Override
    public ResultList<RelatedAssociation> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        ResultList<RelatedAssociationModel> assocs = this.dms.storageDecorator.fetchTopicRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return this.dms.instantiateRelatedAssociations(assocs);
    }

    @Override
    public Association getAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        AssociationModel assoc = this.dms.storageDecorator.fetchAssociation(assocTypeUri, this.getId(), othersTopicId, myRoleTypeUri, othersRoleTypeUri);
        return assoc != null ? this.dms.instantiateAssociation(assoc) : null;
    }

    @Override
    public List<Association> getAssociations() {
        return this.dms.instantiateAssociations(this.dms.storageDecorator.fetchTopicAssociations(this.getId()));
    }

    @Override
    public void setProperty(String propUri, Object propValue, boolean addToIndex) {
        this.dms.storageDecorator.storeTopicProperty(this.getId(), propUri, propValue, addToIndex);
    }

    @Override
    public void removeProperty(String propUri) {
        this.dms.storageDecorator.removeTopicProperty(this.getId(), propUri);
    }

    TopicType getTopicType() {
        return (TopicType)this.getType();
    }

    void _update(TopicModel model) {
        this.logger.info("Updating topic " + this.getId() + " (new " + model + ")");
        this.dms.fireEvent(CoreEvent.PRE_UPDATE_TOPIC, this, model);
        TopicModel oldModel = this.getModel().clone();
        super.update(model);
        this.dms.fireEvent(CoreEvent.POST_UPDATE_TOPIC, this, model, oldModel);
    }

    @Override
    String className() {
        return "topic";
    }

    @Override
    Directive getUpdateDirective() {
        return Directive.UPDATE_TOPIC;
    }

    @Override
    final void storeUri() {
        this.dms.storageDecorator.storeTopicUri(this.getId(), this.getUri());
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.dms.storageDecorator.storeTopicTypeUri(this.getId(), this.getTypeUri());
    }

    @Override
    final RelatedTopicModel fetchRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.dms.storageDecorator.fetchTopicRelatedTopic(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final ResultList<RelatedTopicModel> fetchRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        return this.dms.storageDecorator.fetchTopicRelatedTopics(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.dms.createTopicInstantiation(this.getId(), this.getTypeUri());
    }

    private Association fetchInstantiation() {
        RelatedTopic topicType = this.getRelatedTopic("dm4.core.instantiation", "dm4.core.instance", "dm4.core.type", "dm4.core.topic_type");
        if (topicType == null) {
            throw new RuntimeException("Topic " + this.getId() + " is not associated to a topic type");
        }
        return topicType.getRelatingAssociation();
    }
}

