/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Role;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicRole;
import de.deepamehta.core.impl.AttachedAssociationRole;
import de.deepamehta.core.impl.AttachedDeepaMehtaObject;
import de.deepamehta.core.impl.AttachedTopicRole;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.ResultList;
import java.util.List;
import java.util.logging.Logger;

class AttachedAssociation
extends AttachedDeepaMehtaObject
implements Association {
    private Role role1;
    private Role role2;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedAssociation(AssociationModel model, EmbeddedService dms) {
        super(model, dms);
        this.role1 = this.createAttachedRole(model.getRoleModel1());
        this.role2 = this.createAttachedRole(model.getRoleModel2());
    }

    @Override
    public void update(AssociationModel model) {
        this.loadChildTopics();
        this.logger.info("Updating association " + this.getId() + " (new " + model + ")");
        this.dms.fireEvent(CoreEvent.PRE_UPDATE_ASSOCIATION, this, model);
        AssociationModel oldModel = this.getModel().clone();
        super.update(model);
        this.updateRole(model.getRoleModel1(), 1);
        this.updateRole(model.getRoleModel2(), 2);
        this.dms.fireEvent(CoreEvent.POST_UPDATE_ASSOCIATION, this, oldModel);
    }

    @Override
    public void delete() {
        try {
            this.dms.fireEvent(CoreEvent.PRE_DELETE_ASSOCIATION, this);
            super.delete();
            this.logger.info("Deleting " + this);
            Directives.get().add(Directive.DELETE_ASSOCIATION, this);
            this.dms.storageDecorator.deleteAssociation(this.getId());
            this.dms.fireEvent(CoreEvent.POST_DELETE_ASSOCIATION, this);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Node[" + this.getId() + "] has been deleted in this tx")) {
                this.logger.info("### Association " + this.getId() + " has already been deleted in this transaction. This can " + "happen while deleting a topic with associations A1 and A2 while A2 points to A1 (" + this + ")");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association failed (" + this + ")", e);
        }
    }

    @Override
    public Role getRole1() {
        return this.role1;
    }

    @Override
    public Role getRole2() {
        return this.role2;
    }

    @Override
    public DeepaMehtaObject getPlayer1() {
        return this.getRole1().getPlayer();
    }

    @Override
    public DeepaMehtaObject getPlayer2() {
        return this.getRole2().getPlayer();
    }

    @Override
    public Topic getTopic(String roleTypeUri) {
        Topic topic1 = this.filterTopic(this.getRole1(), roleTypeUri);
        Topic topic2 = this.filterTopic(this.getRole2(), roleTypeUri);
        if (topic1 != null && topic2 != null) {
            throw new RuntimeException("Ambiguity in association: both topics have role type \"" + roleTypeUri + "\" (" + this + ")");
        }
        return topic1 != null ? topic1 : (topic2 != null ? topic2 : null);
    }

    @Override
    public Topic getTopicByType(String topicTypeUri) {
        Topic topic1 = this.filterTopic(this.getPlayer1(), topicTypeUri);
        Topic topic2 = this.filterTopic(this.getPlayer2(), topicTypeUri);
        if (topic1 != null && topic2 != null) {
            throw new RuntimeException("Ambiguity in association: both topics are of type \"" + topicTypeUri + "\" (" + this + ")");
        }
        return topic1 != null ? topic1 : (topic2 != null ? topic2 : null);
    }

    @Override
    public Role getRole(RoleModel roleModel) {
        if (this.getRole1().getModel().refsSameObject(roleModel)) {
            return this.getRole1();
        }
        if (this.getRole2().getModel().refsSameObject(roleModel)) {
            return this.getRole2();
        }
        throw new RuntimeException("Role is not part of association (role=" + roleModel + ", association=" + this);
    }

    @Override
    public boolean isPlayer(TopicRoleModel roleModel) {
        return this.filterRole(this.getRole1(), roleModel) != null || this.filterRole(this.getRole2(), roleModel) != null;
    }

    @Override
    public Association loadChildTopics() {
        return (Association)super.loadChildTopics();
    }

    @Override
    public Association loadChildTopics(String childTypeUri) {
        return (Association)super.loadChildTopics(childTypeUri);
    }

    @Override
    public AssociationModel getModel() {
        return (AssociationModel)super.getModel();
    }

    @Override
    public ResultList<RelatedTopic> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        ResultList<RelatedTopicModel> topics = this.dms.storageDecorator.fetchAssociationRelatedTopics(this.getId(), assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
        return this.dms.instantiateRelatedTopics(topics);
    }

    @Override
    public RelatedAssociation getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssociationModel assoc = this.dms.storageDecorator.fetchAssociationRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? this.dms.instantiateRelatedAssociation(assoc) : null;
    }

    @Override
    public ResultList<RelatedAssociation> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        ResultList<RelatedAssociationModel> assocs = this.dms.storageDecorator.fetchAssociationRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return this.dms.instantiateRelatedAssociations(assocs);
    }

    @Override
    public Association getAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        AssociationModel assoc = this.dms.storageDecorator.fetchAssociationBetweenTopicAndAssociation(assocTypeUri, othersTopicId, this.getId(), othersRoleTypeUri, myRoleTypeUri);
        return assoc != null ? this.dms.instantiateAssociation(assoc) : null;
    }

    @Override
    public List<Association> getAssociations() {
        return this.dms.instantiateAssociations(this.dms.storageDecorator.fetchAssociationAssociations(this.getId()));
    }

    @Override
    public void setProperty(String propUri, Object propValue, boolean addToIndex) {
        this.dms.storageDecorator.storeAssociationProperty(this.getId(), propUri, propValue, addToIndex);
    }

    @Override
    public void removeProperty(String propUri) {
        this.dms.storageDecorator.removeAssociationProperty(this.getId(), propUri);
    }

    AssociationType getAssociationType() {
        return (AssociationType)this.getType();
    }

    @Override
    final String className() {
        return "association";
    }

    @Override
    Directive getUpdateDirective() {
        return Directive.UPDATE_ASSOCIATION;
    }

    @Override
    final void storeUri() {
        this.dms.storageDecorator.storeAssociationUri(this.getId(), this.getUri());
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.dms.storageDecorator.storeAssociationTypeUri(this.getId(), this.getTypeUri());
    }

    @Override
    final RelatedTopicModel fetchRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.dms.storageDecorator.fetchAssociationRelatedTopic(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final ResultList<RelatedTopicModel> fetchRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        return this.dms.storageDecorator.fetchAssociationRelatedTopics(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
    }

    private void updateRole(RoleModel newModel, int nr) {
        if (newModel != null) {
            Role role = this.getRole(newModel);
            String newRoleTypeUri = newModel.getRoleTypeUri();
            String roleTypeUri = role.getRoleTypeUri();
            if (!roleTypeUri.equals(newRoleTypeUri)) {
                this.logger.info("### Changing role type " + nr + " from \"" + roleTypeUri + "\" -> \"" + newRoleTypeUri + "\"");
                role.setRoleTypeUri(newRoleTypeUri);
            }
        }
    }

    private Role createAttachedRole(RoleModel model) {
        if (model instanceof TopicRoleModel) {
            return new AttachedTopicRole((TopicRoleModel)model, (Association)this, this.dms);
        }
        if (model instanceof AssociationRoleModel) {
            return new AttachedAssociationRole((AssociationRoleModel)model, (Association)this, this.dms);
        }
        throw new RuntimeException("Unexpected RoleModel object (" + model + ")");
    }

    private Topic filterTopic(Role role, String roleTypeUri) {
        return role instanceof TopicRole && role.getRoleTypeUri().equals(roleTypeUri) ? ((TopicRole)role).getTopic() : null;
    }

    private Topic filterTopic(DeepaMehtaObject object, String topicTypeUri) {
        return object instanceof Topic && object.getTypeUri().equals(topicTypeUri) ? (Topic)object : null;
    }

    private TopicRole filterRole(Role role, TopicRoleModel roleModel) {
        return role instanceof TopicRole && role.getRoleTypeUri().equals(roleModel.getRoleTypeUri()) && role.getPlayerId() == roleModel.getPlayerId() ? (TopicRole)role : null;
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.dms.createAssociationInstantiation(this.getId(), this.getTypeUri());
    }

    private Association fetchInstantiation() {
        RelatedTopic assocType = this.getRelatedTopic("dm4.core.instantiation", "dm4.core.instance", "dm4.core.type", "dm4.core.assoc_type");
        if (assocType == null) {
            throw new RuntimeException("Association " + this.getId() + " is not associated to an association type");
        }
        return assocType.getRelatingAssociation();
    }
}

