/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.impl.JerseyRequestFilter;
import de.deepamehta.core.impl.JerseyResponseFilter;
import de.deepamehta.core.impl.RestResources;
import de.deepamehta.core.impl.StaticResources;
import de.deepamehta.core.impl.TransactionFactory;
import de.deepamehta.core.service.SecurityHandler;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WebPublishingService {
    private static final String ROOT_APPLICATION_PATH = "/*";
    private ResourceConfig jerseyApplication;
    private int classCount = 0;
    private int singletonCount = 0;
    private ServletContainer jerseyServlet;
    private boolean isJerseyServletRegistered = false;
    private HttpService httpService;
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public WebPublishingService(EmbeddedService dms, HttpService httpService) {
        try {
            this.logger.info("Setting up the Web Publishing service");
            this.dms = dms;
            this.jerseyApplication = new DefaultResourceConfig();
            Map properties = this.jerseyApplication.getProperties();
            properties.put("com.sun.jersey.spi.container.ContainerRequestFilters", new JerseyRequestFilter(dms));
            properties.put("com.sun.jersey.spi.container.ContainerResponseFilters", new JerseyResponseFilter(dms));
            properties.put("com.sun.jersey.spi.container.ResourceFilters", new TransactionFactory(dms));
            this.jerseyServlet = new ServletContainer((Application)this.jerseyApplication);
            this.httpService = httpService;
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the Web Publishing service failed", e);
        }
    }

    StaticResources publishStaticResources(Bundle bundle, String uriNamespace) {
        try {
            this.httpService.registerResources(uriNamespace, "/web", (HttpContext)new BundleHTTPContext(bundle));
            return new StaticResources(uriNamespace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void unpublishStaticResources(StaticResources staticResources) {
        this.httpService.unregister(staticResources.uriNamespace);
    }

    StaticResources publishStaticResources(String directoryPath, String uriNamespace, SecurityHandler securityHandler) {
        try {
            this.httpService.registerResources(uriNamespace, "/", (HttpContext)new DirectoryHTTPContext(directoryPath, securityHandler));
            return new StaticResources(uriNamespace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    synchronized RestResources publishRestResources(List<Object> singletons, List<Class<?>> classes) {
        RestResources restResources = new RestResources(singletons, classes);
        try {
            this.addToApplication(restResources);
            if (!this.isJerseyServletRegistered) {
                if (this.hasRootResources()) {
                    this.registerJerseyServlet();
                }
            } else {
                this.reloadJerseyServlet();
            }
            return restResources;
        }
        catch (Exception e) {
            this.unpublishRestResources(restResources);
            throw new RuntimeException("Adding classes/singletons to Jersey application failed", e);
        }
    }

    synchronized void unpublishRestResources(RestResources restResources) {
        this.removeFromApplication(restResources);
        if (!this.hasRootResources()) {
            this.unregisterJerseyServlet();
        } else {
            this.reloadJerseyServlet();
        }
    }

    boolean isRootResource(Object object) {
        return this.getUriNamespace(object) != null;
    }

    String getUriNamespace(Object object) {
        Path path = object.getClass().getAnnotation(Path.class);
        return path != null ? path.value() : null;
    }

    private void addToApplication(RestResources restResources) {
        this.getClasses().addAll(restResources.classes);
        this.getSingletons().addAll(restResources.singletons);
        this.classCount += restResources.classes.size();
        this.singletonCount += restResources.singletons.size();
        this.logResourceInfo();
    }

    private void removeFromApplication(RestResources restResources) {
        this.getClasses().removeAll(restResources.classes);
        this.getSingletons().removeAll(restResources.singletons);
        this.classCount -= restResources.classes.size();
        this.singletonCount -= restResources.singletons.size();
        this.logResourceInfo();
    }

    private boolean hasRootResources() {
        return this.singletonCount > 0;
    }

    private void logResourceInfo() {
        this.logger.fine("##### DM Classes: " + this.classCount + ", All: " + this.getClasses().size() + " " + this.getClasses());
        this.logger.fine("##### DM Singletons: " + this.singletonCount + ", All: " + this.getSingletons().size() + " " + this.getSingletons());
    }

    private Set<Class<?>> getClasses() {
        return this.jerseyApplication.getClasses();
    }

    private Set<Object> getSingletons() {
        return this.jerseyApplication.getSingletons();
    }

    private void registerJerseyServlet() {
        try {
            this.logger.fine("########## Registering Jersey servlet at HTTP service (URI namespace=\"/*\")");
            this.httpService.registerServlet(ROOT_APPLICATION_PATH, (Servlet)this.jerseyServlet, null, null);
            this.isJerseyServletRegistered = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Registering Jersey servlet at HTTP service failed", e);
        }
    }

    private void unregisterJerseyServlet() {
        this.logger.fine("########## Unregistering Jersey servlet at HTTP service (URI namespace=\"/*\")");
        this.httpService.unregister(ROOT_APPLICATION_PATH);
        this.isJerseyServletRegistered = false;
    }

    private void reloadJerseyServlet() {
        this.logger.fine("##### Reloading Jersey servlet");
        this.jerseyServlet.reload();
    }

    private boolean resourceRequestFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.dms.fireEvent(CoreEvent.RESOURCE_REQUEST_FILTER, request);
            return true;
        }
        catch (WebApplicationException e) {
            this.sendError(response, e.getResponse());
            return false;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Resource request filtering failed for " + request.getRequestURI(), e);
            response.setStatus(500);
            return false;
        }
    }

    private void sendError(HttpServletResponse servletResponse, Response response) throws IOException {
        MultivaluedMap metadata = response.getMetadata();
        for (String header : metadata.keySet()) {
            for (Object value : (List)metadata.get((Object)header)) {
                servletResponse.addHeader(header, (String)value);
            }
        }
        servletResponse.sendError(response.getStatus(), (String)response.getEntity());
    }

    private class DirectoryHTTPContext
    implements HttpContext {
        private String directoryPath;
        private SecurityHandler securityHandler;

        private DirectoryHTTPContext(String directoryPath, SecurityHandler securityHandler) {
            this.directoryPath = directoryPath;
            this.securityHandler = securityHandler;
        }

        public URL getResource(String name) {
            try {
                URL url = new URL("file:" + this.directoryPath + "/" + name);
                WebPublishingService.this.logger.info("### Mapping resource name \"" + name + "\" to URL \"" + url + "\"");
                return url;
            }
            catch (Exception e) {
                throw new RuntimeException("Mapping resource name \"" + name + "\" to URL failed", e);
            }
        }

        public String getMimeType(String name) {
            return null;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            boolean doService = WebPublishingService.this.resourceRequestFilter(request, response);
            if (doService) {
                if (this.securityHandler != null) {
                    return this.securityHandler.handleSecurity(request, response);
                }
                return true;
            }
            return false;
        }
    }

    private class BundleHTTPContext
    implements HttpContext {
        private Bundle bundle;

        private BundleHTTPContext(Bundle bundle) {
            this.bundle = bundle;
        }

        public URL getResource(String name) {
            if (name.equals("/web") || name.equals("/web/")) {
                name = "/web/index.html";
            }
            return this.bundle.getResource(name);
        }

        public String getMimeType(String name) {
            return null;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return WebPublishingService.this.resourceRequestFilter(request, response);
        }
    }
}

