/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.Topic;
import de.deepamehta.core.Type;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.util.JavaUtils;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

class ValueStorage {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueStorage(EmbeddedService dms) {
        this.dms = dms;
    }

    void fetchChildTopics(DeepaMehtaObjectModel parent) {
        try {
            Type type = this.getType(parent);
            if (!type.getDataTypeUri().equals("dm4.core.composite")) {
                return;
            }
            for (AssociationDefinition assocDef : type.getAssocDefs()) {
                this.fetchChildTopics(parent, assocDef);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching the child topics of object " + parent.getId() + " failed (" + parent + ")", e);
        }
    }

    void fetchChildTopics(DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        ChildTopicsModel childTopics = parent.getChildTopicsModel();
        String cardinalityUri = assocDef.getChildCardinalityUri();
        String childTypeUri = assocDef.getChildTypeUri();
        if (cardinalityUri.equals("dm4.core.one")) {
            RelatedTopicModel childTopic = this.fetchChildTopic(parent.getId(), assocDef);
            if (childTopic != null) {
                childTopics.put(childTypeUri, childTopic);
                this.fetchChildTopics(childTopic);
            }
        } else if (cardinalityUri.equals("dm4.core.many")) {
            for (RelatedTopicModel childTopic : this.fetchChildTopics(parent.getId(), assocDef)) {
                childTopics.add(childTypeUri, childTopic);
                this.fetchChildTopics(childTopic);
            }
        } else {
            throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
        }
    }

    void storeValue(DeepaMehtaObjectModel model) {
        if (this.getType(model).getDataTypeUri().equals("dm4.core.composite")) {
            this.storeChildTopics(model);
            this.refreshLabel(model);
        } else {
            this.storeSimpleValue(model);
        }
    }

    void indexSimpleValue(DeepaMehtaObjectModel model, IndexMode indexMode) {
        if (model instanceof TopicModel) {
            this.dms.storageDecorator.indexTopicValue(model.getId(), indexMode, model.getTypeUri(), this.getIndexValue(model));
        } else if (model instanceof AssociationModel) {
            this.dms.storageDecorator.indexAssociationValue(model.getId(), indexMode, model.getTypeUri(), this.getIndexValue(model));
        }
    }

    void refreshLabel(DeepaMehtaObjectModel model) {
        try {
            String label = this.buildLabel(model);
            this.setSimpleValue(model, new SimpleValue(label));
        }
        catch (Exception e) {
            throw new RuntimeException("Refreshing label of object " + model.getId() + " failed (" + model + ")", e);
        }
    }

    void setSimpleValue(DeepaMehtaObjectModel model, SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Tried to set a null SimpleValue (" + this + ")");
        }
        model.setSimpleValue(value);
        this.storeSimpleValue(model);
    }

    Topic associateReferencedChildTopic(DeepaMehtaObjectModel parent, TopicReferenceModel childTopicRef, AssociationDefinition assocDef) {
        if (childTopicRef.isReferenceById()) {
            long childTopicId = childTopicRef.getId();
            this.associateChildTopic(parent, childTopicId, assocDef);
            return this.dms.getTopic(childTopicId);
        }
        if (childTopicRef.isReferenceByUri()) {
            String childTopicUri = childTopicRef.getUri();
            this.associateChildTopic(parent, childTopicUri, assocDef);
            return this.dms.getTopic("uri", new SimpleValue(childTopicUri));
        }
        throw new RuntimeException("Invalid topic reference (" + childTopicRef + ")");
    }

    void associateChildTopic(DeepaMehtaObjectModel parent, long childTopicId, AssociationDefinition assocDef) {
        this.associateChildTopic(parent, new TopicRoleModel(childTopicId, "dm4.core.child"), assocDef);
    }

    void associateChildTopic(DeepaMehtaObjectModel parent, String childTopicUri, AssociationDefinition assocDef) {
        this.associateChildTopic(parent, new TopicRoleModel(childTopicUri, "dm4.core.child"), assocDef);
    }

    Type getType(DeepaMehtaObjectModel model) {
        if (model instanceof TopicModel) {
            return this.dms.getTopicType(model.getTypeUri());
        }
        if (model instanceof AssociationModel) {
            return this.dms.getAssociationType(model.getTypeUri());
        }
        throw new RuntimeException("Unexpected model: " + model);
    }

    private void storeSimpleValue(DeepaMehtaObjectModel model) {
        Type type = this.getType(model);
        if (model instanceof TopicModel) {
            this.dms.storageDecorator.storeTopicValue(model.getId(), model.getSimpleValue(), type.getIndexModes(), type.getUri(), this.getIndexValue(model));
        } else if (model instanceof AssociationModel) {
            this.dms.storageDecorator.storeAssociationValue(model.getId(), model.getSimpleValue(), type.getIndexModes(), type.getUri(), this.getIndexValue(model));
        }
    }

    private void storeChildTopics(DeepaMehtaObjectModel parent) {
        ChildTopicsModel model = null;
        try {
            model = parent.getChildTopicsModel();
            for (AssociationDefinition assocDef : this.getType(parent).getAssocDefs()) {
                String childTypeUri = assocDef.getChildTypeUri();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                TopicModel childTopic = null;
                List<TopicModel> childTopics = null;
                if (cardinalityUri.equals("dm4.core.one")) {
                    childTopic = model.getTopic(childTypeUri, null);
                    if (childTopic == null) {
                        continue;
                    }
                } else if (cardinalityUri.equals("dm4.core.many")) {
                    childTopics = model.getTopics(childTypeUri, null);
                    if (childTopics == null) {
                        continue;
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                this.storeChildTopics(childTopic, childTopics, parent, assocDef);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing the child topics of object " + parent.getId() + " failed (" + model + ")", e);
        }
    }

    private void storeChildTopics(TopicModel childTopic, List<TopicModel> childTopics, DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        boolean one;
        String assocTypeUri = assocDef.getTypeUri();
        boolean bl = one = childTopic != null;
        if (assocTypeUri.equals("dm4.core.composition_def")) {
            if (one) {
                this.storeCompositionOne(childTopic, parent, assocDef);
            } else {
                this.storeCompositionMany(childTopics, parent, assocDef);
            }
        } else if (assocTypeUri.equals("dm4.core.aggregation_def")) {
            if (one) {
                this.storeAggregationOne(childTopic, parent, assocDef);
            } else {
                this.storeAggregationMany(childTopics, parent, assocDef);
            }
        } else {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not supported");
        }
    }

    private void storeCompositionOne(TopicModel model, DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        Topic childTopic = this.dms.createTopic(model);
        this.associateChildTopic(parent, childTopic.getId(), assocDef);
    }

    private void storeCompositionMany(List<TopicModel> models, DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        for (TopicModel model : models) {
            Topic childTopic = this.dms.createTopic(model);
            this.associateChildTopic(parent, childTopic.getId(), assocDef);
        }
    }

    private void storeAggregationOne(TopicModel model, DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        if (model instanceof TopicReferenceModel) {
            Topic childTopic = this.associateReferencedChildTopic(parent, (TopicReferenceModel)model, assocDef);
            this.putInChildTopics(parent, childTopic, assocDef);
        } else {
            Topic childTopic = this.dms.createTopic(model);
            this.associateChildTopic(parent, childTopic.getId(), assocDef);
        }
    }

    private void storeAggregationMany(List<TopicModel> models, DeepaMehtaObjectModel parent, AssociationDefinition assocDef) {
        for (TopicModel model : models) {
            Topic childTopic;
            if (model instanceof TopicReferenceModel) {
                childTopic = this.associateReferencedChildTopic(parent, (TopicReferenceModel)model, assocDef);
                this.replaceReference(model, childTopic);
                continue;
            }
            childTopic = this.dms.createTopic(model);
            this.associateChildTopic(parent, childTopic.getId(), assocDef);
        }
    }

    private void putInChildTopics(DeepaMehtaObjectModel parent, Topic childTopic, AssociationDefinition assocDef) {
        parent.getChildTopicsModel().put(assocDef.getChildTypeUri(), childTopic.getModel());
    }

    private void replaceReference(TopicModel topicRef, Topic topic) {
        topicRef.set(topic.getModel());
    }

    private String buildLabel(DeepaMehtaObjectModel model) {
        Type type = this.getType(model);
        if (type.getDataTypeUri().equals("dm4.core.composite")) {
            List<String> labelConfig = type.getLabelConfig();
            if (labelConfig.size() > 0) {
                return this.buildLabelFromConfig(model, labelConfig);
            }
            return this.buildDefaultLabel(model);
        }
        return model.getSimpleValue().toString();
    }

    private String buildLabelFromConfig(DeepaMehtaObjectModel model, List<String> labelConfig) {
        StringBuilder builder = new StringBuilder();
        for (String childTypeUri : labelConfig) {
            this.appendLabel(this.buildChildLabel(model, childTypeUri), builder, LABEL_CHILD_SEPARATOR);
        }
        return builder.toString();
    }

    private String buildDefaultLabel(DeepaMehtaObjectModel model) {
        Iterator<AssociationDefinition> i = this.getType(model).getAssocDefs().iterator();
        if (!i.hasNext()) {
            return "";
        }
        String childTypeUri = i.next().getChildTypeUri();
        return this.buildChildLabel(model, childTypeUri);
    }

    private String buildChildLabel(DeepaMehtaObjectModel parent, String childTypeUri) {
        Object value = parent.getChildTopicsModel().get(childTypeUri);
        if (value == null) {
            return "";
        }
        if (value instanceof TopicModel) {
            TopicModel childTopic = (TopicModel)value;
            return this.buildLabel(childTopic);
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            for (TopicModel childTopic : (List)value) {
                this.appendLabel(this.buildLabel(childTopic), builder, LABEL_TOPIC_SEPARATOR);
            }
            return builder.toString();
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    private void appendLabel(String label, StringBuilder builder, String separator) {
        if (builder.length() > 0 && label.length() > 0) {
            builder.append(separator);
        }
        builder.append(label);
    }

    private RelatedTopicModel fetchChildTopic(long parentId, AssociationDefinition assocDef) {
        return this.dms.storageDecorator.fetchRelatedTopic(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }

    private ResultList<RelatedTopicModel> fetchChildTopics(long parentId, AssociationDefinition assocDef) {
        return this.dms.storageDecorator.fetchRelatedTopics(parentId, assocDef.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", assocDef.getChildTypeUri());
    }

    private void associateChildTopic(DeepaMehtaObjectModel parent, TopicRoleModel child, AssociationDefinition assocDef) {
        this.dms.createAssociation(assocDef.getInstanceLevelAssocTypeUri(), parent.createRoleModel("dm4.core.parent"), child);
    }

    private SimpleValue getIndexValue(DeepaMehtaObjectModel model) {
        SimpleValue value = model.getSimpleValue();
        if (this.getType(model).getDataTypeUri().equals("dm4.core.html")) {
            return new SimpleValue(JavaUtils.stripHTML(value.toString()));
        }
        return value;
    }
}

