/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationType;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AttachedAssociationType;
import de.deepamehta.core.impl.AttachedTopicType;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.TopicTypeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

class TypeCache {
    private Map<String, TopicType> topicTypes = new HashMap<String, TopicType>();
    private Map<String, AssociationType> assocTypes = new HashMap<String, AssociationType>();
    private EmbeddedService dms;
    private EndlessRecursionProtection endlessRecursionProtection = new EndlessRecursionProtection();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeCache(EmbeddedService dms) {
        this.dms = dms;
    }

    TopicType getTopicType(String topicTypeUri) {
        TopicType topicType = this.topicTypes.get(topicTypeUri);
        if (topicType == null) {
            topicType = this.loadTopicType(topicTypeUri);
            this.putTopicType(topicType);
        }
        return topicType;
    }

    AssociationType getAssociationType(String assocTypeUri) {
        AssociationType assocType = this.assocTypes.get(assocTypeUri);
        if (assocType == null) {
            assocType = this.loadAssociationType(assocTypeUri);
            this.putAssociationType(assocType);
        }
        return assocType;
    }

    void putTopicType(TopicType topicType) {
        this.topicTypes.put(topicType.getUri(), topicType);
    }

    void putAssociationType(AssociationType assocType) {
        this.assocTypes.put(assocType.getUri(), assocType);
    }

    void removeTopicType(String topicTypeUri) {
        this.logger.info("### Removing topic type \"" + topicTypeUri + "\" from type cache");
        if (this.topicTypes.remove(topicTypeUri) == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in type cache");
        }
    }

    void removeAssociationType(String assocTypeUri) {
        this.logger.info("### Removing association type \"" + assocTypeUri + "\" from type cache");
        if (this.assocTypes.remove(assocTypeUri) == null) {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not found in type cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicType loadTopicType(String topicTypeUri) {
        AttachedTopicType topicType = null;
        try {
            this.logger.info("Loading topic type \"" + topicTypeUri + "\"");
            this.endlessRecursionProtection.check(topicTypeUri);
            TopicTypeModel model = this.dms.typeStorage.getTopicType(topicTypeUri);
            AttachedTopicType attachedTopicType = topicType = new AttachedTopicType(model, this.dms);
            return attachedTopicType;
        }
        finally {
            if (topicType == null) {
                this.endlessRecursionProtection.uncheck(topicTypeUri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssociationType loadAssociationType(String assocTypeUri) {
        AttachedAssociationType assocType = null;
        try {
            this.logger.info("Loading association type \"" + assocTypeUri + "\"");
            this.endlessRecursionProtection.check(assocTypeUri);
            AssociationTypeModel model = this.dms.typeStorage.getAssociationType(assocTypeUri);
            AttachedAssociationType attachedAssociationType = assocType = new AttachedAssociationType(model, this.dms);
            return attachedAssociationType;
        }
        finally {
            if (assocType == null) {
                this.endlessRecursionProtection.uncheck(assocTypeUri);
            }
        }
    }

    private class EndlessRecursionProtection {
        private Map<String, Integer> callCount = new HashMap<String, Integer>();

        private EndlessRecursionProtection() {
        }

        private void check(String typeUri) {
            int count = this.incCount(typeUri);
            if (count >= 2) {
                throw new RuntimeException("Endless recursion while loading type \"" + typeUri + "\" (count=" + count + ")");
            }
        }

        private void uncheck(String typeUri) {
            this.decCount(typeUri);
        }

        private int incCount(String typeUri) {
            Integer count = this.callCount.get(typeUri);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.callCount.put(typeUri, count);
            return count;
        }

        private int decCount(String typeUri) {
            Integer count;
            Integer n = count = this.callCount.get(typeUri);
            Integer n2 = count = Integer.valueOf(count - 1);
            this.callCount.put(typeUri, count);
            return count;
        }
    }
}

