/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Type;
import de.deepamehta.core.impl.AttachedChildTopics;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.ResultList;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

abstract class AttachedDeepaMehtaObject
implements DeepaMehtaObject {
    private DeepaMehtaObjectModel model;
    private AttachedChildTopics childTopics;
    protected final EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedDeepaMehtaObject(DeepaMehtaObjectModel model, EmbeddedService dms) {
        this.model = model;
        this.dms = dms;
        this.childTopics = new AttachedChildTopics(model.getChildTopicsModel(), this, dms);
    }

    @Override
    public long getId() {
        return this.model.getId();
    }

    @Override
    public String getUri() {
        return this.model.getUri();
    }

    @Override
    public void setUri(String uri) {
        this.model.setUri(uri);
        this.storeUri();
    }

    @Override
    public String getTypeUri() {
        return this.model.getTypeUri();
    }

    @Override
    public void setTypeUri(String typeUri) {
        this.model.setTypeUri(typeUri);
        this.storeTypeUri();
    }

    @Override
    public SimpleValue getSimpleValue() {
        return this.model.getSimpleValue();
    }

    @Override
    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(SimpleValue value) {
        this.dms.valueStorage.setSimpleValue(this.getModel(), value);
    }

    @Override
    public AttachedChildTopics getChildTopics() {
        return this.childTopics;
    }

    @Override
    public void setChildTopics(ChildTopicsModel childTopics) {
        try {
            this.getChildTopics().update(childTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the child topics failed (" + childTopics + ")", e);
        }
    }

    @Override
    public DeepaMehtaObject loadChildTopics() {
        this.getChildTopics().loadChildTopics();
        return this;
    }

    @Override
    public DeepaMehtaObject loadChildTopics(String childTypeUri) {
        this.getChildTopics().loadChildTopics(childTypeUri);
        return this;
    }

    @Override
    public DeepaMehtaObjectModel getModel() {
        return this.model;
    }

    @Override
    public void update(DeepaMehtaObjectModel newModel) {
        this.updateUri(newModel.getUri());
        this.updateTypeUri(newModel.getTypeUri());
        this.updateValue(newModel);
        Directives.get().add(this.getUpdateDirective(), this);
    }

    @Override
    public void updateChildTopic(TopicModel newChildTopic, AssociationDefinition assocDef) {
        this.getChildTopics().updateChildTopics(newChildTopic, null, assocDef);
    }

    @Override
    public void updateChildTopics(List<TopicModel> newChildTopics, AssociationDefinition assocDef) {
        this.getChildTopics().updateChildTopics(null, newChildTopics, assocDef);
    }

    @Override
    public void delete() {
        ResultList<RelatedTopic> childTopics = this.getRelatedTopics("dm4.core.composition", "dm4.core.parent", "dm4.core.child", null, 0);
        for (RelatedTopic childTopic : childTopics) {
            childTopic.delete();
        }
        for (Association assoc : this.getAssociations()) {
            assoc.delete();
        }
    }

    @Override
    public RelatedTopic getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModel topic = this.fetchRelatedTopic(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? this.dms.instantiateRelatedTopic(topic) : null;
    }

    @Override
    public ResultList<RelatedTopic> getRelatedTopics(String assocTypeUri, int maxResultSize) {
        return this.getRelatedTopics(assocTypeUri, null, null, null, maxResultSize);
    }

    @Override
    public ResultList<RelatedTopic> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        ResultList<RelatedTopicModel> topics = this.fetchRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
        return this.dms.instantiateRelatedTopics(topics);
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.dms.storageDecorator.getDatabaseVendorObject(this.getId());
    }

    @Override
    public JSONObject toJSON() {
        return this.model.toJSON();
    }

    public boolean equals(Object o) {
        return ((AttachedDeepaMehtaObject)o).model.equals(this.model);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public String toString() {
        return this.model.toString();
    }

    abstract String className();

    abstract Directive getUpdateDirective();

    abstract void storeUri();

    abstract void storeTypeUri();

    abstract RelatedTopicModel fetchRelatedTopic(String var1, String var2, String var3, String var4);

    abstract ResultList<RelatedTopicModel> fetchRelatedTopics(String var1, String var2, String var3, String var4, int var5);

    Type getType() {
        return this.dms.valueStorage.getType(this.getModel());
    }

    private void updateUri(String newUri) {
        if (newUri == null) {
            return;
        }
        String uri = this.getUri();
        if (!uri.equals(newUri)) {
            this.logger.info("### Changing URI of " + this.className() + " " + this.getId() + " from \"" + uri + "\" -> \"" + newUri + "\"");
            this.setUri(newUri);
        }
    }

    private void updateTypeUri(String newTypeUri) {
        if (newTypeUri == null) {
            return;
        }
        String typeUri = this.getTypeUri();
        if (!typeUri.equals(newTypeUri)) {
            this.logger.info("### Changing type URI of " + this.className() + " " + this.getId() + " from \"" + typeUri + "\" -> \"" + newTypeUri + "\"");
            this.setTypeUri(newTypeUri);
        }
    }

    private void updateValue(DeepaMehtaObjectModel newModel) {
        if (this.getType().getDataTypeUri().equals("dm4.core.composite")) {
            this.getChildTopics().update(newModel.getChildTopicsModel());
        } else {
            this.updateSimpleValue(newModel.getSimpleValue());
        }
    }

    private void updateSimpleValue(SimpleValue newValue) {
        if (newValue == null) {
            return;
        }
        SimpleValue value = this.getSimpleValue();
        if (!value.equals(newValue)) {
            this.logger.info("### Changing simple value of " + this.className() + " " + this.getId() + " from \"" + value + "\" -> \"" + newValue + "\"");
            this.setSimpleValue(newValue);
        }
    }
}

