/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.impl.AttachedDeepaMehtaObject;
import de.deepamehta.core.impl.AttachedRelatedTopic;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class AttachedChildTopics
implements ChildTopics {
    private ChildTopicsModel model;
    private AttachedDeepaMehtaObject parent;
    private Map<String, Object> childTopics = new HashMap<String, Object>();
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedChildTopics(ChildTopicsModel model, AttachedDeepaMehtaObject parent, EmbeddedService dms) {
        this.model = model;
        this.parent = parent;
        this.dms = dms;
        this.initAttachedObjectCache();
    }

    @Override
    public Topic getTopic(String childTypeUri) {
        this.loadChildTopics(childTypeUri);
        return this._getTopic(childTypeUri);
    }

    @Override
    public List<Topic> getTopics(String childTypeUri) {
        this.loadChildTopics(childTypeUri);
        return this._getTopics(childTypeUri);
    }

    @Override
    public Object get(String childTypeUri) {
        return this.childTopics.get(childTypeUri);
    }

    @Override
    public boolean has(String childTypeUri) {
        return this.childTopics.containsKey(childTypeUri);
    }

    @Override
    public Iterable<String> childTypeUris() {
        return this.childTopics.keySet();
    }

    @Override
    public int size() {
        return this.childTopics.size();
    }

    @Override
    public ChildTopicsModel getModel() {
        return this.model;
    }

    @Override
    public String getString(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().toString();
    }

    @Override
    public int getInt(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().intValue();
    }

    @Override
    public long getLong(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().longValue();
    }

    @Override
    public double getDouble(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().doubleValue();
    }

    @Override
    public boolean getBoolean(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().booleanValue();
    }

    @Override
    public Object getObject(String childTypeUri) {
        return this.getTopic(childTypeUri).getSimpleValue().value();
    }

    @Override
    public ChildTopics getChildTopics(String childTypeUri) {
        return this.getTopic(childTypeUri).getChildTopics();
    }

    @Override
    public ChildTopics set(String childTypeUri, TopicModel value) {
        return this._update(childTypeUri, value);
    }

    @Override
    public ChildTopics set(String childTypeUri, Object value) {
        return this._update(childTypeUri, new TopicModel(childTypeUri, new SimpleValue(value)));
    }

    @Override
    public ChildTopics set(String childTypeUri, ChildTopicsModel value) {
        return this._update(childTypeUri, new TopicModel(childTypeUri, value));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, long refTopicId) {
        return this._update(childTypeUri, new TopicReferenceModel(refTopicId));
    }

    @Override
    public ChildTopics setRef(String childTypeUri, String refTopicUri) {
        return this._update(childTypeUri, new TopicReferenceModel(refTopicUri));
    }

    @Override
    public ChildTopics remove(String childTypeUri, long topicId) {
        return this._update(childTypeUri, new TopicDeletionModel(topicId));
    }

    void update(ChildTopicsModel newComp) {
        try {
            for (AssociationDefinition assocDef : this.parent.getType().getAssocDefs()) {
                String childTypeUri = assocDef.getChildTypeUri();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                TopicModel newChildTopic = null;
                List<TopicModel> newChildTopics = null;
                if (cardinalityUri.equals("dm4.core.one")) {
                    newChildTopic = newComp.getTopic(childTypeUri, null);
                    if (newChildTopic == null) {
                        continue;
                    }
                } else if (cardinalityUri.equals("dm4.core.many")) {
                    newChildTopics = newComp.getTopics(childTypeUri, null);
                    if (newChildTopics == null) {
                        continue;
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                this.updateChildTopics(newChildTopic, newChildTopics, assocDef);
            }
            this.dms.valueStorage.refreshLabel(this.parent.getModel());
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the child topics of " + this.parent.className() + " " + this.parent.getId() + " failed (newComp=" + newComp + ")", e);
        }
    }

    void updateChildTopics(TopicModel newChildTopic, List<TopicModel> newChildTopics, AssociationDefinition assocDef) {
        boolean one;
        this.loadChildTopics(assocDef);
        String assocTypeUri = assocDef.getTypeUri();
        boolean bl = one = newChildTopic != null;
        if (assocTypeUri.equals("dm4.core.composition_def")) {
            if (one) {
                this.updateCompositionOne(newChildTopic, assocDef);
            } else {
                this.updateCompositionMany(newChildTopics, assocDef);
            }
        } else if (assocTypeUri.equals("dm4.core.aggregation_def")) {
            if (one) {
                this.updateAggregationOne(newChildTopic, assocDef);
            } else {
                this.updateAggregationMany(newChildTopics, assocDef);
            }
        } else {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not supported");
        }
    }

    void loadChildTopics() {
        this.dms.valueStorage.fetchChildTopics(this.parent.getModel());
        this.initAttachedObjectCache();
    }

    void loadChildTopics(String childTypeUri) {
        this.loadChildTopics(this.getAssocDef(childTypeUri));
    }

    private void loadChildTopics(AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        if (!this.has(childTypeUri)) {
            this.logger.fine("### Lazy-loading \"" + childTypeUri + "\" child topic(s) of " + this.parent.className() + " " + this.parent.getId());
            this.dms.valueStorage.fetchChildTopics(this.parent.getModel(), assocDef);
            this.initAttachedObjectCache(childTypeUri);
        }
    }

    private Topic _getTopic(String childTypeUri) {
        Topic topic = (Topic)this.childTopics.get(childTypeUri);
        if (topic == null) {
            throw new RuntimeException("Child topic of type \"" + childTypeUri + "\" not found in " + this.childTopics);
        }
        return topic;
    }

    private AttachedTopic _getTopic(String childTypeUri, AttachedTopic defaultTopic) {
        AttachedTopic topic = (AttachedTopic)this.childTopics.get(childTypeUri);
        return topic != null ? topic : defaultTopic;
    }

    private List<Topic> _getTopics(String childTypeUri) {
        try {
            List topics = (List)this.childTopics.get(childTypeUri);
            if (topics == null) {
                throw new RuntimeException("Child topics of type \"" + childTypeUri + "\" not found in " + this.childTopics);
            }
            return topics;
        }
        catch (ClassCastException e) {
            this.getModel().throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    private List<Topic> _getTopics(String childTypeUri, List<Topic> defaultValue) {
        try {
            List<Topic> topics = (List<Topic>)this.childTopics.get(childTypeUri);
            return topics != null ? topics : defaultValue;
        }
        catch (ClassCastException e) {
            this.getModel().throwInvalidAccess(childTypeUri, e);
            return null;
        }
    }

    private ChildTopics _update(String childTypeUri, TopicModel newChildTopic) {
        this.parent.update(new TopicModel(this.parent.getTypeUri(), new ChildTopicsModel().put(childTypeUri, newChildTopic)));
        return this;
    }

    private void updateCompositionOne(TopicModel newChildTopic, AssociationDefinition assocDef) {
        AttachedTopic childTopic = this._getTopic(assocDef.getChildTypeUri(), null);
        if (childTopic != null) {
            childTopic._update(newChildTopic);
        } else {
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateCompositionMany(List<TopicModel> newChildTopics, AssociationDefinition assocDef) {
        for (TopicModel newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                AttachedRelatedTopic childTopic = this.findChildTopic(childTopicId, assocDef);
                if (childTopic == null) continue;
                childTopic.delete();
                this.removeFromChildTopics(childTopic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateAggregationOne(TopicModel newChildTopic, AssociationDefinition assocDef) {
        RelatedTopic childTopic = (RelatedTopic)((Object)this._getTopic(assocDef.getChildTypeUri(), null));
        if (newChildTopic instanceof TopicReferenceModel) {
            if (childTopic != null) {
                if (((TopicReferenceModel)newChildTopic).isReferingTo(childTopic)) {
                    return;
                }
                childTopic.getRelatingAssociation().delete();
            }
            Topic topic = this.dms.valueStorage.associateReferencedChildTopic(this.parent.getModel(), (TopicReferenceModel)newChildTopic, assocDef);
            this.putInChildTopics(topic, assocDef);
        } else if (newChildTopic.getId() != -1L) {
            this.updateChildTopicOne(newChildTopic, assocDef);
        } else {
            if (childTopic != null) {
                childTopic.getRelatingAssociation().delete();
            }
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateAggregationMany(List<TopicModel> newChildTopics, AssociationDefinition assocDef) {
        for (TopicModel newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                AttachedRelatedTopic childTopic = this.findChildTopic(childTopicId, assocDef);
                if (childTopic == null) continue;
                childTopic.getRelatingAssociation().delete();
                this.removeFromChildTopics(childTopic, assocDef);
                continue;
            }
            if (newChildTopic instanceof TopicReferenceModel) {
                if (this.isReferingToAny((TopicReferenceModel)newChildTopic, assocDef)) continue;
                Topic topic = this.dms.valueStorage.associateReferencedChildTopic(this.parent.getModel(), (TopicReferenceModel)newChildTopic, assocDef);
                this.addToChildTopics(topic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateChildTopicOne(TopicModel newChildTopic, AssociationDefinition assocDef) {
        AttachedTopic childTopic = this._getTopic(assocDef.getChildTypeUri(), null);
        if (childTopic == null || childTopic.getId() != newChildTopic.getId()) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.parent.className() + " " + this.parent.getId() + " according to " + assocDef);
        }
        childTopic._update(newChildTopic);
    }

    private void updateChildTopicMany(TopicModel newChildTopic, AssociationDefinition assocDef) {
        AttachedRelatedTopic childTopic = this.findChildTopic(newChildTopic.getId(), assocDef);
        if (childTopic == null) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.parent.className() + " " + this.parent.getId() + " according to " + assocDef);
        }
        childTopic._update(newChildTopic);
    }

    private void createChildTopicOne(TopicModel newChildTopic, AssociationDefinition assocDef) {
        Topic childTopic = this.dms.createTopic(newChildTopic);
        this.dms.valueStorage.associateChildTopic(this.parent.getModel(), childTopic.getId(), assocDef);
        this.putInChildTopics(childTopic, assocDef);
    }

    private void createChildTopicMany(TopicModel newChildTopic, AssociationDefinition assocDef) {
        Topic childTopic = this.dms.createTopic(newChildTopic);
        this.dms.valueStorage.associateChildTopic(this.parent.getModel(), childTopic.getId(), assocDef);
        this.addToChildTopics(childTopic, assocDef);
    }

    private void initAttachedObjectCache() {
        for (String childTypeUri : this.model) {
            this.initAttachedObjectCache(childTypeUri);
        }
    }

    private void initAttachedObjectCache(String childTypeUri) {
        Object value = this.model.get(childTypeUri);
        if (value == null) {
            return;
        }
        if (value instanceof TopicModel) {
            TopicModel childTopic = (TopicModel)value;
            this.childTopics.put(childTypeUri, this.createAttachedObject(childTopic));
        } else if (value instanceof List) {
            ArrayList<Topic> topics = new ArrayList<Topic>();
            this.childTopics.put(childTypeUri, topics);
            for (TopicModel childTopic : (List)value) {
                topics.add(this.createAttachedObject(childTopic));
            }
        } else {
            throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
        }
    }

    private Topic createAttachedObject(TopicModel model) {
        if (model instanceof RelatedTopicModel) {
            return new AttachedRelatedTopic((RelatedTopicModel)model, this.dms);
        }
        return new AttachedTopic(model, this.dms);
    }

    private void putInChildTopics(Topic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.put(childTypeUri, childTopic);
        this.getModel().put(childTypeUri, childTopic.getModel());
    }

    private void addToChildTopics(Topic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.add(childTypeUri, childTopic);
        this.getModel().add(childTypeUri, childTopic.getModel());
    }

    private void removeFromChildTopics(Topic childTopic, AssociationDefinition assocDef) {
        String childTypeUri = assocDef.getChildTypeUri();
        this.remove(childTypeUri, childTopic);
        this.getModel().remove(childTypeUri, childTopic.getModel());
    }

    private void put(String childTypeUri, Topic topic) {
        this.childTopics.put(childTypeUri, topic);
    }

    private void add(String childTypeUri, Topic topic) {
        List<Topic> topics = this._getTopics(childTypeUri, null);
        if (topics == null) {
            topics = new ArrayList<Topic>();
            this.childTopics.put(childTypeUri, topics);
        }
        topics.add(topic);
    }

    private void remove(String childTypeUri, Topic topic) {
        List<Topic> topics = this._getTopics(childTypeUri, null);
        if (topics != null) {
            topics.remove(topic);
        }
    }

    private AttachedRelatedTopic findChildTopic(long childTopicId, AssociationDefinition assocDef) {
        List<Topic> childTopics = this._getTopics(assocDef.getChildTypeUri(), new ArrayList<Topic>());
        for (Topic childTopic : childTopics) {
            if (childTopic.getId() != childTopicId) continue;
            return (AttachedRelatedTopic)childTopic;
        }
        return null;
    }

    private boolean isReferingToAny(TopicReferenceModel topicRef, AssociationDefinition assocDef) {
        return topicRef.isReferingToAny(this._getTopics(assocDef.getChildTypeUri(), new ArrayList<Topic>()));
    }

    private AssociationDefinition getAssocDef(String childTypeUri) {
        return this.parent.getType().getAssocDef(childTypeUri);
    }
}

