/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.osgi;

import de.deepamehta.core.impl.PluginImpl;
import de.deepamehta.core.osgi.PluginContext;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.PluginService;
import de.deepamehta.core.service.SecurityHandler;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class PluginActivator
implements BundleActivator,
PluginContext {
    protected DeepaMehtaService dms;
    protected Bundle bundle;
    private BundleContext bundleContext;
    private PluginImpl plugin;
    private String pluginName;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext context) {
        try {
            this.bundleContext = context;
            this.bundle = context.getBundle();
            this.pluginName = (String)this.bundle.getHeaders().get("Bundle-Name");
            this.logger.info("========== Starting " + this + " ==========");
            this.plugin = new PluginImpl(this);
            this.plugin.start();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Starting " + this + " failed", e);
        }
    }

    public void stop(BundleContext context) {
        try {
            if (this.plugin == null) {
                this.logger.info("Stopping " + this + " ABORTED -- it was not successfully started");
                return;
            }
            this.logger.info("========== Stopping " + this + " ==========");
            this.plugin.stop();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Stopping " + this + " failed", e);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void postInstall() {
    }

    @Override
    public void serviceArrived(PluginService service) {
    }

    @Override
    public void serviceGone(PluginService service) {
    }

    @Override
    public final String getPluginName() {
        return this.pluginName;
    }

    @Override
    public final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public final void setCoreService(DeepaMehtaService dms) {
        this.dms = dms;
    }

    public String toString() {
        return "plugin \"" + this.pluginName + "\"";
    }

    protected final String getUri() {
        return this.plugin.getUri();
    }

    protected final InputStream getStaticResource(String name) {
        return this.plugin.getStaticResource(name);
    }

    protected final void publishDirectory(String directoryPath, String uriNamespace, SecurityHandler securityHandler) {
        this.plugin.publishDirectory(directoryPath, uriNamespace, securityHandler);
    }
}

