/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

public class AssociationDefinitionModel
extends AssociationModel {
    private String instanceLevelAssocTypeUri;
    private String parentTypeUri;
    private String childTypeUri;
    private String parentCardinalityUri;
    private String childCardinalityUri;
    private ViewConfigurationModel viewConfigModel;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public AssociationDefinitionModel(String typeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri) {
        this(-1L, null, typeUri, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri, null);
    }

    public AssociationDefinitionModel(long id, String uri, String typeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModel viewConfigModel) {
        super(id, uri, typeUri, AssociationDefinitionModel.parentRoleModel(parentTypeUri), AssociationDefinitionModel.childRoleModel(childTypeUri));
        this.instanceLevelAssocTypeUri = this.instanceLevelAssocTypeUri(typeUri);
        this.parentTypeUri = parentTypeUri;
        this.childTypeUri = childTypeUri;
        this.parentCardinalityUri = parentCardinalityUri;
        this.childCardinalityUri = childCardinalityUri;
        this.viewConfigModel = viewConfigModel != null ? viewConfigModel : new ViewConfigurationModel();
    }

    public String getInstanceLevelAssocTypeUri() {
        return this.instanceLevelAssocTypeUri;
    }

    public String getParentTypeUri() {
        return this.parentTypeUri;
    }

    public String getChildTypeUri() {
        return this.childTypeUri;
    }

    public String getParentCardinalityUri() {
        return this.parentCardinalityUri;
    }

    public String getChildCardinalityUri() {
        return this.childCardinalityUri;
    }

    public ViewConfigurationModel getViewConfigModel() {
        return this.viewConfigModel;
    }

    @Override
    public void setTypeUri(String typeUri) {
        super.setTypeUri(typeUri);
        this.instanceLevelAssocTypeUri = this.instanceLevelAssocTypeUri(typeUri);
    }

    public void setParentCardinalityUri(String parentCardinalityUri) {
        this.parentCardinalityUri = parentCardinalityUri;
    }

    public void setChildCardinalityUri(String childCardinalityUri) {
        this.childCardinalityUri = childCardinalityUri;
    }

    public void setViewConfigModel(ViewConfigurationModel viewConfigModel) {
        this.viewConfigModel = viewConfigModel;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = super.toJSON();
            o.put("parent_cardinality_uri", (Object)this.parentCardinalityUri);
            o.put("child_cardinality_uri", (Object)this.childCardinalityUri);
            this.viewConfigModel.toJSON(o);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public String toString() {
        return "\n    association definition (" + super.toString() + ",\n        parent cardinality=\"" + this.parentCardinalityUri + "\",\n        child cardinality=\"" + this.childCardinalityUri + "\",\n        " + this.viewConfigModel + ")\n";
    }

    static AssociationDefinitionModel fromJSON(JSONObject assocDef, String parentTypeUri) {
        try {
            long id = assocDef.optLong("id", -1L);
            String uri = null;
            String typeUri = assocDef.getString("assoc_type_uri");
            String childTypeUri = assocDef.getString("child_type_uri");
            if (!assocDef.has("parent_cardinality_uri") && !typeUri.equals("dm4.core.composition_def")) {
                throw new RuntimeException("\"parent_cardinality_uri\" is missing");
            }
            String parentCardinalityUri = assocDef.optString("parent_cardinality_uri", "dm4.core.one");
            String childCardinalityUri = assocDef.getString("child_cardinality_uri");
            ViewConfigurationModel viewConfigModel = new ViewConfigurationModel(assocDef);
            return new AssociationDefinitionModel(id, uri, typeUri, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri, viewConfigModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationDefinitionModel failed (JSONObject=" + assocDef + ")", e);
        }
    }

    static void toJSON(Collection<AssociationDefinitionModel> assocDefs, JSONObject o) throws Exception {
        ArrayList<JSONObject> assocDefList = new ArrayList<JSONObject>();
        for (AssociationDefinitionModel assocDef : assocDefs) {
            assocDefList.add(assocDef.toJSON());
        }
        o.put("assoc_defs", assocDefList);
    }

    private static TopicRoleModel parentRoleModel(String parentTypeUri) {
        return new TopicRoleModel(parentTypeUri, "dm4.core.parent_type");
    }

    private static TopicRoleModel childRoleModel(String childTypeUri) {
        return new TopicRoleModel(childTypeUri, "dm4.core.child_type");
    }

    private String instanceLevelAssocTypeUri(String typeUri) {
        if (typeUri.equals("dm4.core.aggregation_def")) {
            return "dm4.core.aggregation";
        }
        if (typeUri.equals("dm4.core.composition_def")) {
            return "dm4.core.composition";
        }
        throw new RuntimeException("Unexpected association type URI: \"" + typeUri + "\"");
    }
}

