/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.Type;
import de.deepamehta.core.impl.AttachedAssociationDefinition;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.AttachedType;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.model.TypeModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.TypeStorage;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class TypeStorageImpl
implements TypeStorage {
    private Map<String, TypeModel> typeCache = new HashMap<String, TypeModel>();
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    TypeStorageImpl(EmbeddedService dms) {
        this.dms = dms;
    }

    private TypeModel getType(String typeUri) {
        return this.typeCache.get(typeUri);
    }

    private void putInTypeCache(TypeModel type) {
        this.typeCache.put(type.getUri(), type);
    }

    TopicTypeModel getTopicType(String topicTypeUri) {
        TopicTypeModel topicType = (TopicTypeModel)this.getType(topicTypeUri);
        return topicType != null ? topicType : this.fetchTopicType(topicTypeUri);
    }

    AssociationTypeModel getAssociationType(String assocTypeUri) {
        AssociationTypeModel assocType = (AssociationTypeModel)this.getType(assocTypeUri);
        return assocType != null ? assocType : this.fetchAssociationType(assocTypeUri);
    }

    private TopicTypeModel fetchTopicType(String topicTypeUri) {
        Topic typeTopic = this.dms.getTopic("uri", new SimpleValue(topicTypeUri));
        this.checkTopicType(topicTypeUri, typeTopic);
        String dataTypeUri = this.fetchDataTypeTopic(typeTopic.getId(), topicTypeUri, "topic type").getUri();
        List<IndexMode> indexModes = this.fetchIndexModes(typeTopic.getId());
        List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
        List<String> labelConfig = this.fetchLabelConfig(assocDefs);
        ViewConfigurationModel viewConfig = this.fetchTypeViewConfig(typeTopic);
        TopicTypeModel topicType = new TopicTypeModel(typeTopic.getModel(), dataTypeUri, indexModes, assocDefs, labelConfig, viewConfig);
        this.putInTypeCache(topicType);
        return topicType;
    }

    private AssociationTypeModel fetchAssociationType(String assocTypeUri) {
        Topic typeTopic = this.dms.getTopic("uri", new SimpleValue(assocTypeUri));
        this.checkAssociationType(assocTypeUri, typeTopic);
        String dataTypeUri = this.fetchDataTypeTopic(typeTopic.getId(), assocTypeUri, "association type").getUri();
        List<IndexMode> indexModes = this.fetchIndexModes(typeTopic.getId());
        List<AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitions(typeTopic);
        List<String> labelConfig = this.fetchLabelConfig(assocDefs);
        ViewConfigurationModel viewConfig = this.fetchTypeViewConfig(typeTopic);
        AssociationTypeModel assocType = new AssociationTypeModel(typeTopic.getModel(), dataTypeUri, indexModes, assocDefs, labelConfig, viewConfig);
        this.putInTypeCache(assocType);
        return assocType;
    }

    private void checkTopicType(String topicTypeUri, Topic typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Topic type \"" + topicTypeUri + "\" not found in DB");
        }
        if (!(typeTopic.getTypeUri().equals("dm4.core.topic_type") || typeTopic.getTypeUri().equals("dm4.core.meta_type") || typeTopic.getTypeUri().equals("dm4.core.meta_meta_type"))) {
            throw new RuntimeException("URI \"" + topicTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dm4.core.topic_type\"");
        }
    }

    private void checkAssociationType(String assocTypeUri, Topic typeTopic) {
        if (typeTopic == null) {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not found in DB");
        }
        if (!typeTopic.getTypeUri().equals("dm4.core.assoc_type")) {
            throw new RuntimeException("URI \"" + assocTypeUri + "\" refers to a \"" + typeTopic.getTypeUri() + "\" when the caller expects a \"dm4.core.assoc_type\"");
        }
    }

    void storeType(TypeModel type) {
        this.putInTypeCache(type);
        this.storeDataType(type.getUri(), type.getDataTypeUri());
        this.storeIndexModes(type.getUri(), type.getIndexModes());
        this.storeAssocDefs(type.getUri(), type.getAssocDefs());
        this.storeLabelConfig(type.getLabelConfig(), type.getAssocDefs());
        this.storeViewConfig(this.createConfigurableType(type.getId()), type.getViewConfigModel());
    }

    private RelatedTopicModel fetchDataTypeTopic(long typeId, String typeUri, String className) {
        try {
            RelatedTopicModel dataType = this.dms.storageDecorator.fetchTopicRelatedTopic(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.default", "dm4.core.data_type");
            if (dataType == null) {
                throw new RuntimeException("No data type topic is associated to " + className + " \"" + typeUri + "\"");
            }
            return dataType;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching the data type topic of " + className + " \"" + typeUri + "\" failed", e);
        }
    }

    void storeDataType(String typeUri, String dataTypeUri) {
        try {
            this.dms.createAssociation("dm4.core.aggregation", new TopicRoleModel(typeUri, "dm4.core.type"), new TopicRoleModel(dataTypeUri, "dm4.core.default"));
        }
        catch (Exception e) {
            throw new RuntimeException("Associating type \"" + typeUri + "\" with data type \"" + dataTypeUri + "\" failed", e);
        }
    }

    private List<IndexMode> fetchIndexModes(long typeId) {
        ResultList<RelatedTopicModel> indexModes = this.dms.storageDecorator.fetchTopicRelatedTopics(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.default", "dm4.core.index_mode", 0);
        return IndexMode.fromTopics(indexModes.getItems());
    }

    private void storeIndexModes(String typeUri, List<IndexMode> indexModes) {
        for (IndexMode indexMode : indexModes) {
            this.storeIndexMode(typeUri, indexMode);
        }
    }

    void storeIndexMode(String typeUri, IndexMode indexMode) {
        this.dms.createAssociation("dm4.core.aggregation", new TopicRoleModel(typeUri, "dm4.core.type"), new TopicRoleModel(indexMode.toUri(), "dm4.core.default"));
    }

    @Override
    public void removeAssociationDefinitionFromMemoryAndRebuildSequence(Type type, String childTypeUri) {
        ((AttachedType)type).removeAssocDefFromMemoryAndRebuildSequence(childTypeUri);
    }

    private List<AssociationDefinitionModel> fetchAssociationDefinitions(Topic typeTopic) {
        Map<Long, AssociationDefinitionModel> assocDefs = this.fetchAssociationDefinitionsUnsorted(typeTopic);
        List<RelatedAssociationModel> sequence = this.fetchSequence(typeTopic);
        if (assocDefs.size() != sequence.size()) {
            throw new RuntimeException("DB inconsistency: type \"" + typeTopic.getUri() + "\" has " + assocDefs.size() + " association definitions but in sequence are " + sequence.size());
        }
        return this.sortAssocDefs(assocDefs, DeepaMehtaUtils.idList(sequence));
    }

    private Map<Long, AssociationDefinitionModel> fetchAssociationDefinitionsUnsorted(Topic typeTopic) {
        HashMap<Long, AssociationDefinitionModel> assocDefs = new HashMap<Long, AssociationDefinitionModel>();
        ResultList<RelatedTopic> childTypes = typeTopic.getRelatedTopics(Arrays.asList("dm4.core.aggregation_def", "dm4.core.composition_def"), "dm4.core.parent_type", "dm4.core.child_type", null, 0);
        for (RelatedTopic childType : childTypes) {
            AssociationDefinitionModel assocDef = this.fetchAssociationDefinition(childType.getRelatingAssociation(), typeTopic.getUri(), childType.getUri());
            assocDefs.put(assocDef.getId(), assocDef);
        }
        return assocDefs;
    }

    @Override
    public AssociationDefinitionModel fetchAssociationDefinition(Association assoc) {
        return this.fetchAssociationDefinition(assoc, this.fetchParentType(assoc).getUri(), this.fetchChildType(assoc).getUri());
    }

    private AssociationDefinitionModel fetchAssociationDefinition(Association assoc, String parentTypeUri, String childTypeUri) {
        try {
            long assocId = assoc.getId();
            return new AssociationDefinitionModel(assocId, assoc.getUri(), assoc.getTypeUri(), parentTypeUri, childTypeUri, this.fetchParentCardinality(assocId).getUri(), this.fetchChildCardinality(assocId).getUri(), this.fetchAssocDefViewConfig(assoc));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association definition failed (parentTypeUri=\"" + parentTypeUri + "\", childTypeUri=" + childTypeUri + ", " + assoc + ")", e);
        }
    }

    private List<AssociationDefinitionModel> sortAssocDefs(Map<Long, AssociationDefinitionModel> assocDefs, List<Long> sequence) {
        ArrayList<AssociationDefinitionModel> sortedAssocDefs = new ArrayList<AssociationDefinitionModel>();
        for (long assocDefId : sequence) {
            AssociationDefinitionModel assocDef = assocDefs.get(assocDefId);
            if (assocDef == null) {
                throw new RuntimeException("DB inconsistency: ID " + assocDefId + " is in sequence but not in the type's association definitions");
            }
            sortedAssocDefs.add(assocDef);
        }
        return sortedAssocDefs;
    }

    private void storeAssocDefs(String typeUri, Collection<AssociationDefinitionModel> assocDefs) {
        for (AssociationDefinitionModel assocDef : assocDefs) {
            this.storeAssociationDefinition(assocDef);
        }
        this.storeSequence(typeUri, assocDefs);
    }

    void storeAssociationDefinition(AssociationDefinitionModel assocDef) {
        try {
            if (assocDef.getId() == -1L) {
                this.dms.createAssociation(assocDef);
            }
            long assocDefId = assocDef.getId();
            this.associateParentCardinality(assocDefId, assocDef.getParentCardinalityUri());
            this.associateChildCardinality(assocDefId, assocDef.getChildCardinalityUri());
            this.storeViewConfig(this.createConfigurableAssocDef(assocDefId), assocDef.getViewConfigModel());
        }
        catch (Exception e) {
            throw new RuntimeException("Storing association definition \"" + assocDef.getChildTypeUri() + "\" of type \"" + assocDef.getParentTypeUri() + "\" failed", e);
        }
    }

    @Override
    public Topic fetchParentType(Association assoc) {
        Topic parentTypeTopic = assoc.getTopic("dm4.core.parent_type");
        if (parentTypeTopic == null) {
            throw new RuntimeException("Invalid association definition: topic role dm4.core.parent_type is missing in " + assoc);
        }
        return parentTypeTopic;
    }

    @Override
    public Topic fetchChildType(Association assoc) {
        Topic childTypeTopic = assoc.getTopic("dm4.core.child_type");
        if (childTypeTopic == null) {
            throw new RuntimeException("Invalid association definition: topic role dm4.core.child_type is missing in " + assoc);
        }
        return childTypeTopic;
    }

    private RelatedTopicModel fetchParentCardinality(long assocDefId) {
        RelatedTopicModel parentCard = this.dms.storageDecorator.fetchAssociationRelatedTopic(assocDefId, "dm4.core.aggregation", "dm4.core.assoc_def", "dm4.core.parent_cardinality", "dm4.core.cardinality");
        if (parentCard == null) {
            throw new RuntimeException("Invalid association definition: parent cardinality is missing (assocDefId=" + assocDefId + ")");
        }
        return parentCard;
    }

    private RelatedTopicModel fetchChildCardinality(long assocDefId) {
        RelatedTopicModel childCard = this.dms.storageDecorator.fetchAssociationRelatedTopic(assocDefId, "dm4.core.aggregation", "dm4.core.assoc_def", "dm4.core.child_cardinality", "dm4.core.cardinality");
        if (childCard == null) {
            throw new RuntimeException("Invalid association definition: child cardinality is missing (assocDefId=" + assocDefId + ")");
        }
        return childCard;
    }

    void storeParentCardinalityUri(long assocDefId, String parentCardinalityUri) {
        long assocId = this.fetchParentCardinality(assocDefId).getRelatingAssociation().getId();
        this.dms.deleteAssociation(assocId);
        this.associateParentCardinality(assocDefId, parentCardinalityUri);
    }

    void storeChildCardinalityUri(long assocDefId, String childCardinalityUri) {
        long assocId = this.fetchChildCardinality(assocDefId).getRelatingAssociation().getId();
        this.dms.deleteAssociation(assocId);
        this.associateChildCardinality(assocDefId, childCardinalityUri);
    }

    private void associateParentCardinality(long assocDefId, String parentCardinalityUri) {
        this.dms.createAssociation("dm4.core.aggregation", new TopicRoleModel(parentCardinalityUri, "dm4.core.parent_cardinality"), new AssociationRoleModel(assocDefId, "dm4.core.assoc_def"));
    }

    private void associateChildCardinality(long assocDefId, String childCardinalityUri) {
        this.dms.createAssociation("dm4.core.aggregation", new TopicRoleModel(childCardinalityUri, "dm4.core.child_cardinality"), new AssociationRoleModel(assocDefId, "dm4.core.assoc_def"));
    }

    private List<RelatedAssociationModel> fetchSequence(Topic typeTopic) {
        try {
            ArrayList<RelatedAssociationModel> sequence = new ArrayList<RelatedAssociationModel>();
            RelatedAssociation assocDef = typeTopic.getRelatedAssociation("dm4.core.aggregation", "dm4.core.type", "dm4.core.sequence_start", null);
            if (assocDef != null) {
                sequence.add(assocDef.getModel());
                while ((assocDef = assocDef.getRelatedAssociation("dm4.core.sequence", "dm4.core.predecessor", "dm4.core.successor", null)) != null) {
                    sequence.add(assocDef.getModel());
                }
            }
            return sequence;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching sequence for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private void storeSequence(String typeUri, Collection<AssociationDefinitionModel> assocDefs) {
        this.logger.fine("### Storing " + assocDefs.size() + " sequence segments for type \"" + typeUri + "\"");
        AssociationDefinitionModel predecessor = null;
        for (AssociationDefinitionModel assocDef : assocDefs) {
            this.appendToSequence(typeUri, assocDef, predecessor);
            predecessor = assocDef;
        }
    }

    void appendToSequence(String typeUri, AssociationDefinitionModel assocDef, AssociationDefinitionModel predecessor) {
        if (predecessor == null) {
            this.storeSequenceStart(typeUri, assocDef.getId());
        } else {
            this.storeSequenceSegment(predecessor.getId(), assocDef.getId());
        }
    }

    private void storeSequenceStart(String typeUri, long assocDefId) {
        this.dms.createAssociation("dm4.core.aggregation", new TopicRoleModel(typeUri, "dm4.core.type"), new AssociationRoleModel(assocDefId, "dm4.core.sequence_start"));
    }

    private void storeSequenceSegment(long predAssocDefId, long succAssocDefId) {
        this.dms.createAssociation("dm4.core.sequence", new AssociationRoleModel(predAssocDefId, "dm4.core.predecessor"), new AssociationRoleModel(succAssocDefId, "dm4.core.successor"));
    }

    void rebuildSequence(Type type) {
        this.deleteSequence(type);
        this.storeSequence(type.getUri(), type.getModel().getAssocDefs());
    }

    private void deleteSequence(Topic typeTopic) {
        List<RelatedAssociationModel> sequence = this.fetchSequence(typeTopic);
        this.logger.info("### Deleting " + sequence.size() + " sequence segments of type \"" + typeTopic.getUri() + "\"");
        for (RelatedAssociationModel assoc : sequence) {
            long assocId = assoc.getRelatingAssociation().getId();
            this.dms.deleteAssociation(assocId);
        }
    }

    private List<String> fetchLabelConfig(List<AssociationDefinitionModel> assocDefs) {
        ArrayList<String> labelConfig = new ArrayList<String>();
        for (AssociationDefinitionModel assocDef : assocDefs) {
            RelatedTopicModel includeInLabel = this.fetchLabelConfigTopic(assocDef.getId());
            if (includeInLabel == null || !includeInLabel.getSimpleValue().booleanValue()) continue;
            labelConfig.add(assocDef.getChildTypeUri());
        }
        return labelConfig;
    }

    private RelatedTopicModel fetchLabelConfigTopic(long assocDefId) {
        return this.dms.storageDecorator.fetchAssociationRelatedTopic(assocDefId, "dm4.core.composition", "dm4.core.parent", "dm4.core.child", "dm4.core.include_in_label");
    }

    void storeLabelConfig(List<String> labelConfig, Collection<AssociationDefinitionModel> assocDefs) {
        for (AssociationDefinitionModel assocDef : assocDefs) {
            boolean includeInLabel = labelConfig.contains(assocDef.getChildTypeUri());
            new AttachedAssociationDefinition(assocDef, this.dms).getChildTopics().set("dm4.core.include_in_label", includeInLabel);
        }
    }

    private ViewConfigurationModel fetchTypeViewConfig(Topic typeTopic) {
        try {
            ResultList<RelatedTopic> configTopics = typeTopic.getRelatedTopics("dm4.core.aggregation", "dm4.core.type", "dm4.core.view_config", null, 0).loadChildTopics();
            return new ViewConfigurationModel(DeepaMehtaUtils.toTopicModels(configTopics));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for type \"" + typeTopic.getUri() + "\" failed", e);
        }
    }

    private ViewConfigurationModel fetchAssocDefViewConfig(Association assocDef) {
        try {
            ResultList<RelatedTopic> configTopics = assocDef.getRelatedTopics("dm4.core.aggregation", "dm4.core.assoc_def", "dm4.core.view_config", null, 0).loadChildTopics();
            return new ViewConfigurationModel(DeepaMehtaUtils.toTopicModels(configTopics));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching view configuration for association definition " + assocDef.getId() + " failed", e);
        }
    }

    private RelatedTopicModel fetchTypeViewConfigTopic(long typeId, String configTypeUri) {
        return this.dms.storageDecorator.fetchTopicRelatedTopic(typeId, "dm4.core.aggregation", "dm4.core.type", "dm4.core.view_config", configTypeUri);
    }

    private RelatedTopicModel fetchAssocDefViewConfigTopic(long assocDefId, String configTypeUri) {
        return this.dms.storageDecorator.fetchAssociationRelatedTopic(assocDefId, "dm4.core.aggregation", "dm4.core.assoc_def", "dm4.core.view_config", configTypeUri);
    }

    private TopicModel fetchViewConfigTopic(RoleModel configurable, String configTypeUri) {
        if (configurable instanceof TopicRoleModel) {
            long typeId = configurable.getPlayerId();
            return this.fetchTypeViewConfigTopic(typeId, configTypeUri);
        }
        if (configurable instanceof AssociationRoleModel) {
            long assocDefId = configurable.getPlayerId();
            return this.fetchAssocDefViewConfigTopic(assocDefId, configTypeUri);
        }
        throw new RuntimeException("Unexpected configurable: " + configurable);
    }

    private void storeViewConfig(RoleModel configurable, ViewConfigurationModel viewConfig) {
        try {
            for (TopicModel configTopic : viewConfig.getConfigTopics()) {
                this.storeViewConfigTopic(configurable, configTopic);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view configuration failed (configurable=" + configurable + ")", e);
        }
    }

    void storeViewConfigTopic(RoleModel configurable, TopicModel configTopic) {
        Topic topic = this.dms.createTopic(configTopic);
        this.dms.createAssociation("dm4.core.aggregation", configurable, new TopicRoleModel(topic.getId(), "dm4.core.view_config"));
    }

    void storeViewConfigSetting(RoleModel configurable, String configTypeUri, String settingUri, Object value) {
        try {
            TopicModel configTopic = this.fetchViewConfigTopic(configurable, configTypeUri);
            new AttachedTopic(configTopic, this.dms).getChildTopics().set(settingUri, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view configuration setting failed (configurable=" + configurable + ", configTypeUri=\"" + configTypeUri + "\", settingUri=\"" + settingUri + "\", value=\"" + value + "\")", e);
        }
    }

    RoleModel createConfigurableType(long typeId) {
        return new TopicRoleModel(typeId, "dm4.core.type");
    }

    RoleModel createConfigurableAssocDef(long assocDefId) {
        return new AssociationRoleModel(assocDefId, "dm4.core.assoc_def");
    }
}

