/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class TransactionFactory
implements ResourceFilterFactory {
    private DeepaMehtaService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static final ThreadLocal<DeepaMehtaTransaction> threadLocalTransaction = new ThreadLocal();

    TransactionFactory(DeepaMehtaService dms) {
        this.dms = dms;
    }

    public List<ResourceFilter> create(AbstractMethod method) {
        if (!method.isAnnotationPresent(Transactional.class)) {
            return null;
        }
        this.logger.fine("### Adding transaction support to " + method);
        ArrayList<ResourceFilter> filters = new ArrayList<ResourceFilter>();
        filters.add(new TransactionResourceFilter(method));
        return filters;
    }

    private class TransactionResourceFilter
    implements ResourceFilter {
        private AbstractMethod method;

        private TransactionResourceFilter(AbstractMethod method) {
            this.method = method;
        }

        public ContainerRequestFilter getRequestFilter() {
            return new ContainerRequestFilter(){

                public ContainerRequest filter(ContainerRequest request) {
                    TransactionFactory.this.logger.fine("### Begining transaction of " + TransactionResourceFilter.this.method);
                    DeepaMehtaTransaction tx = TransactionFactory.this.dms.beginTx();
                    threadLocalTransaction.set(tx);
                    return request;
                }
            };
        }

        public ContainerResponseFilter getResponseFilter() {
            return new ContainerResponseFilter(){

                public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
                    boolean success = response.getMappedThrowable() == null;
                    DeepaMehtaTransaction tx = (DeepaMehtaTransaction)threadLocalTransaction.get();
                    if (success) {
                        TransactionFactory.this.logger.fine("### Comitting transaction of " + TransactionResourceFilter.this.method);
                        tx.success();
                    } else {
                        TransactionFactory.this.logger.warning("### Rollback transaction of " + TransactionResourceFilter.this.method);
                    }
                    tx.finish();
                    return response;
                }
            };
        }
    }
}

