/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.impl.PluginImpl;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.PluginInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

class PluginManager {
    private Map<String, PluginImpl> activatedPlugins = new HashMap<String, PluginImpl>();
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    PluginManager(EmbeddedService dms) {
        this.dms = dms;
    }

    synchronized void activatePlugin(PluginImpl plugin) {
        if (!this._isPluginActivated(plugin.getUri())) {
            plugin.activate();
            this.addToActivatedPlugins(plugin);
            if (this.checkAllPluginsActivated()) {
                this.logger.info("########## All Plugins Active ##########");
                this.dms.fireEvent(CoreEvent.ALL_PLUGINS_ACTIVE, new Object[0]);
            }
        } else {
            this.logger.info("Activation of " + plugin + " ABORTED -- already activated");
        }
    }

    synchronized void deactivatePlugin(PluginImpl plugin) {
        String pluginUri = plugin.getUri();
        if (this._isPluginActivated(pluginUri)) {
            plugin.deactivate();
            this.removeFromActivatedPlugins(pluginUri);
        } else {
            this.logger.info("Deactivation of " + plugin + " ABORTED -- it was not successfully activated");
        }
    }

    synchronized boolean isPluginActivated(String pluginUri) {
        return this._isPluginActivated(pluginUri);
    }

    synchronized PluginImpl getPlugin(String pluginUri) {
        PluginImpl plugin = this.activatedPlugins.get(pluginUri);
        if (plugin == null) {
            throw new RuntimeException("Plugin \"" + pluginUri + "\" not found");
        }
        return plugin;
    }

    synchronized List<PluginInfo> getPluginInfo() {
        ArrayList<PluginInfo> info = new ArrayList<PluginInfo>();
        for (PluginImpl plugin : this.activatedPlugins.values()) {
            info.add(plugin.getInfo());
        }
        return info;
    }

    private boolean checkAllPluginsActivated() {
        Bundle[] bundles = this.dms.bundleContext.getBundles();
        int plugins = 0;
        int activated = 0;
        for (Bundle bundle : bundles) {
            if (!this.isDeepaMehtaPlugin(bundle)) continue;
            ++plugins;
            if (!this._isPluginActivated(bundle.getSymbolicName())) continue;
            ++activated;
        }
        this.logger.info("### Bundles total: " + bundles.length + ", DeepaMehta plugins: " + plugins + ", Activated: " + activated);
        return plugins == activated;
    }

    private boolean isDeepaMehtaPlugin(Bundle bundle) {
        try {
            String activatorClassName = (String)bundle.getHeaders().get("Bundle-Activator");
            if (activatorClassName != null) {
                Class activatorClass = bundle.loadClass(activatorClassName);
                return PluginActivator.class.isAssignableFrom(activatorClass);
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Plugin detection failed for bundle " + bundle, e);
        }
    }

    private void addToActivatedPlugins(PluginImpl plugin) {
        this.activatedPlugins.put(plugin.getUri(), plugin);
    }

    private void removeFromActivatedPlugins(String pluginUri) {
        if (this.activatedPlugins.remove(pluginUri) == null) {
            throw new RuntimeException("Removing plugin \"" + pluginUri + "\" from pool of activated plugins failed: " + "not found in " + this.activatedPlugins);
        }
    }

    private boolean _isPluginActivated(String pluginUri) {
        return this.activatedPlugins.get(pluginUri) != null;
    }
}

