/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.impl.PluginImpl;
import de.deepamehta.core.service.Migration;
import de.deepamehta.core.service.Plugin;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

class MigrationManager {
    private static final String CORE_MIGRATIONS_PACKAGE = "de.deepamehta.core.migrations";
    private static final int REQUIRED_CORE_MIGRATION = 3;
    private EmbeddedService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    MigrationManager(EmbeddedService dms) {
        this.dms = dms;
    }

    void runPluginMigrations(PluginImpl plugin, boolean isCleanInstall) {
        int migrationNr = plugin.getPluginTopic().getChildTopics().getTopic("dm4.core.plugin_migration_nr").getSimpleValue().intValue();
        int requiredMigrationNr = Integer.parseInt(plugin.getConfigProperty("requiredPluginMigrationNr", "0"));
        int migrationsToRun = requiredMigrationNr - migrationNr;
        if (migrationsToRun == 0) {
            this.logger.info("Running migrations for " + plugin + " ABORTED -- everything up-to-date (migrationNr=" + migrationNr + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " migrations for " + plugin + " (migrationNr=" + migrationNr + ", requiredMigrationNr=" + requiredMigrationNr + ")");
        for (int i = migrationNr + 1; i <= requiredMigrationNr; ++i) {
            this.runPluginMigration(plugin, i, isCleanInstall);
        }
    }

    void runCoreMigrations(boolean isCleanInstall) {
        int requiredMigrationNr = 3;
        int migrationNr = this.dms.storageDecorator.fetchMigrationNr();
        int migrationsToRun = requiredMigrationNr - migrationNr;
        if (migrationsToRun == 0) {
            this.logger.info("Running core migrations ABORTED -- everything up-to-date (migrationNr=" + migrationNr + ")");
            return;
        }
        this.logger.info("Running " + migrationsToRun + " core migrations (migrationNr=" + migrationNr + ", requiredMigrationNr=" + requiredMigrationNr + ")");
        for (int i = migrationNr + 1; i <= requiredMigrationNr; ++i) {
            this.runCoreMigration(i, isCleanInstall);
        }
    }

    private void runCoreMigration(int migrationNr, boolean isCleanInstall) {
        this.runMigration(migrationNr, null, isCleanInstall);
        this.dms.storageDecorator.storeMigrationNr(migrationNr);
    }

    private void runPluginMigration(PluginImpl plugin, int migrationNr, boolean isCleanInstall) {
        this.runMigration(migrationNr, plugin, isCleanInstall);
        plugin.setMigrationNr(migrationNr);
    }

    private void runMigration(int migrationNr, PluginImpl plugin, boolean isCleanInstall) {
        MigrationInfo mi = null;
        try {
            mi = new MigrationInfo(migrationNr, plugin);
            if (!mi.success) {
                throw mi.exception;
            }
            if (!mi.isDeclarative && !mi.isImperative) {
                String message = "Neither a migration file (" + mi.migrationFile + ") nor a migration class ";
                if (mi.migrationClassName != null) {
                    throw new RuntimeException(message + "(" + mi.migrationClassName + ") is found");
                }
                throw new RuntimeException(message + "is found. Note: a possible migration class can't be located" + " (plugin package is unknown). Consider setting \"pluginPackage\" in plugin.properties");
            }
            if (mi.isDeclarative && mi.isImperative) {
                throw new RuntimeException("Ambiguity: a migration file (" + mi.migrationFile + ") AND a migration " + "class (" + mi.migrationClassName + ") are found. Consider using two different migration numbers.");
            }
            String runInfo = " (runMode=" + mi.runMode + ", isCleanInstall=" + isCleanInstall + ")";
            if (mi.runMode.equals(MigrationRunMode.CLEAN_INSTALL.name()) == isCleanInstall || mi.runMode.equals(MigrationRunMode.ALWAYS.name())) {
                this.logger.info("Running " + mi.migrationInfo + runInfo);
                if (mi.isDeclarative) {
                    DeepaMehtaUtils.readMigrationFile(mi.migrationIn, mi.migrationFile, this.dms);
                } else {
                    Migration migration = (Migration)mi.migrationClass.newInstance();
                    this.logger.info("Running " + mi.migrationType + " migration class " + mi.migrationClassName);
                    migration.setCoreService(this.dms);
                    migration.run();
                }
                this.logger.info("Completing " + mi.migrationInfo);
            } else {
                this.logger.info("Running " + mi.migrationInfo + " ABORTED" + runInfo);
            }
            this.logger.info("Updating migration number (" + migrationNr + ")");
        }
        catch (Exception e) {
            throw new RuntimeException("Running " + mi.migrationInfo + " failed", e);
        }
    }

    private class MigrationInfo {
        String migrationType;
        String migrationInfo;
        String runMode;
        boolean isDeclarative;
        boolean isImperative;
        String migrationFile;
        InputStream migrationIn;
        String migrationClassName;
        Class migrationClass;
        boolean success;
        Exception exception;

        MigrationInfo(int migrationNr, PluginImpl plugin) {
            try {
                InputStream configIn;
                String configFile = this.migrationConfigFile(migrationNr);
                this.migrationFile = this.migrationFile(migrationNr);
                String string = this.migrationType = plugin != null ? "plugin" : "core";
                if (this.migrationType.equals("core")) {
                    this.migrationInfo = "core migration " + migrationNr;
                    configIn = this.getClass().getResourceAsStream(configFile);
                    this.migrationIn = this.getClass().getResourceAsStream(this.migrationFile);
                    this.migrationClassName = this.coreMigrationClassName(migrationNr);
                    this.migrationClass = this.loadClass(this.migrationClassName);
                } else {
                    this.migrationInfo = "migration " + migrationNr + " of " + plugin;
                    configIn = this.getStaticResourceOrNull(plugin, configFile);
                    this.migrationIn = this.getStaticResourceOrNull(plugin, this.migrationFile);
                    this.migrationClassName = plugin.getMigrationClassName(migrationNr);
                    if (this.migrationClassName != null) {
                        this.migrationClass = plugin.loadClass(this.migrationClassName);
                    }
                }
                this.isDeclarative = this.migrationIn != null;
                this.isImperative = this.migrationClass != null;
                this.readMigrationConfigFile(configIn, configFile);
                this.success = true;
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void readMigrationConfigFile(InputStream in, String configFile) {
            try {
                Properties migrationConfig = new Properties();
                if (in != null) {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\"");
                    migrationConfig.load(in);
                } else {
                    MigrationManager.this.logger.info("Reading migration config file \"" + configFile + "\" ABORTED -- file does not exist");
                }
                this.runMode = migrationConfig.getProperty("migrationRunMode", MigrationRunMode.ALWAYS.name());
                MigrationRunMode.valueOf(this.runMode);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed: \"" + this.runMode + "\" is an invalid value for \"migrationRunMode\"", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading migration config file \"" + configFile + "\" failed", e);
            }
        }

        private String migrationFile(int migrationNr) {
            return "/migrations/migration" + migrationNr + ".json";
        }

        private String migrationConfigFile(int migrationNr) {
            return "/migrations/migration" + migrationNr + ".properties";
        }

        private String coreMigrationClassName(int migrationNr) {
            return "de.deepamehta.core.migrations.Migration" + migrationNr;
        }

        private InputStream getStaticResourceOrNull(Plugin plugin, String resourceName) {
            if (plugin.hasStaticResource(resourceName)) {
                return plugin.getStaticResource(resourceName);
            }
            return null;
        }

        private Class loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private static enum MigrationRunMode {
        CLEAN_INSTALL,
        UPDATE,
        ALWAYS;

    }
}

