/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.osgi.PluginContext;
import de.deepamehta.core.service.PluginService;
import java.lang.reflect.Field;

class InjectableService {
    private PluginContext pluginContext;
    private Class<? extends PluginService> serviceInterface;
    private Field injectableField;
    private boolean isServiceAvailable;

    InjectableService(PluginContext pluginContext, Class<? extends PluginService> serviceInterface, Field injectableField) {
        this.pluginContext = pluginContext;
        this.serviceInterface = serviceInterface;
        this.injectableField = injectableField;
        injectableField.setAccessible(true);
    }

    public String toString() {
        return this.serviceInterface.getName();
    }

    Class<? extends PluginService> getServiceInterface() {
        return this.serviceInterface;
    }

    boolean isServiceAvailable() {
        return this.isServiceAvailable;
    }

    void injectService(Object service) {
        this.injectValue(service);
        this.isServiceAvailable = true;
    }

    void injectNull() {
        this.injectValue(null);
        this.isServiceAvailable = false;
    }

    private void injectValue(Object value) {
        try {
            this.injectableField.set(this.pluginContext, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Injecting " + (value == null ? "null for " : "") + this + " failed", e);
        }
    }
}

