/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Topic;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.HashMap;
import java.util.Map;

class AttachedViewConfiguration
implements ViewConfiguration {
    private final RoleModel configurable;
    private final ViewConfigurationModel model;
    private final EmbeddedService dms;
    private Map<String, Topic> configTopics = new HashMap<String, Topic>();

    AttachedViewConfiguration(RoleModel configurable, ViewConfigurationModel model, EmbeddedService dms) {
        this.configurable = configurable;
        this.model = model;
        this.dms = dms;
        this.initConfigTopics();
    }

    @Override
    public Iterable<Topic> getConfigTopics() {
        return this.configTopics.values();
    }

    @Override
    public void addSetting(String configTypeUri, String settingUri, Object value) {
        TopicModel createdTopicModel = this.model.addSetting(configTypeUri, settingUri, value);
        if (createdTopicModel != null) {
            this.addConfigTopic(createdTopicModel);
            this.dms.typeStorage.storeViewConfigTopic(this.configurable, createdTopicModel);
        } else {
            this.dms.typeStorage.storeViewConfigSetting(this.configurable, configTypeUri, settingUri, value);
        }
    }

    @Override
    public void updateConfigTopic(TopicModel configTopic) {
        this.model.updateConfigTopic(configTopic);
    }

    @Override
    public ViewConfigurationModel getModel() {
        return this.model;
    }

    private void initConfigTopics() {
        for (TopicModel configTopic : this.model.getConfigTopics()) {
            this.addConfigTopic(configTopic);
        }
    }

    private void addConfigTopic(TopicModel configTopic) {
        this.configTopics.put(configTopic.getTypeUri(), new AttachedTopic(configTopic, this.dms));
    }
}

