/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.Type;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.impl.AttachedAssociationDefinition;
import de.deepamehta.core.impl.AttachedTopic;
import de.deepamehta.core.impl.AttachedViewConfiguration;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TypeModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

abstract class AttachedType
extends AttachedTopic
implements Type {
    private Map<String, AssociationDefinition> assocDefs;
    private ViewConfiguration viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedType(TypeModel model, EmbeddedService dms) {
        super(model, dms);
        this.initAssocDefs();
        this.initViewConfig();
    }

    @Override
    public void update(TypeModel model) {
        boolean uriChanged = this.hasUriChanged(model.getUri());
        if (uriChanged) {
            this._removeFromTypeCache();
        }
        super.update(model);
        if (uriChanged) {
            this.putInTypeCache();
        }
        this.updateDataTypeUri(model.getDataTypeUri());
        this.updateAssocDefs(model.getAssocDefs());
        this.updateSequence(model.getAssocDefs());
        this.updateLabelConfig(model.getLabelConfig());
    }

    @Override
    public void delete() {
        try {
            this.logger.info("Deleting " + this.className() + " \"" + this.getUri() + "\"");
            super.delete();
            this._removeFromTypeCache();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting " + this.className() + " \"" + this.getUri() + "\" failed", e);
        }
    }

    @Override
    public String getDataTypeUri() {
        return this.getModel().getDataTypeUri();
    }

    @Override
    public void setDataTypeUri(String dataTypeUri) {
        this.getModel().setDataTypeUri(dataTypeUri);
        this.storeDataTypeUri(dataTypeUri);
    }

    @Override
    public List<IndexMode> getIndexModes() {
        return this.getModel().getIndexModes();
    }

    @Override
    public void addIndexMode(IndexMode indexMode) {
        this.getModel().addIndexMode(indexMode);
        this.dms.typeStorage.storeIndexMode(this.getUri(), indexMode);
        this.indexAllInstances(indexMode);
    }

    @Override
    public Collection<AssociationDefinition> getAssocDefs() {
        return this.assocDefs.values();
    }

    @Override
    public AssociationDefinition getAssocDef(String childTypeUri) {
        AssociationDefinition assocDef = this.assocDefs.get(childTypeUri);
        if (assocDef == null) {
            throw new RuntimeException("Schema violation: association definition \"" + childTypeUri + "\" not found in " + this);
        }
        return assocDef;
    }

    @Override
    public boolean hasAssocDef(String childTypeUri) {
        return this.assocDefs.get(childTypeUri) != null;
    }

    @Override
    public void addAssocDef(AssociationDefinitionModel model) {
        AssociationDefinitionModel predecessor = this.lastAssocDef();
        this.getModel().addAssocDef(model);
        this._addAssocDef(model);
        this.dms.typeStorage.storeAssociationDefinition(model);
        this.dms.typeStorage.appendToSequence(this.getUri(), model, predecessor);
    }

    @Override
    public void updateAssocDef(AssociationDefinitionModel model) {
        this.getModel().updateAssocDef(model);
        this._addAssocDef(model);
    }

    @Override
    public void removeAssocDef(String childTypeUri) {
        this.getAssocDef(childTypeUri).delete();
    }

    @Override
    public List<String> getLabelConfig() {
        return this.getModel().getLabelConfig();
    }

    @Override
    public void setLabelConfig(List<String> labelConfig) {
        this.getModel().setLabelConfig(labelConfig);
        this.dms.typeStorage.storeLabelConfig(labelConfig, this.getModel().getAssocDefs());
    }

    @Override
    public ViewConfiguration getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public Object getViewConfig(String typeUri, String settingUri) {
        return this.getModel().getViewConfig(typeUri, settingUri);
    }

    @Override
    public TypeModel getModel() {
        return (TypeModel)super.getModel();
    }

    abstract void putInTypeCache();

    abstract void removeFromTypeCache();

    abstract Directive getDeleteTypeDirective();

    abstract List<? extends DeepaMehtaObject> getAllInstances();

    void removeAssocDefFromMemoryAndRebuildSequence(String childTypeUri) {
        this.getModel().removeAssocDef(childTypeUri);
        this._removeAssocDef(childTypeUri);
        this.dms.typeStorage.rebuildSequence(this);
    }

    private boolean hasUriChanged(String newUri) {
        return newUri != null && !this.getUri().equals(newUri);
    }

    private void updateDataTypeUri(String newDataTypeUri) {
        String dataTypeUri;
        if (newDataTypeUri != null && !(dataTypeUri = this.getDataTypeUri()).equals(newDataTypeUri)) {
            this.logger.info("### Changing data type URI from \"" + dataTypeUri + "\" -> \"" + newDataTypeUri + "\"");
            this.setDataTypeUri(newDataTypeUri);
        }
    }

    private void storeDataTypeUri(String dataTypeUri) {
        this.getRelatedTopic("dm4.core.aggregation", "dm4.core.type", "dm4.core.default", "dm4.core.data_type").getRelatingAssociation().delete();
        this.dms.typeStorage.storeDataType(this.getUri(), dataTypeUri);
    }

    private void indexAllInstances(IndexMode indexMode) {
        List<? extends DeepaMehtaObject> objects = this.getAllInstances();
        String str = "\"" + this.getSimpleValue() + "\" (" + this.getUri() + ") instances";
        if (this.getIndexModes().size() > 0) {
            if (objects.size() > 0) {
                this.logger.info("### Indexing " + objects.size() + " " + str + " (indexMode=" + (Object)((Object)indexMode) + ")");
            } else {
                this.logger.info("### Indexing " + str + " ABORTED -- no instances in DB");
            }
        } else {
            this.logger.info("### Indexing " + str + " ABORTED -- no index mode set");
        }
        for (DeepaMehtaObject deepaMehtaObject : objects) {
            this.dms.valueStorage.indexSimpleValue(deepaMehtaObject.getModel(), indexMode);
        }
    }

    private void updateAssocDefs(Collection<AssociationDefinitionModel> newAssocDefs) {
        for (AssociationDefinitionModel assocDef : newAssocDefs) {
            this.getAssocDef(assocDef.getChildTypeUri()).update(assocDef);
        }
    }

    private void updateSequence(Collection<AssociationDefinitionModel> newAssocDefs) {
        if (!this.hasSequenceChanged(newAssocDefs)) {
            return;
        }
        this.logger.info("### Changing assoc def sequence");
        this.getModel().removeAllAssocDefs();
        for (AssociationDefinitionModel assocDef : newAssocDefs) {
            this.getModel().addAssocDef(assocDef);
        }
        this.initAssocDefs();
        this.dms.typeStorage.rebuildSequence(this);
    }

    private boolean hasSequenceChanged(Collection<AssociationDefinitionModel> newAssocDefs) {
        Collection<AssociationDefinition> assocDefs = this.getAssocDefs();
        if (assocDefs.size() != newAssocDefs.size()) {
            throw new RuntimeException("adding/removing of assoc defs not yet supported via updateTopicType() call");
        }
        Iterator<AssociationDefinitionModel> i = newAssocDefs.iterator();
        for (AssociationDefinition assocDef : assocDefs) {
            AssociationDefinitionModel newAssocDef = i.next();
            if (assocDef.getChildTypeUri().equals(newAssocDef.getChildTypeUri())) continue;
            return true;
        }
        return false;
    }

    private void updateLabelConfig(List<String> newLabelConfig) {
        if (!((Object)this.getLabelConfig()).equals(newLabelConfig)) {
            this.logger.info("### Changing label configuration");
            this.setLabelConfig(newLabelConfig);
        }
    }

    private AssociationDefinitionModel lastAssocDef() {
        AssociationDefinitionModel lastAssocDef = null;
        Iterator<AssociationDefinitionModel> i$ = this.getModel().getAssocDefs().iterator();
        while (i$.hasNext()) {
            AssociationDefinitionModel assocDef;
            lastAssocDef = assocDef = i$.next();
        }
        return lastAssocDef;
    }

    protected void initAssocDefs() {
        this.assocDefs = new LinkedHashMap<String, AssociationDefinition>();
        for (AssociationDefinitionModel model : this.getModel().getAssocDefs()) {
            this._addAssocDef(model);
        }
    }

    private void _addAssocDef(AssociationDefinitionModel model) {
        AttachedAssociationDefinition assocDef = new AttachedAssociationDefinition(model, this.dms);
        this.assocDefs.put(assocDef.getChildTypeUri(), assocDef);
    }

    private void _removeAssocDef(String childTypeUri) {
        this.getAssocDef(childTypeUri);
        this.assocDefs.remove(childTypeUri);
    }

    private void initViewConfig() {
        RoleModel configurable = this.dms.typeStorage.createConfigurableType(this.getId());
        this.viewConfig = new AttachedViewConfiguration(configurable, this.getModel().getViewConfigModel(), this.dms);
    }

    private void _removeFromTypeCache() {
        this.removeFromTypeCache();
        this.addDeleteTypeDirective();
    }

    private void addDeleteTypeDirective() {
        Directive dir = this.getDeleteTypeDirective();
        Directives.get().add(dir, new JSONWrapper("uri", this.getUri()));
    }

    private class JSONWrapper
    implements JSONEnabled {
        private JSONObject wrapped;

        private JSONWrapper(String key, Object value) {
            try {
                this.wrapped = new JSONObject();
                this.wrapped.put(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Constructing a JSONWrapper failed", e);
            }
        }

        @Override
        public JSONObject toJSON() {
            return this.wrapped;
        }
    }
}

