/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.impl.AttachedType;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import java.util.List;
import java.util.logging.Logger;

class AttachedAssociationType
extends AttachedType
implements AssociationType {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedAssociationType(AssociationTypeModel model, EmbeddedService dms) {
        super(model, dms);
    }

    @Override
    public AssociationTypeModel getModel() {
        return (AssociationTypeModel)super.getModel();
    }

    @Override
    public void update(AssociationTypeModel model) {
        this.logger.info("Updating association type \"" + this.getUri() + "\" (new " + model + ")");
        Directives.get().add(Directive.UPDATE_ASSOCIATION_TYPE, this);
        super.update(model);
    }

    @Override
    final String className() {
        return "association type";
    }

    @Override
    final void putInTypeCache() {
        this.dms.typeCache.putAssociationType(this);
    }

    @Override
    final void removeFromTypeCache() {
        this.dms.typeCache.removeAssociationType(this.getUri());
    }

    @Override
    final Directive getDeleteTypeDirective() {
        return Directive.DELETE_ASSOCIATION_TYPE;
    }

    @Override
    final List<? extends DeepaMehtaObject> getAllInstances() {
        return this.dms.getAssociations(this.getUri()).getItems();
    }
}

