/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.impl.AttachedAssociation;
import de.deepamehta.core.impl.AttachedViewConfiguration;
import de.deepamehta.core.impl.EmbeddedService;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.RoleModel;
import java.util.logging.Logger;

class AttachedAssociationDefinition
extends AttachedAssociation
implements AssociationDefinition {
    private AttachedViewConfiguration viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AttachedAssociationDefinition(AssociationDefinitionModel model, EmbeddedService dms) {
        super(model, dms);
        this.initViewConfig();
    }

    @Override
    public String getInstanceLevelAssocTypeUri() {
        return this.getModel().getInstanceLevelAssocTypeUri();
    }

    @Override
    public String getParentTypeUri() {
        return this.getModel().getParentTypeUri();
    }

    @Override
    public String getChildTypeUri() {
        return this.getModel().getChildTypeUri();
    }

    @Override
    public String getParentCardinalityUri() {
        return this.getModel().getParentCardinalityUri();
    }

    @Override
    public String getChildCardinalityUri() {
        return this.getModel().getChildCardinalityUri();
    }

    @Override
    public ViewConfiguration getViewConfig() {
        return this.viewConfig;
    }

    @Override
    public AssociationDefinitionModel getModel() {
        return (AssociationDefinitionModel)super.getModel();
    }

    @Override
    public void setParentCardinalityUri(String parentCardinalityUri) {
        this.getModel().setParentCardinalityUri(parentCardinalityUri);
        this.dms.typeStorage.storeParentCardinalityUri(this.getId(), parentCardinalityUri);
    }

    @Override
    public void setChildCardinalityUri(String childCardinalityUri) {
        this.getModel().setChildCardinalityUri(childCardinalityUri);
        this.dms.typeStorage.storeChildCardinalityUri(this.getId(), childCardinalityUri);
    }

    @Override
    public void update(AssociationDefinitionModel newModel) {
        this.updateAssocTypeUri(newModel);
        this.updateParentCardinality(newModel.getParentCardinalityUri());
        this.updateChildCardinality(newModel.getChildCardinalityUri());
    }

    private void updateAssocTypeUri(AssociationDefinitionModel newModel) {
        String newTypeUri = newModel.getTypeUri();
        if (newTypeUri == null) {
            return;
        }
        String typeUri = this.getTypeUri();
        if (!typeUri.equals(newTypeUri)) {
            super.update(newModel);
        }
    }

    private void updateParentCardinality(String newParentCardinalityUri) {
        if (newParentCardinalityUri == null) {
            return;
        }
        String parentCardinalityUri = this.getParentCardinalityUri();
        if (!parentCardinalityUri.equals(newParentCardinalityUri)) {
            this.logger.info("### Changing parent cardinality URI from \"" + parentCardinalityUri + "\" -> \"" + newParentCardinalityUri + "\"");
            this.setParentCardinalityUri(newParentCardinalityUri);
        }
    }

    private void updateChildCardinality(String newChildCardinalityUri) {
        if (newChildCardinalityUri == null) {
            return;
        }
        String childCardinalityUri = this.getChildCardinalityUri();
        if (!childCardinalityUri.equals(newChildCardinalityUri)) {
            this.logger.info("### Changing child cardinality URI from \"" + childCardinalityUri + "\" -> \"" + newChildCardinalityUri + "\"");
            this.setChildCardinalityUri(newChildCardinalityUri);
        }
    }

    private void initViewConfig() {
        RoleModel configurable = this.dms.typeStorage.createConfigurableAssocDef(this.getId());
        this.viewConfig = new AttachedViewConfiguration(configurable, this.getModel().getViewConfigModel(), this.dms);
    }
}

