/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.contacts.migrations;

import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.service.Migration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Migration2
extends Migration {
    private List<Entry> phoneEntries = new ArrayList<Entry>();
    private List<Entry> addressEntries = new ArrayList<Entry>();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Converting Phone Entry and Address Entry topics");
        this.bufferContentAndDeleteTypes();
        this.dms.createAssociationType(new AssociationTypeModel("dm4.contacts.phone_entry", "Phone Entry", "dm4.core.composite").addAssocDef(new AssociationDefinitionModel("dm4.core.aggregation_def", "dm4.contacts.phone_entry", "dm4.contacts.phone_label", "dm4.core.many", "dm4.core.one")));
        this.dms.createAssociationType(new AssociationTypeModel("dm4.contacts.address_entry", "Address Entry", "dm4.core.composite").addAssocDef(new AssociationDefinitionModel("dm4.core.aggregation_def", "dm4.contacts.address_entry", "dm4.contacts.address_label", "dm4.core.many", "dm4.core.one")));
        this.dms.getTopicType("dm4.contacts.person").addAssocDefBefore(new AssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.phone_entry", "dm4.contacts.person", "dm4.contacts.phone_number", "dm4.core.one", "dm4.core.many"), "dm4.contacts.email_address").addAssocDefBefore(new AssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.address_entry", "dm4.contacts.person", "dm4.contacts.address", "dm4.core.one", "dm4.core.many"), "dm4.contacts.notes");
        this.dms.getTopicType("dm4.contacts.institution").addAssocDefBefore(new AssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.phone_entry", "dm4.contacts.institution", "dm4.contacts.phone_number", "dm4.core.one", "dm4.core.many"), "dm4.contacts.email_address").addAssocDefBefore(new AssociationDefinitionModel("dm4.core.composition_def", "dm4.contacts.address_entry", "dm4.contacts.institution", "dm4.contacts.address", "dm4.core.one", "dm4.core.many"), "dm4.contacts.notes");
        for (Entry entry : this.phoneEntries) {
            this.convertPhoneEntry(entry);
        }
        for (Entry entry : this.addressEntries) {
            this.convertAddressEntry(entry);
        }
        this.logger.info("########## Converting Phone Entry and Address Entry topics complete.\n    Phone entries converted: " + this.phoneEntries.size() + "\n    " + "Address entries converted: " + this.addressEntries.size());
    }

    private void bufferContentAndDeleteTypes() {
        for (RelatedTopic phoneEntry : this.dms.getTopics("dm4.contacts.phone_entry", 0)) {
            this.bufferPhoneEntry((Topic)phoneEntry);
        }
        for (RelatedTopic addressEntry : this.dms.getTopics("dm4.contacts.address_entry", 0)) {
            this.bufferAddressEntry((Topic)addressEntry);
        }
        this.dms.getTopicType("dm4.contacts.phone_entry").getAssocDef("dm4.contacts.phone_number").setTypeUri("dm4.core.aggregation_def");
        this.dms.getTopicType("dm4.contacts.address_entry").getAssocDef("dm4.contacts.address").setTypeUri("dm4.core.aggregation_def");
        for (Entry entry : this.phoneEntries) {
            entry.topic.delete();
        }
        for (Entry entry : this.addressEntries) {
            entry.topic.delete();
        }
        this.dms.deleteTopicType("dm4.contacts.phone_entry");
        this.dms.deleteTopicType("dm4.contacts.address_entry");
    }

    private void bufferPhoneEntry(Topic phoneEntry) {
        RelatedTopic parent = phoneEntry.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", null);
        RelatedTopic phoneLabel = phoneEntry.getChildTopics().getTopic("dm4.contacts.phone_label");
        RelatedTopic phoneNumber = phoneEntry.getChildTopics().getTopic("dm4.contacts.phone_number");
        this.phoneEntries.add(new Entry(phoneEntry, (Topic)parent, phoneLabel.getId(), phoneNumber.getId()));
    }

    private void bufferAddressEntry(Topic addressEntry) {
        RelatedTopic parent = addressEntry.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", null);
        RelatedTopic addressLabel = addressEntry.getChildTopics().getTopic("dm4.contacts.address_label");
        RelatedTopic address = addressEntry.getChildTopics().getTopic("dm4.contacts.address");
        this.addressEntries.add(new Entry(addressEntry, (Topic)parent, addressLabel.getId(), address.getId()));
    }

    private void convertPhoneEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dm4.contacts.phone_number", entry.objectId, new ChildTopicsModel().putRef("dm4.contacts.phone_label", entry.labelId));
    }

    private void convertAddressEntry(Entry entry) {
        entry.parent.getChildTopics().addRef("dm4.contacts.address", entry.objectId, new ChildTopicsModel().putRef("dm4.contacts.address_label", entry.labelId));
    }

    private class Entry {
        private Topic topic;
        private Topic parent;
        private long labelId;
        private long objectId;

        private Entry(Topic topic, Topic parent, long labelId, long objectId) {
            this.topic = topic;
            this.parent = parent;
            this.labelId = labelId;
            this.objectId = objectId;
        }
    }
}

