/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.config;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.accesscontrol.AccessControl;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.plugins.config.ConfigDefinition;
import de.deepamehta.plugins.config.ConfigDefinitions;
import de.deepamehta.plugins.config.ConfigModificationRole;
import de.deepamehta.plugins.config.ConfigService;
import de.deepamehta.plugins.config.ConfigTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/config")
@Produces(value={"application/json"})
public class ConfigPlugin
extends PluginActivator
implements ConfigService,
PostCreateTopicListener {
    private static String ASSOC_TYPE_CONFIGURATION = "dm4.config.configuration";
    private static String ROLE_TYPE_CONFIGURABLE = "dm4.config.configurable";
    private static String ROLE_TYPE_DEFAULT = "dm4.core.default";
    private Map<String, List<ConfigDefinition>> registry = new HashMap<String, List<ConfigDefinition>>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{config_type_uri}/topic/{topic_id}")
    public RelatedTopic getConfigTopic(@PathParam(value="config_type_uri") String configTypeUri, @PathParam(value="topic_id") long topicId) {
        return this._getConfigTopic(configTypeUri, topicId);
    }

    @Override
    public void createConfigTopic(String configTypeUri, Topic topic) {
        this.createConfigTopic(this.getApplicableConfigDefinition(topic, configTypeUri), topic.getId());
    }

    @Override
    public void registerConfigDefinition(ConfigDefinition configDef) {
        try {
            if (this.isRegistered(configDef)) {
                throw new RuntimeException("A definition for configuration type \"" + configDef.getConfigTypeUri() + "\" is already registered");
            }
            String hashKey = configDef.getHashKey();
            List<ConfigDefinition> configDefs = this.lookupConfigDefinitions(hashKey);
            if (configDefs == null) {
                configDefs = new ArrayList<ConfigDefinition>();
                this.registry.put(hashKey, configDefs);
            }
            configDefs.add(configDef);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering a configuration definition failed", e);
        }
    }

    @Override
    public void unregisterConfigDefinition(String configTypeUri) {
        try {
            for (List<ConfigDefinition> configDefs : this.registry.values()) {
                ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
                if (configDef == null) continue;
                if (!configDefs.remove(configDef)) {
                    throw new RuntimeException("Configuration definition could not be removed from registry");
                }
                return;
            }
            throw new RuntimeException("No such configuration definition registered");
        }
        catch (Exception e) {
            throw new RuntimeException("Unregistering definition for configuration type \"" + configTypeUri + "\" failed", e);
        }
    }

    @Override
    @GET
    public ConfigDefinitions getConfigDefinitions() {
        return new ConfigDefinitions(this.registry);
    }

    public void postCreateTopic(Topic topic) {
        for (ConfigDefinition configDef : this.getApplicableConfigDefinitions(topic)) {
            this.createConfigTopic(configDef, topic.getId());
        }
    }

    private RelatedTopic _getConfigTopic(String configTypeUri, long topicId) {
        return this.dms.getAccessControl().getConfigTopic(configTypeUri, topicId);
    }

    private RelatedTopic createConfigTopic(final ConfigDefinition configDef, final long topicId) {
        final String configTypeUri = configDef.getConfigTypeUri();
        try {
            this.logger.info("### Creating config topic of type \"" + configTypeUri + "\" for topic " + topicId);
            return (RelatedTopic)this.dms.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<RelatedTopic>(){

                @Override
                public RelatedTopic call() {
                    Topic configTopic = ConfigPlugin.this.dms.createTopic(configDef.getDefaultConfigTopic());
                    ConfigPlugin.this.dms.createAssociation(new AssociationModel(ASSOC_TYPE_CONFIGURATION, (RoleModel)new TopicRoleModel(topicId, ROLE_TYPE_CONFIGURABLE), (RoleModel)new TopicRoleModel(configTopic.getId(), ROLE_TYPE_DEFAULT)));
                    ConfigPlugin.this.assignConfigTopicToWorkspace(configTopic, configDef.getConfigModificationRole());
                    return ConfigPlugin.this._getConfigTopic(configTypeUri, topicId);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating config topic of type \"" + configTypeUri + "\" for topic " + topicId + " failed", e);
        }
    }

    private void assignConfigTopicToWorkspace(Topic configTopic, ConfigModificationRole role) {
        long workspaceId;
        AccessControl ac = this.dms.getAccessControl();
        switch (role) {
            case ADMIN: {
                workspaceId = ac.getSystemWorkspaceId();
                break;
            }
            default: {
                throw new RuntimeException("Modification role \"" + (Object)((Object)role) + "\" not yet implemented");
            }
        }
        ac.assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
    }

    private List<ConfigDefinition> getApplicableConfigDefinitions(Topic topic) {
        ArrayList configDefs1 = this.lookupConfigDefinitions(ConfigTarget.SINGLETON.hashKey(topic));
        List<ConfigDefinition> configDefs2 = this.lookupConfigDefinitions(ConfigTarget.TYPE_INSTANCES.hashKey(topic));
        if (configDefs1 != null && configDefs2 != null) {
            ArrayList<ConfigDefinition> configDefs = new ArrayList<ConfigDefinition>();
            configDefs.addAll(configDefs1);
            configDefs.addAll(configDefs2);
            return configDefs;
        }
        return configDefs1 != null ? configDefs1 : (configDefs2 != null ? configDefs2 : new ArrayList());
    }

    private ConfigDefinition getApplicableConfigDefinition(Topic topic, String configTypeUri) {
        List<ConfigDefinition> configDefs = this.getApplicableConfigDefinitions(topic);
        if (configDefs.size() == 0) {
            throw new RuntimeException("None of the registered configuration definitions are applicable to " + this.info(topic));
        }
        ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
        if (configDef == null) {
            throw new RuntimeException("For " + this.info(topic) + " no configuration definition for type \"" + configTypeUri + "\" registered");
        }
        return configDef;
    }

    private boolean isRegistered(ConfigDefinition configDef) {
        for (List<ConfigDefinition> configDefs : this.registry.values()) {
            if (!configDefs.contains(configDef)) continue;
            return true;
        }
        return false;
    }

    private ConfigDefinition findByConfigTypeUri(List<ConfigDefinition> configDefs, String configTypeUri) {
        for (ConfigDefinition configDef : configDefs) {
            if (!configDef.getConfigTypeUri().equals(configTypeUri)) continue;
            return configDef;
        }
        return null;
    }

    private List<ConfigDefinition> lookupConfigDefinitions(String hashKey) {
        return this.registry.get(hashKey);
    }

    private String info(Topic topic) {
        return "topic " + topic.getId() + " (value=\"" + topic.getSimpleValue() + "\", typeUri=\"" + topic.getTypeUri() + "\", uri=\"" + topic.getUri() + "\")";
    }
}

