/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.caching;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.event.ServiceRequestFilterListener;
import de.deepamehta.core.service.event.ServiceResponseFilterListener;
import de.deepamehta.plugins.time.service.TimeService;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class CachingPlugin
extends PluginActivator
implements ServiceRequestFilterListener,
ServiceResponseFilterListener {
    private static String CACHABLE_PATH = "core/(topic|association)/(\\d+)";
    private static String HEADER_CACHE_CONTROL = "Cache-Control";
    @Inject
    private TimeService timeService;
    private Pattern cachablePath = Pattern.compile(CACHABLE_PATH);
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void serviceRequestFilter(ContainerRequest request) {
        DeepaMehtaObject object = this.requestObject(request);
        if (object != null) {
            if (this.timeService == null) {
                throw new RuntimeException("Time service is not available");
            }
            long time = this.timeService.getModificationTime(object);
            Response.ResponseBuilder response = request.evaluatePreconditions(new Date(time));
            if (response != null) {
                this.logger.info("### Precondition of " + request.getMethod() + " request failed (object " + object.getId() + ")");
                throw new WebApplicationException(response.build());
            }
        }
    }

    public void serviceResponseFilter(ContainerResponse response) {
        DeepaMehtaObject object = this.responseObject(response);
        if (object != null) {
            this.setCacheControlHeader(response, "max-age=0");
        }
    }

    private DeepaMehtaObject requestObject(ContainerRequest request) {
        Matcher m = this.cachablePath.matcher(request.getPath());
        if (m.matches()) {
            String objectType = m.group(1);
            long objectId = Long.parseLong(m.group(2));
            if (objectType.equals("topic")) {
                return this.dms.getTopic(objectId);
            }
            if (objectType.equals("association")) {
                return this.dms.getAssociation(objectId);
            }
            throw new RuntimeException("Unexpected object type: \"" + objectType + "\"");
        }
        return null;
    }

    private DeepaMehtaObject responseObject(ContainerResponse response) {
        Object entity = response.getEntity();
        return entity instanceof DeepaMehtaObject ? (DeepaMehtaObject)entity : null;
    }

    private void setCacheControlHeader(ContainerResponse response, String value) {
        this.setHeader(response, HEADER_CACHE_CONTROL, value);
    }

    private void setHeader(ContainerResponse response, String header, String value) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (headers.containsKey((Object)header)) {
            throw new RuntimeException("Response already has a \"" + header + "\" header");
        }
        headers.putSingle((Object)header, (Object)value);
    }
}

