/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.accesscontrol.migrations;

import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Migration;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.accesscontrol.SharingMode;
import de.deepamehta.plugins.accesscontrol.service.AccessControlService;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.logging.Logger;

public class Migration8
extends Migration {
    @Inject
    private AccessControlService acService;
    @Inject
    private WorkspacesService wsService;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        ResultList userAccounts = this.dms.getTopics("dm4.accesscontrol.user_account", 0);
        this.logger.info("########## Converting " + userAccounts.getSize() + " user accounts");
        for (RelatedTopic userAccount : userAccounts) {
            ChildTopics childTopics = userAccount.getChildTopics();
            RelatedTopic usernameTopic = childTopics.getTopic("dm4.accesscontrol.username");
            RelatedTopic passwordTopic = childTopics.getTopic("dm4.accesscontrol.password");
            Topic privateWorkspace = this.wsService.createWorkspace("Private Workspace", null, SharingMode.PRIVATE);
            String username = usernameTopic.getSimpleValue().toString();
            this.acService.setWorkspaceOwner(privateWorkspace, username);
            long privateWorkspaceId = privateWorkspace.getId();
            this.wsService.assignToWorkspace((DeepaMehtaObject)userAccount, privateWorkspaceId);
            this.wsService.assignToWorkspace((DeepaMehtaObject)passwordTopic, privateWorkspaceId);
            this.createMemberships((Topic)usernameTopic);
            Topic systemWorkspace = this.wsService.getWorkspace("dm4.workspaces.system");
            this.wsService.assignToWorkspace((DeepaMehtaObject)usernameTopic, systemWorkspace.getId());
        }
    }

    private void createMemberships(Topic usernameTopic) {
        String username = usernameTopic.getSimpleValue().toString();
        ResultList workspaces = usernameTopic.getRelatedTopics("dm4.core.aggregation", "dm4.core.parent", "dm4.core.child", "dm4.workspaces.workspace", 0);
        this.logger.info("######## User \"" + username + "\" is member of " + workspaces.getSize() + " workspaces");
        for (RelatedTopic workspace : workspaces) {
            long workspaceId = workspace.getId();
            String owner = this.acService.getWorkspaceOwner(workspaceId);
            boolean isOwner = username.equals(owner);
            this.logger.info("##### Workspace \"" + workspace.getSimpleValue() + "\" (id=" + workspace.getId() + "), owner: " + owner + " -> create " + (isOwner ? "NO " : "") + "Membership");
            if (!isOwner) {
                this.acService.createMembership(username, workspaceId);
            }
            workspace.getRelatingAssociation().delete();
        }
    }
}

