/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.accesscontrol;

import com.sun.jersey.spi.container.ContainerRequest;
import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.EventListener;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.accesscontrol.AccessControlException;
import de.deepamehta.core.service.accesscontrol.Credentials;
import de.deepamehta.core.service.accesscontrol.Operation;
import de.deepamehta.core.service.accesscontrol.Permissions;
import de.deepamehta.core.service.accesscontrol.SharingMode;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PostUpdateAssociationListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PreGetAssociationListener;
import de.deepamehta.core.service.event.PreGetTopicListener;
import de.deepamehta.core.service.event.ResourceRequestFilterListener;
import de.deepamehta.core.service.event.ServiceRequestFilterListener;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.plugins.accesscontrol.event.PostLoginUserListener;
import de.deepamehta.plugins.accesscontrol.event.PostLogoutUserListener;
import de.deepamehta.plugins.accesscontrol.service.AccessControlService;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/accesscontrol")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessControlPlugin
extends PluginActivator
implements AccessControlService,
PreGetTopicListener,
PreGetAssociationListener,
PostCreateTopicListener,
PostCreateAssociationListener,
PostUpdateTopicListener,
PostUpdateAssociationListener,
ServiceRequestFilterListener,
ResourceRequestFilterListener {
    private static final boolean READ_REQUIRES_LOGIN = Boolean.parseBoolean(System.getProperty("dm4.security.read_requires_login", "false"));
    private static final boolean WRITE_REQUIRES_LOGIN = Boolean.parseBoolean(System.getProperty("dm4.security.write_requires_login", "true"));
    private static final String SUBNET_FILTER = System.getProperty("dm4.security.subnet_filter", "127.0.0.1/32");
    private static final String AUTHENTICATION_REALM = "DeepaMehta";
    private static final String MEMBERSHIP_TYPE = "dm4.accesscontrol.membership";
    private static String PROP_CREATOR = "dm4.accesscontrol.creator";
    private static String PROP_OWNER = "dm4.accesscontrol.owner";
    private static String PROP_MODIFIER = "dm4.accesscontrol.modifier";
    private static DeepaMehtaEvent POST_LOGIN_USER = new DeepaMehtaEvent(PostLoginUserListener.class){

        public void deliver(EventListener listener, Object ... params) {
            ((PostLoginUserListener)listener).postLoginUser((String)params[0]);
        }
    };
    private static DeepaMehtaEvent POST_LOGOUT_USER = new DeepaMehtaEvent(PostLogoutUserListener.class){

        public void deliver(EventListener listener, Object ... params) {
            ((PostLogoutUserListener)listener).postLogoutUser((String)params[0]);
        }
    };
    @Inject
    private WorkspacesService wsService;
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/login")
    public void login() {
    }

    @Override
    @POST
    @Path(value="/logout")
    public void logout() {
        this._logout(this.request);
        if (READ_REQUIRES_LOGIN) {
            this.throw401Unauthorized();
        }
    }

    @Override
    @GET
    @Path(value="/user")
    @Produces(value={"text/plain"})
    public String getUsername() {
        try {
            HttpSession session = this.request.getSession(false);
            if (session == null) {
                return null;
            }
            return this.username(session);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    @POST
    @Path(value="/user_account")
    @Transactional
    public Topic createUserAccount(Credentials cred) {
        String username = cred.username;
        this.logger.info("Creating user account \"" + username + "\"");
        Topic userAccount = this.dms.createTopic(new TopicModel("dm4.accesscontrol.user_account", new ChildTopicsModel().put("dm4.accesscontrol.username", (Object)username).put("dm4.accesscontrol.password", (Object)cred.password)));
        ChildTopics childTopics = userAccount.getChildTopics();
        RelatedTopic usernameTopic = childTopics.getTopic("dm4.accesscontrol.username");
        RelatedTopic passwordTopic = childTopics.getTopic("dm4.accesscontrol.password");
        Topic privateWorkspace = this.wsService.createWorkspace("Private Workspace", null, SharingMode.PRIVATE);
        this.setWorkspaceOwner(privateWorkspace, username);
        long privateWorkspaceId = privateWorkspace.getId();
        this.dms.getAccessControl().assignToWorkspace((DeepaMehtaObject)userAccount, privateWorkspaceId);
        this.dms.getAccessControl().assignToWorkspace((DeepaMehtaObject)passwordTopic, privateWorkspaceId);
        Topic systemWorkspace = this.wsService.getWorkspace("dm4.workspaces.system");
        this.wsService.assignToWorkspace((DeepaMehtaObject)usernameTopic, systemWorkspace.getId());
        return usernameTopic;
    }

    @Override
    @GET
    @Path(value="/user/workspace")
    public Topic getPrivateWorkspace() {
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("No user is logged in");
        }
        Topic passwordTopic = this.getPasswordTopic(this.getUserAccount(this.getUsernameTopic(username)));
        Topic workspace = this.wsService.getAssignedWorkspace(passwordTopic.getId());
        if (workspace == null) {
            throw new RuntimeException("User \"" + username + "\" has no private workspace");
        }
        return workspace;
    }

    @Override
    public Topic getUsernameTopic(String username) {
        return this.dms.getTopic("dm4.accesscontrol.username", new SimpleValue(username));
    }

    @Override
    @GET
    @Path(value="/workspace/{workspace_id}/owner")
    @Produces(value={"text/plain"})
    public String getWorkspaceOwner(@PathParam(value="workspace_id") long workspaceId) {
        return this.dms.hasProperty(workspaceId, PROP_OWNER) ? (String)this.dms.getProperty(workspaceId, PROP_OWNER) : null;
    }

    @Override
    public void setWorkspaceOwner(Topic workspace, String username) {
        try {
            workspace.setProperty(PROP_OWNER, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the workspace owner of " + this.info((DeepaMehtaObject)workspace) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/user/{username}/workspace/{workspace_id}")
    @Transactional
    public void createMembership(@PathParam(value="username") String username, @PathParam(value="workspace_id") long workspaceId) {
        try {
            this.dms.createAssociation(new AssociationModel(MEMBERSHIP_TYPE, (RoleModel)new TopicRoleModel(this.getUsernameTopicOrThrow(username).getId(), "dm4.core.default"), (RoleModel)new TopicRoleModel(workspaceId, "dm4.core.default")));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating membership for user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        return this.dms.getAccessControl().isMember(username, workspaceId);
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Permissions getTopicPermissions(@PathParam(value="id") long topicId) {
        return this.getPermissions(topicId);
    }

    @Override
    @GET
    @Path(value="/association/{id}")
    public Permissions getAssociationPermissions(@PathParam(value="id") long assocId) {
        return this.getPermissions(assocId);
    }

    @Override
    @GET
    @Path(value="/object/{id}/creator")
    @Produces(value={"text/plain"})
    public String getCreator(@PathParam(value="id") long objectId) {
        return this.dms.hasProperty(objectId, PROP_CREATOR) ? (String)this.dms.getProperty(objectId, PROP_CREATOR) : null;
    }

    @Override
    @GET
    @Path(value="/object/{id}/modifier")
    @Produces(value={"text/plain"})
    public String getModifier(@PathParam(value="id") long objectId) {
        return this.dms.hasProperty(objectId, PROP_MODIFIER) ? (String)this.dms.getProperty(objectId, PROP_MODIFIER) : null;
    }

    @Override
    @GET
    @Path(value="/creator/{username}/topics")
    public Collection<Topic> getTopicsByCreator(@PathParam(value="username") String username) {
        return this.dms.getTopicsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/topics")
    public Collection<Topic> getTopicsByOwner(@PathParam(value="username") String username) {
        return this.dms.getTopicsByProperty(PROP_OWNER, (Object)username);
    }

    @Override
    @GET
    @Path(value="/creator/{username}/assocs")
    public Collection<Association> getAssociationsByCreator(@PathParam(value="username") String username) {
        return this.dms.getAssociationsByProperty(PROP_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/assocs")
    public Collection<Association> getAssociationsByOwner(@PathParam(value="username") String username) {
        return this.dms.getAssociationsByProperty(PROP_OWNER, (Object)username);
    }

    public void init() {
        this.logger.info("Security settings:\ndm4.security.read_requires_login=" + READ_REQUIRES_LOGIN + "\ndm4.security.write_requires_login=" + WRITE_REQUIRES_LOGIN + "\ndm4.security.subnet_filter=\"" + SUBNET_FILTER + "\"");
    }

    public void preGetTopic(long topicId) {
        this.checkReadPermission(topicId);
    }

    public void preGetAssociation(long assocId) {
        this.checkReadPermission(assocId);
        long[] playerIds = this.dms.getPlayerIds(assocId);
        this.checkReadPermission(playerIds[0]);
        this.checkReadPermission(playerIds[1]);
    }

    public void postCreateTopic(Topic topic) {
        String typeUri = topic.getTypeUri();
        if (typeUri.equals("dm4.workspaces.workspace")) {
            this.setWorkspaceOwner(topic);
        } else if (typeUri.equals("dm4.webclient.search")) {
            this.assignSearchTopic(topic);
        }
        this.setCreatorAndModifier((DeepaMehtaObject)topic);
    }

    public void postCreateAssociation(Association assoc) {
        this.setCreatorAndModifier((DeepaMehtaObject)assoc);
    }

    public void postUpdateTopic(Topic topic, TopicModel newModel, TopicModel oldModel) {
        if (topic.getTypeUri().equals("dm4.accesscontrol.user_account")) {
            String oldUsername;
            RelatedTopic usernameTopic = topic.getChildTopics().getTopic("dm4.accesscontrol.username");
            RelatedTopic passwordTopic = topic.getChildTopics().getTopic("dm4.accesscontrol.password");
            String newUsername = usernameTopic.getSimpleValue().toString();
            RelatedTopicModel oldUsernameTopic = oldModel.getChildTopicsModel().getTopic("dm4.accesscontrol.username", null);
            String string = oldUsername = oldUsernameTopic != null ? oldUsernameTopic.getSimpleValue().toString() : "";
            if (!newUsername.equals(oldUsername)) {
                if (!oldUsername.equals("")) {
                    throw new RuntimeException("Changing a Username is not supported (tried \"" + oldUsername + "\" -> \"" + newUsername + "\")");
                }
                this.logger.info("### Username has changed from \"" + oldUsername + "\" -> \"" + newUsername + "\". Setting \"" + newUsername + "\" as the new owner of 3 topics:\n" + "    - User Account topic (ID " + topic.getId() + ")\n" + "    - Username topic (ID " + usernameTopic.getId() + ")\n" + "    - Password topic (ID " + passwordTopic.getId() + ")");
            }
        }
        this.setModifier((DeepaMehtaObject)topic);
    }

    public void postUpdateAssociation(Association assoc, AssociationModel oldModel) {
        if (this.isMembership(assoc.getModel())) {
            if (!this.isMembership(oldModel)) {
                this.wsService.assignToWorkspace((DeepaMehtaObject)assoc, assoc.getTopicByType("dm4.workspaces.workspace").getId());
            }
        } else if (this.isMembership(oldModel)) {
            // empty if block
        }
        this.setModifier((DeepaMehtaObject)assoc);
    }

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.requestFilter(this.request);
    }

    public void resourceRequestFilter(HttpServletRequest servletRequest) {
        this.requestFilter(servletRequest);
    }

    private Topic getUserAccount(Topic usernameTopic) {
        return usernameTopic.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", "dm4.accesscontrol.user_account");
    }

    private Topic getPasswordTopic(Topic userAccount) {
        return userAccount.getChildTopics().getTopic("dm4.accesscontrol.password");
    }

    private Topic getUsernameTopicOrThrow(String username) {
        Topic usernameTopic = this.getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    private boolean isMembership(AssociationModel assoc) {
        return assoc.getTypeUri().equals(MEMBERSHIP_TYPE);
    }

    private void assignSearchTopic(Topic searchTopic) {
        try {
            Topic workspace = this.getUsername() != null ? this.getPrivateWorkspace() : this.wsService.getWorkspace("dm4.workspaces.deepamehta");
            this.wsService.assignToWorkspace((DeepaMehtaObject)searchTopic, workspace.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning search topic to workspace failed", e);
        }
    }

    private void requestFilter(HttpServletRequest request) {
        this.logger.fine("##### " + request.getMethod() + " " + request.getRequestURL() + "\n      ##### \"Authorization\"=\"" + request.getHeader("Authorization") + "\"" + "\n      ##### " + this.info(request.getSession(false)));
        this.checkRequestOrigin(request);
        this.checkAuthorization(request);
    }

    private void checkRequestOrigin(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        boolean allowed = JavaUtils.isInRange((String)remoteAddr, (String)SUBNET_FILTER);
        this.logger.fine("Remote address=\"" + remoteAddr + "\", dm4.security.subnet_filter=\"" + SUBNET_FILTER + "\" => " + (allowed ? "ALLOWED" : "FORBIDDEN"));
        if (!allowed) {
            this.throw403Forbidden();
        }
    }

    private void checkAuthorization(HttpServletRequest request) {
        boolean authorized;
        if (request.getSession(false) != null) {
            authorized = true;
        } else {
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                authorized = this.tryLogin(new Credentials(authHeader), request);
            } else {
                boolean bl = authorized = !this.isLoginRequired(request);
            }
        }
        if (!authorized) {
            this.throw401Unauthorized();
        }
    }

    private boolean isLoginRequired(HttpServletRequest request) {
        return request.getMethod().equals("GET") ? READ_REQUIRES_LOGIN : WRITE_REQUIRES_LOGIN;
    }

    private boolean tryLogin(Credentials cred, HttpServletRequest request) {
        String username = cred.username;
        if (this.checkCredentials(cred)) {
            this.logger.info("##### Logging in as \"" + username + "\" => SUCCESSFUL!");
            this._login(username, request);
            return true;
        }
        this.logger.info("##### Logging in as \"" + username + "\" => FAILED!");
        return false;
    }

    private boolean checkCredentials(Credentials cred) {
        return this.dms.getAccessControl().checkCredentials(cred);
    }

    private void _login(String username, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute("username", (Object)username);
        this.logger.info("##### Creating new " + this.info(session));
        this.dms.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }

    private void _logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String username = this.username(session);
        this.logger.info("##### Logging out from " + this.info(session));
        session.invalidate();
        this.dms.fireEvent(POST_LOGOUT_USER, new Object[]{username});
    }

    private String username(HttpSession session) {
        String username = (String)session.getAttribute("username");
        if (username == null) {
            throw new RuntimeException("Session data inconsistency: \"username\" attribute is missing");
        }
        return username;
    }

    private void throw401Unauthorized() {
        String authScheme = READ_REQUIRES_LOGIN ? "Basic" : "xBasic";
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)(authScheme + " realm=" + AUTHENTICATION_REALM)).header("Content-Type", (Object)"text/html").entity((Object)"You're not authorized. Sorry.").build());
    }

    private void throw403Forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/html").entity((Object)"Access is forbidden. Sorry.").build());
    }

    private void setCreatorAndModifier(DeepaMehtaObject object) {
        try {
            String username = this.getUsername();
            if (username == null) {
                this.logger.fine("Setting the creator/modifier of " + this.info(object) + " ABORTED -- no user is logged in");
                return;
            }
            this.setCreatorAndModifier(object, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator/modifier of " + this.info(object) + " failed", e);
        }
    }

    private void setCreatorAndModifier(DeepaMehtaObject object, String username) {
        this.setCreator(object, username);
        this.setModifier(object, username);
    }

    private void setCreator(DeepaMehtaObject object, String username) {
        try {
            object.setProperty(PROP_CREATOR, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    private void setModifier(DeepaMehtaObject object) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setModifier(object, username);
    }

    private void setModifier(DeepaMehtaObject object, String username) {
        object.setProperty(PROP_MODIFIER, (Object)username, false);
    }

    private void setWorkspaceOwner(Topic workspace) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setWorkspaceOwner(workspace, username);
    }

    private void checkReadPermission(long objectId) {
        if (!this.inRequestScope()) {
            this.logger.fine("### Object " + objectId + " is accessed by \"System\" -- READ permission is granted");
            return;
        }
        String username = this.getUsername();
        if (!this.hasPermission(username, Operation.READ, objectId)) {
            throw new AccessControlException(this.userInfo(username) + " has no READ permission for object " + objectId);
        }
    }

    private Permissions getPermissions(long objectId) {
        return new Permissions().add(Operation.WRITE, this.hasPermission(this.getUsername(), Operation.WRITE, objectId));
    }

    private boolean hasPermission(String username, Operation operation, long objectId) {
        return this.dms.getAccessControl().hasPermission(username, operation, objectId);
    }

    private boolean inRequestScope() {
        try {
            this.request.getMethod();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private String info(DeepaMehtaObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssociationType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String info(HttpServletRequest request) {
        StringBuilder info = new StringBuilder();
        info.append("    " + request.getMethod() + " " + request.getRequestURI() + "\n");
        Enumeration e1 = request.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            info.append("\n    " + name + ":");
            Enumeration e2 = request.getHeaders(name);
            while (e2.hasMoreElements()) {
                String header = (String)e2.nextElement();
                info.append(" " + header);
            }
        }
        return info.toString();
    }
}

