/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.accesscontrol.model;

import com.sun.jersey.core.util.Base64;
import de.deepamehta.core.util.JavaUtils;

public class Credentials {
    private static final String ENCRYPTED_PASSWORD_PREFIX = "-SHA256-";
    public String username;
    public String password;

    public Credentials(String username, String password) {
        this.username = username;
        this.password = this.encryptPassword(password);
    }

    public Credentials(String authHeader) {
        authHeader = authHeader.substring("Basic ".length());
        String[] values = new String(Base64.base64Decode((String)authHeader)).split(":");
        this.username = values.length > 0 ? values[0] : "";
        this.password = this.encryptPassword(values.length > 1 ? values[1] : "");
    }

    public String toString() {
        return "username=\"" + this.username + "\", password=\"" + this.password + "\"";
    }

    private String encryptPassword(String password) {
        return ENCRYPTED_PASSWORD_PREFIX + JavaUtils.encodeSHA256((String)password);
    }
}

