/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.accesscontrol.model;

import de.deepamehta.plugins.accesscontrol.model.ACLEntry;
import de.deepamehta.plugins.accesscontrol.model.Operation;
import de.deepamehta.plugins.accesscontrol.model.UserRole;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class AccessControlList {
    private Map<Operation, UserRole[]> acl = new HashMap<Operation, UserRole[]>();

    public AccessControlList(ACLEntry ... aclEntries) {
        for (ACLEntry aclEntry : aclEntries) {
            this.addEntry(aclEntry);
        }
    }

    public AccessControlList(JSONObject acl) {
        try {
            Iterator i = acl.keys();
            while (i.hasNext()) {
                Operation operation = Operation.valueOf((String)i.next());
                JSONArray a = acl.getJSONArray(operation.name());
                int len = a.length();
                UserRole[] userRoles = new UserRole[len];
                for (int j = 0; j < len; ++j) {
                    userRoles[j] = UserRole.valueOf(a.getString(j));
                }
                this.addEntry(new ACLEntry(operation, userRoles));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AccessControlList failed (JSONObject=" + acl + ")", e);
        }
    }

    public UserRole[] getUserRoles(Operation operation) {
        UserRole[] userRoles = this.acl.get((Object)operation);
        return userRoles != null ? userRoles : new UserRole[]{};
    }

    public AccessControlList addEntry(ACLEntry aclEntry) {
        this.acl.put(aclEntry.getOperation(), aclEntry.getUserRoles());
        return this;
    }

    public JSONObject toJSON() {
        try {
            JSONObject json = new JSONObject();
            for (Operation operation : this.acl.keySet()) {
                json.put(operation.name(), Arrays.asList(this.getUserRoles(operation)));
            }
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }
}

